/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.board;

import com.jamesswafford.chess4j.board.squares.Direction;
import com.jamesswafford.chess4j.board.squares.East;
import com.jamesswafford.chess4j.board.squares.File;
import com.jamesswafford.chess4j.board.squares.North;
import com.jamesswafford.chess4j.board.squares.NorthEast;
import com.jamesswafford.chess4j.board.squares.NorthWest;
import com.jamesswafford.chess4j.board.squares.Rank;
import com.jamesswafford.chess4j.board.squares.South;
import com.jamesswafford.chess4j.board.squares.SouthEast;
import com.jamesswafford.chess4j.board.squares.SouthWest;
import com.jamesswafford.chess4j.board.squares.Square;
import com.jamesswafford.chess4j.board.squares.West;

public class Bitboard {
    public static long[] squares;
    public static long[] ranks;
    public static long[] files;
    public static long[][] rays;
    public static long[] knightMoves;
    public static long[] kingMoves;
    private long val;

    public Bitboard(int sq) {
        this.val = squares[sq];
    }

    public Bitboard(long val) {
        this.val = val;
    }

    public static long isolateLSB(long mask, int index) {
        int n = 0;
        for (int i = 0; i < 64; ++i) {
            if ((squares[i] & mask) == 0L) continue;
            if (n == index) {
                return squares[i];
            }
            ++n;
        }
        return 0L;
    }

    public static int lsb(long val) {
        return Long.numberOfTrailingZeros(val);
    }

    public static int msb(long val) {
        return 63 - Long.numberOfLeadingZeros(val);
    }

    public int lsb() {
        return Bitboard.lsb(this.val);
    }

    public int msb() {
        return Bitboard.msb(this.val);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 64; ++i) {
            if ((squares[i] & this.val) == 0L) {
                sb.append("0");
            } else {
                sb.append("1");
            }
            if (Square.valueOf(i).file() != File.FILE_H) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    static {
        Square sq;
        int i;
        squares = new long[64];
        ranks = new long[8];
        files = new long[8];
        rays = new long[64][8];
        knightMoves = new long[64];
        kingMoves = new long[64];
        for (i = 0; i < 64; ++i) {
            Bitboard.squares[i] = 1L << i;
        }
        for (i = 0; i < 8; ++i) {
            Bitboard.ranks[i] = 0L;
            Bitboard.files[i] = 0L;
            File f = File.file(i);
            Rank r = Rank.rank(i);
            for (int j = 0; j < 64; ++j) {
                Square sq2 = Square.valueOf(j);
                if (sq2.file() == f) {
                    int n = i;
                    files[n] = files[n] | squares[j];
                }
                if (sq2.rank() != r) continue;
                int n = i;
                ranks[n] = ranks[n] | squares[j];
            }
        }
        for (i = 0; i < 64; ++i) {
            int j;
            sq = Square.valueOf(i);
            for (j = 0; j < 8; ++j) {
                Bitboard.rays[i][j] = 0L;
            }
            for (j = 0; j < 64; ++j) {
                Direction dir;
                Square sq2 = Square.valueOf(j);
                if (sq2 == sq || (dir = Direction.directionTo[sq.value()][sq2.value()]) == null) continue;
                long[] lArray = rays[i];
                int n = dir.value();
                lArray[n] = lArray[n] | squares[j];
            }
        }
        for (i = 0; i < 64; ++i) {
            Bitboard.knightMoves[i] = 0L;
            sq = Square.valueOf(i);
            if (sq.file().eastOf(File.FILE_A)) {
                if (sq.rank().southOf(Rank.RANK_7)) {
                    int n = i;
                    knightMoves[n] = knightMoves[n] | squares[North.getInstance().next(NorthWest.getInstance().next(sq)).value()];
                }
                if (sq.rank().northOf(Rank.RANK_2)) {
                    int n = i;
                    knightMoves[n] = knightMoves[n] | squares[South.getInstance().next(SouthWest.getInstance().next(sq)).value()];
                }
            }
            if (sq.file().eastOf(File.FILE_B)) {
                if (sq.rank().southOf(Rank.RANK_8)) {
                    int n = i;
                    knightMoves[n] = knightMoves[n] | squares[NorthWest.getInstance().next(West.getInstance().next(sq)).value()];
                }
                if (sq.rank().northOf(Rank.RANK_1)) {
                    int n = i;
                    knightMoves[n] = knightMoves[n] | squares[SouthWest.getInstance().next(West.getInstance().next(sq)).value()];
                }
            }
            if (sq.file().westOf(File.FILE_G)) {
                if (sq.rank().southOf(Rank.RANK_8)) {
                    int n = i;
                    knightMoves[n] = knightMoves[n] | squares[NorthEast.getInstance().next(East.getInstance().next(sq)).value()];
                }
                if (sq.rank().northOf(Rank.RANK_1)) {
                    int n = i;
                    knightMoves[n] = knightMoves[n] | squares[SouthEast.getInstance().next(East.getInstance().next(sq)).value()];
                }
            }
            if (!sq.file().westOf(File.FILE_H)) continue;
            if (sq.rank().southOf(Rank.RANK_7)) {
                int n = i;
                knightMoves[n] = knightMoves[n] | squares[North.getInstance().next(NorthEast.getInstance().next(sq)).value()];
            }
            if (!sq.rank().northOf(Rank.RANK_2)) continue;
            int n = i;
            knightMoves[n] = knightMoves[n] | squares[South.getInstance().next(SouthEast.getInstance().next(sq)).value()];
        }
        for (i = 0; i < 64; ++i) {
            Bitboard.kingMoves[i] = 0L;
            sq = Square.valueOf(i);
            if (sq.rank().southOf(Rank.RANK_8)) {
                if (sq.file().eastOf(File.FILE_A)) {
                    int n = i;
                    kingMoves[n] = kingMoves[n] | squares[NorthWest.getInstance().next(sq).value()];
                }
                int n = i;
                kingMoves[n] = kingMoves[n] | squares[North.getInstance().next(sq).value()];
                if (sq.file().westOf(File.FILE_H)) {
                    int n2 = i;
                    kingMoves[n2] = kingMoves[n2] | squares[NorthEast.getInstance().next(sq).value()];
                }
            }
            if (sq.file().westOf(File.FILE_H)) {
                int n = i;
                kingMoves[n] = kingMoves[n] | squares[East.getInstance().next(sq).value()];
            }
            if (sq.rank().northOf(Rank.RANK_1)) {
                if (sq.file().westOf(File.FILE_H)) {
                    int n = i;
                    kingMoves[n] = kingMoves[n] | squares[SouthEast.getInstance().next(sq).value()];
                }
                int n = i;
                kingMoves[n] = kingMoves[n] | squares[South.getInstance().next(sq).value()];
                if (sq.file().eastOf(File.FILE_A)) {
                    int n3 = i;
                    kingMoves[n3] = kingMoves[n3] | squares[SouthWest.getInstance().next(sq).value()];
                }
            }
            if (!sq.file().eastOf(File.FILE_A)) continue;
            int n = i;
            kingMoves[n] = kingMoves[n] | squares[West.getInstance().next(sq).value()];
        }
    }
}

