/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.timecore.api.util.client;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;

public class DrawHelper {
    public static void drawTexturedRectByParts(float x0, float y0, float width, float height, float zLevel, float textureX, float textureY, float textureWidth, float textureHeight, float texturePartCount) {
        float portionFactor = 1.0f / texturePartCount;
        DrawHelper.drawTexturedRect(x0, y0, width, height, zLevel, textureX, textureY, textureWidth, textureHeight, portionFactor);
    }

    private static void drawTexturedRect(float x0, float y0, float width, float height, float zLevel, float textureX, float textureY, float textureWidth, float textureHeight, float textureDivideFactor) {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78374_a((double)x0, (double)y0, (double)zLevel, (double)(textureX * textureDivideFactor), (double)(textureY * textureDivideFactor));
        tess.func_78374_a((double)x0, (double)(y0 + height), (double)zLevel, (double)(textureX * textureDivideFactor), (double)((textureY + textureHeight) * textureDivideFactor));
        tess.func_78374_a((double)(x0 + width), (double)(y0 + height), (double)zLevel, (double)((textureX + textureWidth) * textureDivideFactor), (double)((textureY + textureHeight) * textureDivideFactor));
        tess.func_78374_a((double)(x0 + width), (double)y0, (double)zLevel, (double)((textureX + textureWidth) * textureDivideFactor), (double)(textureY * textureDivideFactor));
        tess.func_78381_a();
    }

    public static void drawTexturedRectByParts(float x0, float y0, float width, float height, float zLevel, float textureX, float textureY, float textureWidth, float textureHeight, float texturePartCount, int argbColor) {
        float portionFactor = 1.0f / texturePartCount;
        DrawHelper.drawTexturedRect(x0, y0, width, height, zLevel, textureX, textureY, textureWidth, textureHeight, portionFactor, argbColor);
    }

    private static void drawTexturedRect(float x0, float y0, float width, float height, float zLevel, float textureX, float textureY, float textureWidth, float textureHeight, float textureDivideFactor, int argbColor) {
        int r = DrawHelper.getRed(argbColor);
        int g = DrawHelper.getGreen(argbColor);
        int b = DrawHelper.getBlue(argbColor);
        int a = DrawHelper.getAlpha(argbColor);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78370_a(r, g, b, a);
        tess.func_78374_a((double)x0, (double)y0, (double)zLevel, (double)(textureX * textureDivideFactor), (double)(textureY * textureDivideFactor));
        tess.func_78374_a((double)x0, (double)(y0 + height), (double)zLevel, (double)(textureX * textureDivideFactor), (double)((textureY + textureHeight) * textureDivideFactor));
        tess.func_78374_a((double)(x0 + width), (double)(y0 + height), (double)zLevel, (double)((textureX + textureWidth) * textureDivideFactor), (double)((textureY + textureHeight) * textureDivideFactor));
        tess.func_78374_a((double)(x0 + width), (double)y0, (double)zLevel, (double)((textureX + textureWidth) * textureDivideFactor), (double)(textureY * textureDivideFactor));
        tess.func_78381_a();
    }

    public static void drawWidthExpandableTexturedRect(float x0, float y0, float requiredWidth, float zLevel, TexturedRect startElement, TexturedRect repeatElement, TexturedRect endElement, float texturePartCount) {
        float endWidth;
        float startWidth = startElement.width;
        float minWidth = startWidth + (endWidth = endElement.width);
        if (requiredWidth <= minWidth) {
            DrawHelper.drawTexturedRectByParts(x0, y0, startWidth, startElement.height, zLevel, startElement.textureX, startElement.textureY, startElement.textureWidth, startElement.textureHeight, texturePartCount);
            DrawHelper.drawTexturedRectByParts(x0 + startWidth, y0, endWidth, endElement.height, zLevel, endElement.textureX, endElement.textureY, endElement.textureWidth, endElement.textureHeight, texturePartCount);
        } else {
            float remainingWidth = requiredWidth - minWidth;
            float repeatWidth = repeatElement.width;
            float repeatTimes = remainingWidth / repeatWidth;
            int fullTimes = (int)repeatTimes;
            float fracPart = repeatTimes - (float)((int)repeatTimes);
            DrawHelper.drawTexturedRectByParts(x0, y0, startWidth, startElement.height, zLevel, startElement.textureX, startElement.textureY, startElement.textureWidth, startElement.textureHeight, texturePartCount);
            float extraX = startWidth;
            for (int i = 0; i < fullTimes; ++i) {
                DrawHelper.drawTexturedRectByParts(x0 + extraX, y0, repeatElement.width, repeatElement.height, zLevel, repeatElement.textureX, repeatElement.textureY, repeatElement.textureWidth, repeatElement.textureHeight, texturePartCount);
                extraX += repeatElement.width;
            }
            DrawHelper.drawTexturedRectByParts(x0 + extraX, y0, repeatWidth * fracPart, repeatElement.height, zLevel, repeatElement.textureX, repeatElement.textureY, repeatElement.textureWidth * fracPart, repeatElement.textureHeight, texturePartCount);
            DrawHelper.drawTexturedRectByParts(x0 + (extraX += repeatWidth * fracPart), y0, endWidth, endElement.height, zLevel, endElement.textureX, endElement.textureY, endElement.textureWidth, endElement.textureHeight, texturePartCount);
        }
    }

    public static int changeAlpha(int argb, int alpha) {
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("Alpha should be positive and less than 255. Provided: " + alpha);
        }
        return (argb &= 0xFFFFFF) | alpha << 24;
    }

    public static int getRed(int argb) {
        return argb >> 16 & 0xFF;
    }

    public static int getGreen(int argb) {
        return argb >> 8 & 0xFF;
    }

    public static int getBlue(int argb) {
        return argb & 0xFF;
    }

    public static int getAlpha(int argb) {
        return argb >> 24 & 0xFF;
    }

    public static void drawYCenteredStringWithShadow(FontRenderer fontRendererIn, String text, int x, int y, int color) {
        DrawHelper.drawStringWithShadow(fontRendererIn, text, x, y - fontRendererIn.field_78288_b / 2, color);
    }

    public static void drawStringWithShadow(FontRenderer fontRendererIn, String text, int x, int y, int color) {
        fontRendererIn.func_78261_a(text, x, y, color);
    }

    public static class TexturedRect {
        private final float width;
        private final float height;
        private final float textureX;
        private final float textureY;
        private final float textureWidth;
        private final float textureHeight;

        public TexturedRect(float width, float height, float textureX, float textureY, float textureWidth, float textureHeight) {
            this.width = width;
            this.height = height;
            this.textureX = textureX;
            this.textureY = textureY;
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
        }
    }
}

