/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.decorations;

import com.github.weisj.darklaf.properties.uiresource.DarkColorUIResource;
import com.github.weisj.darklaf.util.ColorUtil;
import java.awt.Color;

public interface DecorationsColorProvider {
    default public void onLafChanged() {
    }

    default public Color borderColor() {
        return this.inactiveForegroundColor();
    }

    default public TitleColor windowTitleColor() {
        return TitleColor.DARK;
    }

    public Color backgroundColor();

    default public Color hoverBackgroundColor() {
        Color background = this.backgroundColor();
        if (background == null) {
            return null;
        }
        int brightness = (int)ColorUtil.getPerceivedBrightness(background);
        if (brightness >= 125) {
            return new DarkColorUIResource(Math.max((int)((float)background.getRed() * 0.9f), 0), Math.max((int)((float)background.getGreen() * 0.9f), 0), Math.max((int)((float)background.getBlue() * 0.9f), 0));
        }
        return background.brighter();
    }

    default public Color clickBackgroundColor() {
        return this.hoverBackgroundColor();
    }

    public Color activeForegroundColor();

    public Color inactiveForegroundColor();

    default public Color windowButtonColor() {
        return this.activeForegroundColor();
    }

    default public Color inactiveWindowButtonColor() {
        return this.inactiveForegroundColor();
    }

    public static enum TitleColor {
        LIGHT,
        DARK,
        CUSTOM;

    }
}

