/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.settings;

import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.components.ColoredRadioButton;
import com.github.weisj.darklaf.components.DynamicUI;
import com.github.weisj.darklaf.components.tooltip.ToolTipContext;
import com.github.weisj.darklaf.components.tristate.TristateCheckBox;
import com.github.weisj.darklaf.components.tristate.TristateState;
import com.github.weisj.darklaf.delegate.ListCellRendererDelegate;
import com.github.weisj.darklaf.graphics.ThemedColor;
import com.github.weisj.darklaf.iconset.AllIcons;
import com.github.weisj.darklaf.layout.LayoutHelper;
import com.github.weisj.darklaf.listener.UIUpdater;
import com.github.weisj.darklaf.nativelaf.ThemePreferencesHandler;
import com.github.weisj.darklaf.platform.macos.theme.MacOSColors;
import com.github.weisj.darklaf.settings.RadioColorChooser;
import com.github.weisj.darklaf.settings.SettingsConfiguration;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.theme.spec.AccentColorRule;
import com.github.weisj.darklaf.theme.spec.FontPrototype;
import com.github.weisj.darklaf.theme.spec.FontSizePreset;
import com.github.weisj.darklaf.theme.spec.FontSizeRule;
import com.github.weisj.darklaf.ui.slider.DarkSliderUI;
import com.github.weisj.darklaf.util.Alignment;
import com.github.weisj.darklaf.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSlider;
import javax.swing.ListCellRenderer;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SliderUI;

public class ThemeSettingsUI {
    public static final String THEME_LABEL_KEY = "settings.label_theme";
    public static final String SELECTION_COLOR_LABEL_KEY = "settings.label_selection_color";
    public static final String ACCENT_COLOR_LABEL_KEY = "settings.label_accent_color";
    public static final String FONT_SIZE_LABEL_KEY = "settings.label_font_size";
    public static final String GENERAL_LABEL_KEY = "settings.title_general";
    public static final String MONITORING_LABEL_KEY = "settings.title_monitoring";
    private final SettingsUIConfiguration settingsConfiguration;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private final JComboBox<Theme> themeComboBox;
    private final RadioColorChooser selectionChooser;
    private final RadioColorChooser accentChooser;
    private final JSlider fontSlider;
    private final JCheckBox useCustomFontPrototype;
    private final JComboBox<FontEntry> fontPrototypeChooser;
    private final JComponent fontPrototypeChooserComponent;
    private final TristateCheckBox enabledSystemPreferences;
    private final JCheckBox fontSizeFollowsSystem;
    private final JCheckBox accentColorFollowsSystem;
    private final JCheckBox selectionColorFollowsSystem;
    private final JCheckBox themeFollowsSystem;

    public ThemeSettingsUI() {
        this.settingsConfiguration = new SettingsUIConfiguration();
        Color currentAccentColor = LafManager.getTheme().getAccentColorRule().getAccentColor();
        Color currentSelectionColor = LafManager.getTheme().getAccentColorRule().getSelectionColor();
        this.themeComboBox = ThemeSettingsUI.createThemeComboBox();
        this.accentChooser = ThemeSettingsUI.createAccentColorChooser(currentAccentColor);
        this.selectionChooser = ThemeSettingsUI.createSelectionColorChooser(currentSelectionColor);
        List<ColoredRadioButton> accentButtons = this.accentChooser.getRadioButtons();
        List<ColoredRadioButton> selectionButtons = this.selectionChooser.getRadioButtons();
        for (int i = 0; i < accentButtons.size(); ++i) {
            ColoredRadioButton button = accentButtons.get(i);
            ColoredRadioButton peer = selectionButtons.get(i);
            button.addActionListener(e -> {
                if (button.isSelected()) {
                    peer.setSelected(true);
                }
            });
        }
        this.fontSlider = ThemeSettingsUI.createFontSlider();
        this.useCustomFontPrototype = DynamicUI.withLocalizedText(new JCheckBox(), "settings.label_font_prototype");
        this.fontPrototypeChooser = new JComboBox<FontEntry>(FontFamiliesCache.families);
        this.fontPrototypeChooser.setPrototypeDisplayValue(FontEntry.createDisplayValue(15));
        this.fontPrototypeChooser.setRenderer((ListCellRenderer<FontEntry>)new ListCellRendererDelegate<FontEntry>(this.fontPrototypeChooser.getRenderer()){

            @Override
            public Component getListCellRendererComponent(JList<? extends FontEntry> list, FontEntry value, int index, boolean isSelected, boolean cellHasFocus) {
                Component delegate = this.getDelegate().getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (index >= 0 && value != null) {
                    delegate.setFont(value.font);
                } else {
                    delegate.setFont(ThemeSettingsUI.this.useCustomFontPrototype.getFont());
                }
                return delegate;
            }
        });
        this.fontPrototypeChooser.setEnabled(this.useCustomFontPrototype.isSelected());
        this.fontPrototypeChooserComponent = Box.createHorizontalBox();
        this.fontPrototypeChooserComponent.add(this.useCustomFontPrototype);
        this.fontPrototypeChooserComponent.add(Box.createHorizontalStrut(LayoutHelper.getDefaultSpacing()));
        this.fontPrototypeChooserComponent.add(this.fontPrototypeChooser);
        this.enabledSystemPreferences = DynamicUI.withLocalizedText(new TristateCheckBox(), "settings.check_system_preferences");
        this.accentColorFollowsSystem = ThemeSettingsUI.createSystemSettingCheckBox("settings.check_system_accent_color", ThemePreferencesHandler::supportsNativeAccentColor);
        this.selectionColorFollowsSystem = ThemeSettingsUI.createSystemSettingCheckBox("settings.check_system_selection_color", ThemePreferencesHandler::supportsNativeSelectionColor);
        this.fontSizeFollowsSystem = ThemeSettingsUI.createSystemSettingCheckBox("settings.check_system_font", ThemePreferencesHandler::supportsNativeFontSize);
        this.themeFollowsSystem = ThemeSettingsUI.createSystemSettingCheckBox("settings.check_system_theme", ThemePreferencesHandler::supportsNativeTheme);
        this.setupListeners();
    }

    private void setupListeners() {
        this.themeComboBox.addItemListener(e -> this.update());
        this.enabledSystemPreferences.addChangeListener(e -> {
            if (!this.enabledSystemPreferences.getTristateModel().isIndeterminate()) {
                boolean selected = this.enabledSystemPreferences.getTristateModel().isSelected();
                if (this.themeFollowsSystem.isEnabled()) {
                    this.themeFollowsSystem.setSelected(selected);
                }
                if (this.accentColorFollowsSystem.isEnabled()) {
                    this.accentColorFollowsSystem.setSelected(selected);
                }
                if (this.selectionColorFollowsSystem.isEnabled()) {
                    this.selectionColorFollowsSystem.setSelected(selected);
                }
                if (this.fontSizeFollowsSystem.isEnabled()) {
                    this.fontSizeFollowsSystem.setSelected(selected);
                }
            }
            this.update();
        });
        this.themeFollowsSystem.addActionListener(e -> this.update());
        this.useCustomFontPrototype.addItemListener(e -> this.fontPrototypeChooser.setEnabled(this.useCustomFontPrototype.isSelected()));
        this.accentColorFollowsSystem.addActionListener(e -> this.update());
        this.selectionColorFollowsSystem.addActionListener(e -> this.update());
        this.fontSizeFollowsSystem.addActionListener(e -> this.update());
        this.enabledSystemPreferences.setSelected(LafManager.isPreferenceChangeReportingEnabled());
    }

    private void update() {
        boolean enabled = !this.enabledSystemPreferences.getTristateModel().isDeselected();
        this.enabledSystemPreferences.setEnabled(this.settingsConfiguration.isSystemPreferencesSupported());
        this.themeFollowsSystem.setEnabled(enabled && this.settingsConfiguration.isSystemThemeSupported());
        this.accentColorFollowsSystem.setEnabled(enabled && this.settingsConfiguration.isSystemAccentColorSupported());
        this.selectionColorFollowsSystem.setEnabled(enabled && this.settingsConfiguration.isSystemSelectionColorSupported());
        this.fontSizeFollowsSystem.setEnabled(enabled && this.settingsConfiguration.isSystemFontSizeSupported());
        this.settingsConfiguration.setSystemPreferencesEnabled(this.settingsConfiguration.isSystemPreferencesEnabled());
        this.accentChooser.setEnabled(!this.settingsConfiguration.isAccentColorFollowsSystem() && this.settingsConfiguration.getSelectedTheme().supportsCustomAccentColor());
        this.selectionChooser.setEnabled(!this.settingsConfiguration.isSelectionColorFollowsSystem() && this.settingsConfiguration.getSelectedTheme().supportsCustomSelectionColor());
        this.themeComboBox.setEnabled(!this.settingsConfiguration.isThemeFollowsSystem());
        this.fontSlider.setEnabled(!this.settingsConfiguration.isFontSizeFollowsSystem());
        if (!this.listeners.isEmpty()) {
            ChangeEvent e = new ChangeEvent(this);
            for (ChangeListener listener : this.listeners) {
                listener.stateChanged(e);
            }
        }
    }

    protected void setAccentColor(Color accentColor) {
        this.accentChooser.setColor(accentColor);
    }

    protected void setSelectionColor(Color selectionColor) {
        this.selectionChooser.setColor(selectionColor);
    }

    public void loadConfiguration(SettingsConfiguration configuration) {
        this.themeComboBox.setModel(LafManager.getThemeComboBoxModel());
        this.settingsConfiguration.load(configuration);
        this.settingsConfiguration.setAccentColorRule(this.settingsConfiguration.getAccentColorRule());
        this.update();
    }

    public SettingsConfiguration getSettingsConfiguration() {
        return this.settingsConfiguration;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public JComboBox<Theme> getThemeComboBox() {
        return this.themeComboBox;
    }

    public RadioColorChooser getSelectionChooser() {
        return this.selectionChooser;
    }

    public RadioColorChooser getAccentChooser() {
        return this.accentChooser;
    }

    public JSlider getFontSlider() {
        return this.fontSlider;
    }

    public JComponent getFontPrototypeChooser() {
        return this.fontPrototypeChooserComponent;
    }

    public TristateCheckBox getSystemPreferencesTristateCheckBox() {
        return this.enabledSystemPreferences;
    }

    public JCheckBox getAccentColorFollowsSystemCheckBox() {
        return this.accentColorFollowsSystem;
    }

    public JCheckBox getSelectionColorFollowsSystemCheckBox() {
        return this.selectionColorFollowsSystem;
    }

    public JCheckBox getFontSizeFollowsSystemCheckBox() {
        return this.fontSizeFollowsSystem;
    }

    public JCheckBox getThemeFollowsSystemCheckBox() {
        return this.themeFollowsSystem;
    }

    private static JComboBox<Theme> createThemeComboBox() {
        JComboBox<Theme> comboBox = new JComboBox<Theme>(LafManager.getThemeComboBoxModel());
        comboBox.setRenderer(LafManager.getThemeListCellRenderer());
        comboBox.putClientProperty("JComboBox.isTableCellEditor", true);
        return comboBox;
    }

    private static RadioColorChooser createAccentColorChooser(Color currentAccentColor) {
        ThemedColor defaultAccentColor = new ThemedColor("themeAccentColor");
        return new RadioColorChooser(Arrays.asList(new RadioColorChooser.ColorSpec(ColoredRadioButton.DEFAULT_COLOR, defaultAccentColor, "settings.color_default"), new RadioColorChooser.ColorSpec(MacOSColors.ACCENT_BLUE, null, "settings.color_blue"), new RadioColorChooser.ColorSpec(MacOSColors.ACCENT_LILAC, null, "settings.color_lilac"), new RadioColorChooser.ColorSpec(MacOSColors.ACCENT_ROSE, null, "settings.color_rose"), new RadioColorChooser.ColorSpec(MacOSColors.ACCENT_RED, null, "settings.color_red"), new RadioColorChooser.ColorSpec(MacOSColors.ACCENT_ORANGE, null, "settings.color_orange"), new RadioColorChooser.ColorSpec(MacOSColors.ACCENT_YELLOW, null, "settings.color_yellow"), new RadioColorChooser.ColorSpec(MacOSColors.ACCENT_GREEN, null, "settings.color_green"), new RadioColorChooser.ColorSpec(MacOSColors.ACCENT_GRAPHITE, null, "settings.color_gray")), new RadioColorChooser.ColorSpec(currentAccentColor, null, "settings.color_custom"), currentAccentColor, defaultAccentColor);
    }

    private static RadioColorChooser createSelectionColorChooser(Color currentSelectionColor) {
        ThemedColor defaultSelectionColor = new ThemedColor("themeSelectionColor");
        return new RadioColorChooser(Arrays.asList(new RadioColorChooser.ColorSpec(defaultSelectionColor, ColoredRadioButton.DEFAULT_COLOR, "settings.color_default"), new RadioColorChooser.ColorSpec(MacOSColors.SELECTION_BLUE, MacOSColors.ACCENT_BLUE, "settings.color_blue"), new RadioColorChooser.ColorSpec(MacOSColors.SELECTION_PURPLE, MacOSColors.ACCENT_LILAC, "settings.color_purple"), new RadioColorChooser.ColorSpec(MacOSColors.SELECTION_PINK, MacOSColors.ACCENT_ROSE, "settings.color_pink"), new RadioColorChooser.ColorSpec(MacOSColors.SELECTION_RED, MacOSColors.ACCENT_RED, "settings.color_red"), new RadioColorChooser.ColorSpec(MacOSColors.SELECTION_ORANGE, MacOSColors.ACCENT_ORANGE, "settings.color_orange"), new RadioColorChooser.ColorSpec(MacOSColors.SELECTION_YELLOW, MacOSColors.ACCENT_YELLOW, "settings.color_yellow"), new RadioColorChooser.ColorSpec(MacOSColors.SELECTION_GREEN, MacOSColors.ACCENT_GREEN, "settings.color_green"), new RadioColorChooser.ColorSpec(MacOSColors.SELECTION_GRAPHITE, MacOSColors.ACCENT_GRAPHITE, "settings.color_gray")), new RadioColorChooser.ColorSpec(currentSelectionColor, defaultSelectionColor, "settings.color_custom"), currentSelectionColor, defaultSelectionColor);
    }

    private static JSlider createFontSlider() {
        JSlider fontSlider = new JSlider(){

            @Override
            public String getToolTipText(MouseEvent event) {
                return this.getValue() + "%";
            }
        };
        ToolTipContext context = new ToolTipContext().setAlignment(Alignment.CENTER).setCenterAlignment(Alignment.NORTH).setUseBestFit(true).setToolTipRectSupplier(e -> {
            SliderUI ui = fontSlider.getUI();
            if (ui instanceof DarkSliderUI) {
                Rectangle r = ((DarkSliderUI)ui).getThumbRect();
                --r.x;
                return r;
            }
            return new Rectangle(0, 0, fontSlider.getWidth(), fontSlider.getHeight());
        });
        fontSlider.putClientProperty("JSlider.instantScrollEnabled", true);
        fontSlider.putClientProperty("JSlider.useTrackAsBaseline", true);
        fontSlider.putClientProperty("JToolTip.toolTipContext", context);
        fontSlider.putClientProperty("JToolTip.style", "balloon");
        fontSlider.setToolTipText(String.valueOf(fontSlider.getValue()));
        fontSlider.setOrientation(0);
        fontSlider.setPaintTicks(true);
        fontSlider.setMinimum(FontSizePreset.TINY.getPercentage());
        fontSlider.setMaximum(FontSizePreset.HUGE.getPercentage());
        int tickSpacing = 25;
        Hashtable<Integer, JComponent> dict = fontSlider.createStandardLabels(tickSpacing);
        JLabel min = (JLabel)((Dictionary)dict).get(fontSlider.getMinimum());
        UIUpdater.registerComponent(min);
        min.setText("");
        min.setIcon(AllIcons.Action.DecreaseFontSize.get());
        min.setAlignmentX(0.5f);
        min.putClientProperty("JSlider.manualLabelAlign", true);
        JLabel mid = (JLabel)((Dictionary)dict).get(fontSlider.getMinimum() + tickSpacing);
        UIUpdater.registerComponent(mid);
        ((Dictionary)dict).remove(fontSlider.getMinimum() + tickSpacing);
        ((Dictionary)dict).put(FontSizePreset.NORMAL.getPercentage(), mid);
        DynamicUI.withDynamic(mid, c -> c.setText(UIManager.getString((Object)"settings.label_font_default", fontSlider.getLocale())));
        mid.setAlignmentX(0.5f);
        mid.setHorizontalTextPosition(4);
        JLabel max = (JLabel)((Dictionary)dict).get(fontSlider.getMaximum());
        max.putClientProperty("JSlider.manualLabelAlign", true);
        max.setText("");
        max.setIcon(AllIcons.Action.IncreaseFontSize.get());
        max.setAlignmentX(0.5f);
        max.putClientProperty("JSlider.manualLabelAlign", true);
        UIUpdater.registerComponent(max);
        ((Dictionary)dict).remove(FontSizePreset.Small.getPercentage());
        ((Dictionary)dict).remove(FontSizePreset.SMALL.getPercentage());
        ((Dictionary)dict).remove(FontSizePreset.Large.getPercentage());
        ((Dictionary)dict).remove(FontSizePreset.LARGE.getPercentage());
        ((Dictionary)dict).remove(FontSizePreset.Huge.getPercentage());
        fontSlider.setLabelTable(dict);
        fontSlider.setMajorTickSpacing(tickSpacing);
        fontSlider.setMinorTickSpacing(tickSpacing);
        fontSlider.setPaintLabels(true);
        fontSlider.setSnapToTicks(true);
        return fontSlider;
    }

    private static JCheckBox createSystemSettingCheckBox(String labelKey, final Function<ThemePreferencesHandler, Boolean> enabledCondition) {
        JCheckBox checkBox = DynamicUI.withLocalizedText(new JCheckBox(){

            @Override
            public void setEnabled(boolean b) {
                boolean enabled = b && (Boolean)enabledCondition.apply(ThemePreferencesHandler.getSharedInstance()) != false;
                super.setEnabled(enabled);
            }
        }, labelKey);
        checkBox.setSelected(false);
        checkBox.setEnabled(false);
        return checkBox;
    }

    private class SettingsUIConfiguration
    extends SettingsConfiguration {
        private SettingsUIConfiguration() {
        }

        @Override
        public boolean isSystemPreferencesEnabled() {
            return !ThemeSettingsUI.this.enabledSystemPreferences.getTristateModel().isDeselected() && this.isSystemPreferencesSupported();
        }

        @Override
        public boolean isAccentColorFollowsSystem() {
            return ThemeSettingsUI.this.accentColorFollowsSystem.isSelected() && this.isSystemAccentColorSupported();
        }

        @Override
        public boolean isFontSizeFollowsSystem() {
            return ThemeSettingsUI.this.fontSizeFollowsSystem.isSelected() && this.isSystemFontSizeSupported();
        }

        @Override
        public boolean isSelectionColorFollowsSystem() {
            return ThemeSettingsUI.this.selectionColorFollowsSystem.isSelected() && this.isSystemSelectionColorSupported();
        }

        @Override
        public boolean isThemeFollowsSystem() {
            return ThemeSettingsUI.this.themeFollowsSystem.isSelected() && this.isSystemThemeSupported();
        }

        @Override
        public boolean isSystemAccentColorSupported() {
            return super.isSystemAccentColorSupported() && this.getSelectedTheme().supportsCustomAccentColor();
        }

        @Override
        public boolean isSystemSelectionColorSupported() {
            return super.isSystemSelectionColorSupported() && this.getSelectedTheme().supportsCustomSelectionColor();
        }

        private Color getSelectedColor(RadioColorChooser chooser) {
            Color c = chooser.getSelectedColor();
            return Objects.equals(c, chooser.getDefaultColor()) ? null : c;
        }

        @Override
        public AccentColorRule getAccentColorRule() {
            return AccentColorRule.fromColor(this.getSelectedColor(ThemeSettingsUI.this.accentChooser), this.getSelectedColor(ThemeSettingsUI.this.selectionChooser));
        }

        @Override
        public FontSizeRule getFontSizeRule() {
            return FontSizeRule.relativeAdjustment(ThemeSettingsUI.this.fontSlider.getValue());
        }

        @Override
        public FontPrototype getFontPrototype() {
            FontEntry selected = (FontEntry)ThemeSettingsUI.this.fontPrototypeChooser.getSelectedItem();
            return ThemeSettingsUI.this.useCustomFontPrototype.isSelected() && selected != null ? FontPrototype.fromFont(selected.font) : FontPrototype.getDefault();
        }

        @Override
        public Theme getTheme() {
            return this.getSelectedTheme();
        }

        private Theme getSelectedTheme() {
            Theme selected = (Theme)ThemeSettingsUI.this.themeComboBox.getSelectedItem();
            if (selected == null) {
                selected = LafManager.getInstalledTheme();
                selected = selected != null ? selected : LafManager.getTheme();
                this.setTheme(selected);
            }
            return selected;
        }

        @Override
        public void setSystemPreferencesEnabled(boolean enabled) {
            TristateState state = TristateState.DESELECTED;
            if (!(!enabled || !this.isFontSizeFollowsSystem() && ThemeSettingsUI.this.fontSizeFollowsSystem.isEnabled() || !this.isThemeFollowsSystem() && ThemeSettingsUI.this.themeFollowsSystem.isEnabled() || !this.isAccentColorFollowsSystem() && ThemeSettingsUI.this.accentColorFollowsSystem.isEnabled() || !this.isSelectionColorFollowsSystem() && ThemeSettingsUI.this.selectionColorFollowsSystem.isEnabled())) {
                state = TristateState.SELECTED;
            } else if (enabled) {
                ThemeSettingsUI.this.enabledSystemPreferences.getTristateModel().setIndeterminate();
                return;
            }
            ThemeSettingsUI.this.enabledSystemPreferences.getTristateModel().setState(state);
        }

        @Override
        public void setAccentColorFollowsSystem(boolean accentColorFollowsSystem) {
            ThemeSettingsUI.this.accentColorFollowsSystem.setSelected(accentColorFollowsSystem && this.isSystemAccentColorSupported(false));
        }

        @Override
        public void setFontSizeFollowsSystem(boolean fontSizeFollowsSystem) {
            ThemeSettingsUI.this.fontSizeFollowsSystem.setSelected(fontSizeFollowsSystem && this.isSystemFontSizeSupported(false));
        }

        @Override
        public void setSelectionColorFollowsSystem(boolean selectionColorFollowsSystem) {
            ThemeSettingsUI.this.selectionColorFollowsSystem.setSelected(selectionColorFollowsSystem && this.isSystemSelectionColorSupported(false));
        }

        @Override
        public void setThemeFollowsSystem(boolean themeFollowsSystem) {
            ThemeSettingsUI.this.themeFollowsSystem.setSelected(themeFollowsSystem && this.isSystemThemeSupported(false));
        }

        @Override
        public void setAccentColorRule(AccentColorRule accentColorRule) {
            if (accentColorRule == null) {
                this.setAccentColorRule(null, null);
            } else {
                this.setAccentColorRule(accentColorRule.getAccentColor(), accentColorRule.getSelectionColor());
            }
        }

        protected void setAccentColorRule(Color accentColor, Color selectionColor) {
            ThemeSettingsUI.this.setAccentColor(accentColor);
            ThemeSettingsUI.this.setSelectionColor(selectionColor);
        }

        @Override
        public void setFontSizeRule(FontSizeRule fontSizeRule) {
            if (fontSizeRule == null) {
                ThemeSettingsUI.this.fontSlider.setValue(FontSizePreset.NORMAL.getPercentage());
            } else {
                ThemeSettingsUI.this.fontSlider.setValue(fontSizeRule.getPercentage());
            }
        }

        @Override
        public void setFontPrototype(FontPrototype fontPrototype) {
            boolean validPrototype;
            boolean bl = validPrototype = fontPrototype != null && fontPrototype.family() != null;
            if (validPrototype) {
                ThemeSettingsUI.this.fontPrototypeChooser.setSelectedItem(new FontEntry(fontPrototype.family()));
            }
            if (!validPrototype || ThemeSettingsUI.this.fontPrototypeChooser.getSelectedItem() == null) {
                ThemeSettingsUI.this.useCustomFontPrototype.setSelected(false);
                ThemeSettingsUI.this.fontPrototypeChooser.setSelectedItem(new FontEntry(ThemeSettingsUI.this.fontPrototypeChooser.getFont()));
            }
        }

        @Override
        public void setTheme(Theme theme) {
            ThemeSettingsUI.this.themeComboBox.setSelectedItem(LafManager.getClosestMatchForTheme(theme));
        }
    }

    private static class FontFamiliesCache {
        private static final FontEntry[] families = FontFamiliesCache.getFontFamilies();

        private FontFamiliesCache() {
        }

        private static FontEntry[] getFontFamilies() {
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            return (FontEntry[])Arrays.stream(env.getAvailableFontFamilyNames()).map(x$0 -> new FontEntry((String)x$0)).filter(e -> ((FontEntry)e).font.canDisplayUpTo(e.toString()) == -1).toArray(FontEntry[]::new);
        }

        static {
            DynamicUI.registerCallback(FontFamiliesCache.class, c -> new SwingWorker<Void, FontEntry>(){

                @Override
                protected Void doInBackground() {
                    float fontSize = new JLabel().getFont().getSize2D();
                    for (FontEntry family : families) {
                        family.font = family.font.deriveFont(fontSize);
                    }
                    return null;
                }
            }.execute(), false);
        }
    }

    private static class FontEntry {
        private final String name;
        private Font font;

        private FontEntry(Font font) {
            this.font = font;
            this.name = font.getFontName();
        }

        private FontEntry(String family) {
            this.font = new Font(family, 0, 12);
            this.name = this.font.getFontName();
        }

        private static FontEntry createDisplayValue(int displayLength) {
            return new FontEntry(displayLength);
        }

        private FontEntry(int displayLength) {
            this.font = null;
            this.name = StringUtil.repeat("A", displayLength);
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FontEntry)) {
                return false;
            }
            FontEntry fontEntry = (FontEntry)o;
            return Objects.equals(this.name, fontEntry.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }
}

