/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.combobox;

import com.github.weisj.darklaf.ui.combobox.ComboBoxConstants;
import com.github.weisj.darklaf.ui.combobox.DarkComboBoxUI;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class DarkComboBoxListener
extends MouseAdapter
implements PropertyChangeListener,
ComboBoxConstants {
    private final DarkComboBoxUI ui;
    protected final JComboBox<?> comboBox;

    public DarkComboBoxListener(DarkComboBoxUI ui, JComboBox<?> comboBox) {
        this.ui = ui;
        this.comboBox = comboBox;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.comboBox.getEditor().getEditorComponent().requestFocusInWindow();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if ("componentOrientation".equals(key)) {
            Component editorComp = this.ui.getEditorComponent();
            boolean ltr = this.comboBox.getComponentOrientation().isLeftToRight();
            if (editorComp instanceof JTextField) {
                ((JTextField)editorComp).setHorizontalAlignment(ltr ? 2 : 4);
            }
            this.comboBox.doLayout();
            this.comboBox.repaint();
        } else if ("editable".equals(key) || "enabled".equals(key)) {
            this.ui.updateBackground(this.comboBox);
            this.ui.updateForeground(this.comboBox);
            this.comboBox.repaint();
        } else if ("JComponent.isTableEditor".equals(key) || "JComponent.isTreeEditor".equals(key)) {
            this.comboBox.revalidate();
            this.comboBox.repaint();
        } else if ("editor".equals(key)) {
            PropertyUtil.installBackground(this.comboBox.getEditor().getEditorComponent(), this.ui.editBackground);
        }
    }
}

