/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.separator;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;

public class DarkSeparatorUI
extends BasicSeparatorUI {
    protected boolean resizeLock;
    protected Color color;
    protected Dimension size;
    protected Insets insets;

    public static ComponentUI createUI(JComponent c) {
        return new DarkSeparatorUI();
    }

    @Override
    protected void installDefaults(JSeparator s) {
        super.installDefaults(s);
        s.setAlignmentX(0.5f);
        this.color = UIManager.getColor("Separator.foreground");
        this.size = UIManager.getDimension("Separator.size");
        this.insets = UIManager.getInsets("Separator.insets");
        if (this.insets == null) {
            this.insets = new Insets(0, 0, 0, 0);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (!(c instanceof JSeparator)) {
            return;
        }
        this.checkSize(c);
        g.setColor(this.color);
        if (((JSeparator)c).getOrientation() == 1) {
            int height = c.getHeight() - this.insets.bottom - this.insets.top;
            int y = this.insets.top;
            if (height < this.size.height) {
                int newHeight = Math.min(this.size.height, c.getHeight());
                y = this.insets.top - (newHeight - height) / 2;
                height = newHeight;
            }
            g.fillRect(c.getWidth() / 2, y, 1, height);
        } else {
            int width = c.getWidth() - this.insets.left - this.insets.right;
            int x = this.insets.left;
            if (width < this.size.height) {
                int newWidth = Math.min(this.size.height, c.getWidth());
                x = this.insets.left - (newWidth - width) / 2;
                width = newWidth;
            }
            g.fillRect(x, c.getHeight() / 2, width, 1);
        }
    }

    private void checkSize(JComponent c) {
        if (this.resizeLock) {
            return;
        }
        Container parent = c.getParent();
        if (parent == null) {
            return;
        }
        LayoutManager lm = parent.getLayout();
        if (!(lm instanceof BoxLayout) && !(parent instanceof JToolBar)) {
            return;
        }
        this.resizeLock = true;
        Dimension dim = parent.getSize();
        Rectangle bounds = c.getBounds();
        if (((JSeparator)c).getOrientation() == 1) {
            if (bounds.height != dim.height) {
                c.setBounds(bounds.x, 0, bounds.width, dim.height);
            }
        } else if (bounds.width != dim.width) {
            c.setBounds(0, bounds.y, dim.width, bounds.height);
        }
        this.resizeLock = false;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (c == null) {
            return new Dimension(this.size);
        }
        if (((JSeparator)c).getOrientation() == 1) {
            return new Dimension(this.size.width, this.size.height);
        }
        return new Dimension(this.size.height, this.size.width);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return null;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return null;
    }
}

