/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table.renderer;

import com.github.weisj.darklaf.delegate.TableCellEditorDelegate;
import com.github.weisj.darklaf.ui.table.renderer.DarkColorTableCellRendererEditor;
import com.github.weisj.darklaf.ui.table.renderer.DarkTableCellEditor;
import com.github.weisj.darklaf.util.LazyValue;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerDateModel;
import javax.swing.table.TableCellEditor;

public class DarkMultiCellEditor
extends TableCellEditorDelegate {
    private final LazyValue<TableCellEditor> numberEditor = new LazyValue<TableCellEditor>(() -> new DarkTableCellEditor(new JSpinner()));
    private final LazyValue<TableCellEditor> dateEditor = new LazyValue<TableCellEditor>(() -> new DarkTableCellEditor(new JSpinner(new SpinnerDateModel())));
    private final LazyValue<TableCellEditor> colorEditor = new LazyValue<TableCellEditor>(DarkColorTableCellRendererEditor::new);
    private TableCellEditor currentEditor;

    public DarkMultiCellEditor() {
        super(new DarkTableCellEditor());
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.currentEditor = this.getEditor(table, value, column);
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    private TableCellEditor getEditor(JTable table, Object value, int column) {
        Class<?> columnClass = table.getColumnClass(column);
        if (value != null && PropertyUtil.getBooleanProperty(table, "Table.cellDeterminesClass")) {
            columnClass = value.getClass();
        }
        if (columnClass != null && columnClass.isInstance(value)) {
            if (Number.class.isAssignableFrom(columnClass)) {
                return this.numberEditor.get();
            }
            if (Date.class.isAssignableFrom(columnClass)) {
                return this.dateEditor.get();
            }
            if (Color.class.isAssignableFrom(columnClass)) {
                return this.colorEditor.get();
            }
        }
        return null;
    }

    @Override
    public TableCellEditor getDelegate() {
        return this.currentEditor != null ? this.currentEditor : super.getDelegate();
    }
}

