/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.togglebutton;

import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.ui.button.ButtonConstants;
import com.github.weisj.darklaf.ui.button.DarkButtonUI;
import com.github.weisj.darklaf.ui.togglebutton.DarkToggleButtonListener;
import com.github.weisj.darklaf.ui.togglebutton.ToggleButtonConstants;
import com.github.weisj.darklaf.util.graphics.GraphicsContext;
import com.github.weisj.darklaf.util.graphics.GraphicsUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;

public class DarkToggleButtonUI
extends DarkButtonUI
implements ToggleButtonConstants {
    protected boolean showSliderHints;
    protected Dimension sliderSize;
    protected Color selectedBackground;
    protected Color backgroundInactive;
    protected Color focusBorderColor;
    protected Color borderColor;
    protected Color inactiveBorderColor;
    protected Color sliderColor;
    protected Color inactiveSliderColor;
    protected Color sliderBorderColor;
    protected Color inactiveSliderBorderColor;
    protected Color selectedForeground;
    protected DarkToggleButtonListener toggleButtonListener;

    public static ComponentUI createUI(JComponent c) {
        return new DarkToggleButtonUI();
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        this.sliderSize = UIManager.getDimension("ToggleButton.sliderSize");
        this.selectedBackground = UIManager.getColor("ToggleButton.activeFillColor");
        this.backgroundInactive = UIManager.getColor("ToggleButton.inactiveFillColor");
        this.focusBorderColor = UIManager.getColor("ToggleButton.focusedSliderBorderColor");
        this.borderColor = UIManager.getColor("ToggleButton.sliderBorderColor");
        this.inactiveBorderColor = UIManager.getColor("ToggleButton.disabledSliderBorderColor");
        this.sliderColor = UIManager.getColor("ToggleButton.sliderKnobFillColor");
        this.inactiveSliderColor = UIManager.getColor("ToggleButton.disabledSliderKnobFillColor");
        this.sliderBorderColor = UIManager.getColor("ToggleButton.sliderKnobBorderColor");
        this.inactiveSliderBorderColor = UIManager.getColor("ToggleButton.disabledSliderKnobBorderColor");
        this.selectedForeground = UIManager.getColor("ToggleButton.selectedForeground");
        this.showSliderHints = UIManager.getBoolean("ToggleButton.showSliderHints");
        super.installDefaults(b);
    }

    @Override
    protected LayoutManager createLayout() {
        return new DarkToggleButtonLayout();
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        if (this.toggleButtonListener == null) {
            this.toggleButtonListener = new DarkToggleButtonListener(b, this);
        }
        return this.toggleButtonListener;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (ToggleButtonConstants.isSlider(c)) {
            GraphicsContext config = GraphicsUtil.setupStrokePainting(g);
            this.paintSlider((Graphics2D)g, (AbstractButton)c);
            config.restoreClip();
        }
        super.paint(g, c);
    }

    @Override
    protected boolean shouldDrawBackground(AbstractButton c) {
        return super.shouldDrawBackground(c) && !ToggleButtonConstants.isSlider(c);
    }

    @Override
    protected Insets getMargins(AbstractButton b) {
        if (ToggleButtonConstants.isSlider(b)) {
            boolean ltr = b.getComponentOrientation().isLeftToRight();
            int extra = 2 * this.borderSize + this.getSliderBounds((JComponent)b).width;
            int left = ltr ? extra : 0;
            int right = !ltr ? extra : 0;
            return new Insets(0, left, 0, right);
        }
        return super.getMargins(b);
    }

    private void paintSlider(Graphics2D g, AbstractButton c) {
        Rectangle bounds = this.getSliderBounds(c);
        g.translate(bounds.x, bounds.y);
        if (c.hasFocus()) {
            g.translate(-this.borderSize, -this.borderSize);
            PaintUtil.paintFocusBorder(g, bounds.width + 2 * this.borderSize, bounds.height + 2 * this.borderSize, bounds.height, this.borderSize);
            g.translate(this.borderSize, this.borderSize);
        }
        int knobSize = bounds.height;
        int arc = Math.min(bounds.width, bounds.height);
        Rectangle knobBounds = new Rectangle(0, 0, knobSize, knobSize);
        knobBounds.x = (int)((float)(bounds.width - knobBounds.width) * this.toggleButtonListener.getAnimationState());
        boolean enabled = c.isEnabled();
        Color selectedBg = this.getBackgroundColor(c, false, false, false, enabled, true);
        Color deselectedBg = this.getBackgroundColor(c, false, false, false, enabled, false);
        Shape clip = g.getClip();
        g.clipRect(0, 0, knobBounds.x + knobBounds.width / 2, bounds.height);
        g.setColor(selectedBg);
        PaintUtil.fillRoundRect(g, 0.0f, 0.0f, bounds.width, bounds.height, arc);
        g.setClip(clip);
        g.clipRect(knobBounds.x + knobBounds.width / 2, 0, bounds.width - knobBounds.width / 2, bounds.height);
        g.setColor(deselectedBg);
        PaintUtil.fillRoundRect(g, 0.0f, 0.0f, bounds.width, bounds.height, arc);
        g.setClip(clip);
        g.setColor(this.getToggleBorderColor(c));
        PaintUtil.paintLineBorder(g, 0.0f, 0.0f, bounds.width, bounds.height, arc);
        if (this.showSliderHints) {
            this.paintSliderHints(g, c, bounds, knobSize);
        }
        this.paintSliderKnob(g, c, knobBounds);
        g.translate(-bounds.x, -bounds.y);
    }

    protected void paintSliderHints(Graphics2D g, AbstractButton c, Rectangle bounds, int knobSize) {
        int pad = 5;
        int w = bounds.width - knobSize - 2 * pad;
        int y = (bounds.height - w) / 2;
        if (c.isSelected()) {
            g.setColor(this.selectedForeground);
            g.fillRect(pad + (w - 1) / 2, y, 1, w);
        } else {
            int x = knobSize + pad;
            g.setColor(this.getForegroundColor(c, false, false));
            PaintUtil.paintLineBorder(g, x, y, w, w, w);
        }
    }

    protected void paintSliderKnob(Graphics2D g, AbstractButton c, Rectangle bound) {
        g.setColor(this.getSliderColor(c));
        PaintUtil.fillRoundRect(g, bound.x, bound.y, bound.width, bound.height, bound.height);
        g.setColor(this.getSliderBorderColor(c));
        PaintUtil.paintLineBorder(g, bound.x, bound.y, bound.width, bound.height, bound.height);
    }

    @Override
    protected Color getForegroundColor(AbstractButton b, boolean defaultButton, boolean enabled) {
        if (b.isSelected() && enabled && b.getForeground() instanceof UIResource && !ToggleButtonConstants.isSlider(b) && !ButtonConstants.isBorderlessVariant(b)) {
            return this.selectedForeground;
        }
        return super.getForegroundColor(b, defaultButton, enabled);
    }

    @Override
    protected Color getBackgroundColor(AbstractButton b, boolean defaultButton, boolean rollOver, boolean clicked, boolean enabled) {
        boolean effectiveRollover = rollOver;
        boolean effectiveArmed = clicked;
        if (effectiveRollover || effectiveArmed) {
            boolean slider = !ToggleButtonConstants.isSlider(b);
            effectiveArmed &= slider;
            effectiveRollover &= slider;
        }
        return this.getBackgroundColor(b, defaultButton, effectiveRollover, effectiveArmed, enabled, b.getModel().isSelected());
    }

    protected Color getBackgroundColor(AbstractButton b, boolean defaultButton, boolean rollOver, boolean clicked, boolean enabled, boolean selected) {
        if (!enabled) {
            return this.backgroundInactive;
        }
        if (selected) {
            return this.selectedBackground;
        }
        return super.getBackgroundColor(b, defaultButton, rollOver, clicked, true);
    }

    @Override
    public boolean isRolloverBorderless(AbstractButton b) {
        return super.isRolloverBorderless(b) || b.isSelected();
    }

    @Override
    public boolean isArmedBorderless(AbstractButton b) {
        return super.isArmedBorderless(b) || b.isSelected();
    }

    protected Color getToggleBorderColor(AbstractButton b) {
        if (b.hasFocus()) {
            return this.focusBorderColor;
        }
        return b.isEnabled() ? this.borderColor : this.inactiveBorderColor;
    }

    protected Color getSliderColor(AbstractButton b) {
        return b.isEnabled() ? this.sliderColor : this.inactiveSliderColor;
    }

    protected Color getSliderBorderColor(AbstractButton b) {
        return b.isEnabled() ? this.sliderBorderColor : this.inactiveSliderBorderColor;
    }

    protected Rectangle getSliderBounds(JComponent c) {
        Rectangle r = new Rectangle();
        Insets ins = c.getInsets();
        int x = ins.left;
        int height = c.getHeight() - ins.bottom - ins.top;
        int y = ins.top + (height - this.sliderSize.height) / 2;
        r.x = x;
        r.y = y;
        r.width = this.sliderSize.width;
        r.height = this.sliderSize.height;
        if (!c.getComponentOrientation().isLeftToRight()) {
            r.x = c.getWidth() - ins.right - r.x - r.width;
        }
        return r;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension dim = super.getPreferredSize(c);
        if (ToggleButtonConstants.isSlider(c)) {
            Insets ins = c.getInsets();
            dim.height = Math.max(dim.height, this.sliderSize.height + ins.top + ins.bottom);
        }
        return dim;
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        if (!ToggleButtonConstants.isSlider(c)) {
            return super.contains(c, x, y);
        }
        if (c instanceof JToggleButton) {
            Rectangle bounds = this.getSliderBounds(c);
            int arc = Math.min(bounds.width, bounds.height);
            hitArea.setRoundRect(bounds.x, bounds.y, bounds.width, bounds.height, arc, arc);
        }
        return hitArea.contains(x, y);
    }

    protected class DarkToggleButtonLayout
    extends DarkButtonUI.DarkButtonLayout {
        protected DarkToggleButtonLayout() {
        }

        @Override
        protected int getHorizontalAlignment(AbstractButton b) {
            if (ToggleButtonConstants.isSlider(b)) {
                int horizontalPos = 2;
                if (!b.getComponentOrientation().isLeftToRight()) {
                    horizontalPos = 4;
                }
                return horizontalPos;
            }
            return super.getHorizontalAlignment(b);
        }
    }
}

