/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.util;

import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColorUtil {
    private ColorUtil() {
    }

    public static Color withAlpha(@NotNull Color c, float alpha) {
        int a = Math.max(Math.min(255, (int)(alpha * 255.0f)), 0);
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), a);
    }

    public static String toString(@Nullable Color c) {
        if (c == null) {
            return "null";
        }
        return String.format("Color[%d,%d,%d,%d]", c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
    }

    public static void RGBtoHSL(int r, int g, int b, float @NotNull [] hsl) {
        float s;
        float h;
        float var_Max;
        float var_Min;
        if (r < 0) {
            r = 0;
        } else if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        } else if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        } else if (b > 255) {
            b = 255;
        }
        float var_R = (float)r / 255.0f;
        float var_G = (float)g / 255.0f;
        float var_B = (float)b / 255.0f;
        if (var_R > var_G) {
            var_Min = var_G;
            var_Max = var_R;
        } else {
            var_Min = var_R;
            var_Max = var_G;
        }
        if (var_B > var_Max) {
            var_Max = var_B;
        }
        if (var_B < var_Min) {
            var_Min = var_B;
        }
        float del_Max = var_Max - var_Min;
        float l = (var_Max + var_Min) / 2.0f;
        if (del_Max - 0.01f <= 0.0f) {
            h = 0.0f;
            s = 0.0f;
        } else {
            s = l < 0.5f ? del_Max / (var_Max + var_Min) : del_Max / (2.0f - var_Max - var_Min);
            float del_R = ((var_Max - var_R) / 6.0f + del_Max / 2.0f) / del_Max;
            float del_G = ((var_Max - var_G) / 6.0f + del_Max / 2.0f) / del_Max;
            float del_B = ((var_Max - var_B) / 6.0f + del_Max / 2.0f) / del_Max;
            h = var_R == var_Max ? del_B - del_G : (var_G == var_Max ? 0.33333334f + del_R - del_B : 0.6666667f + del_G - del_R);
            if (h < 0.0f) {
                h += 1.0f;
            }
            if (h > 1.0f) {
                h -= 1.0f;
            }
        }
        hsl[0] = h;
        hsl[1] = s;
        hsl[2] = l;
    }

    public static void HSLtoRGB(float h, float s, float l, int @NotNull [] rgb) {
        int b;
        int g;
        int r;
        if (h < 0.0f) {
            h = 0.0f;
        } else if (h > 1.0f) {
            h = 1.0f;
        }
        if (s < 0.0f) {
            s = 0.0f;
        } else if (s > 1.0f) {
            s = 1.0f;
        }
        if (l < 0.0f) {
            l = 0.0f;
        } else if (l > 1.0f) {
            l = 1.0f;
        }
        if (s - 0.01f <= 0.0f) {
            r = (int)(l * 255.0f);
            g = (int)(l * 255.0f);
            b = (int)(l * 255.0f);
        } else {
            float var_2 = l < 0.5f ? l * (1.0f + s) : l + s - s * l;
            float var_1 = 2.0f * l - var_2;
            r = (int)(255.0f * ColorUtil.hue2RGB(var_1, var_2, h + 0.33333334f));
            g = (int)(255.0f * ColorUtil.hue2RGB(var_1, var_2, h));
            b = (int)(255.0f * ColorUtil.hue2RGB(var_1, var_2, h - 0.33333334f));
        }
        rgb[0] = r;
        rgb[1] = g;
        rgb[2] = b;
    }

    private static float hue2RGB(float v1, float v2, float vH) {
        if (vH < 0.0f) {
            vH += 1.0f;
        }
        if (vH > 1.0f) {
            vH -= 1.0f;
        }
        if (6.0f * vH < 1.0f) {
            return v1 + (v2 - v1) * 6.0f * vH;
        }
        if (2.0f * vH < 1.0f) {
            return v2;
        }
        if (3.0f * vH < 2.0f) {
            return v1 + (v2 - v1) * (0.6666667f - vH) * 6.0f;
        }
        return v1;
    }
}

