/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.properties.color;

import com.github.weisj.darklaf.properties.color.DarkColorModel;
import com.github.weisj.darklaf.util.LazyValue;
import java.awt.Color;

public class DarkColorModelHSL
extends DarkColorModel {
    private static final int[] hsl = new int[3];
    private static final int[] rgb = new int[3];
    private static final LazyValue<DarkColorModelHSL> instance = new LazyValue<DarkColorModelHSL>(DarkColorModelHSL::new);

    public static DarkColorModelHSL getInstance() {
        return instance.get();
    }

    public DarkColorModelHSL() {
        super("hsl", "Hue", "Saturation", "Lightness");
    }

    @Override
    public int getMinimum(int index) {
        return 0;
    }

    @Override
    public int getMaximum(int index) {
        return index == 0 ? 359 : 100;
    }

    @Override
    public String toString() {
        return "HSL";
    }

    @Override
    public String[] getLabelDescriptorsBefore() {
        return new String[]{"H", "S", "L"};
    }

    @Override
    public String[] getLabelDescriptorsAfter() {
        return new String[]{"\u00b0", "%", "%"};
    }

    @Override
    public int[] getValuesFromColor(Color color) {
        return DarkColorModelHSL.RGBtoHSL(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static Color getColorFromHSLValues(double h, double s, double l) {
        int[] rgb = DarkColorModelHSL.HSLtoRGB(h, s, l);
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public static double[] RGBtoHSLValues(int r, int g, int b) {
        double max = DarkColorModelHSL.max(r, g, b) / 255.0;
        double min = DarkColorModelHSL.min(r, g, b) / 255.0;
        double summa = max + min;
        double saturation = max - min;
        if (saturation > 0.0) {
            saturation /= summa > 1.0 ? 2.0 - summa : summa;
        }
        return new double[]{DarkColorModelHSL.getHue((double)r / 255.0, (double)g / 255.0, (double)b / 255.0, max, min), saturation, summa / 2.0};
    }

    private static int[] RGBtoHSL(int r, int g, int b) {
        double[] values = DarkColorModelHSL.RGBtoHSLValues(r, g, b);
        DarkColorModelHSL.hsl[0] = (int)Math.round(360.0 * values[0]);
        DarkColorModelHSL.hsl[1] = (int)Math.round(100.0 * values[1]);
        DarkColorModelHSL.hsl[2] = (int)Math.round(100.0 * values[2]);
        return hsl;
    }

    protected static double max(double red, double green, double blue) {
        double max = Math.max(red, green);
        return Math.max(max, blue);
    }

    protected static double min(double red, double green, double blue) {
        double min = Math.min(red, green);
        return Math.min(min, blue);
    }

    private static double getHue(double red, double green, double blue, double max, double min) {
        double hue = max - min;
        if (hue > 0.0) {
            if (max == red) {
                if ((hue = (green - blue) / hue) < 0.0) {
                    hue += 6.0;
                }
            } else {
                hue = max == green ? 2.0 + (blue - red) / hue : 4.0 + (red - green) / hue;
            }
            hue /= 6.0;
        }
        return hue;
    }

    @Override
    public Color getColorFromValues(int[] values) {
        int[] rgb = DarkColorModelHSL.HSLtoRGB((double)values[0] / 360.0, (double)values[1] / 100.0, (double)values[2] / 100.0);
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    private static int[] HSLtoRGB(double h, double saturation, double lightness) {
        double hue;
        for (hue = h; hue < 0.0; hue += 1.0) {
        }
        hue -= Math.floor(hue);
        if (saturation > 0.0) {
            hue = hue < 1.0 ? hue * 6.0 : 0.0;
            double q = lightness + saturation * (lightness > 0.5 ? 1.0 - lightness : lightness);
            double p = 2.0 * lightness - q;
            DarkColorModelHSL.rgb[0] = (int)Math.round(255.0 * DarkColorModelHSL.normalize(q, p, hue < 4.0 ? hue + 2.0 : hue - 4.0));
            DarkColorModelHSL.rgb[1] = (int)Math.round(255.0 * DarkColorModelHSL.normalize(q, p, hue));
            DarkColorModelHSL.rgb[2] = (int)Math.round(255.0 * DarkColorModelHSL.normalize(q, p, hue < 2.0 ? hue + 4.0 : hue - 2.0));
        } else {
            DarkColorModelHSL.rgb[0] = (int)Math.round(255.0 * lightness);
            DarkColorModelHSL.rgb[1] = rgb[0];
            DarkColorModelHSL.rgb[2] = rgb[0];
        }
        return rgb;
    }

    private static double normalize(double q, double p, double color) {
        if (color < 1.0) {
            return p + (q - p) * color;
        }
        if (color < 3.0) {
            return q;
        }
        if (color < 4.0) {
            return p + (q - p) * (4.0 - color);
        }
        return p;
    }
}

