/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.properties.icons;

import com.github.weisj.darklaf.properties.icons.EmptyIcon;
import com.github.weisj.darklaf.properties.icons.RotateIcon;
import com.github.weisj.darklaf.util.Alignment;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;

public class RotatableIcon
implements Icon {
    private Icon icon;
    private Alignment alignment;
    private double angle;

    public RotatableIcon() {
        this(null);
    }

    public RotatableIcon(Icon icon) {
        this.setIcon(icon);
    }

    public void setIcon(Icon icon) {
        this.icon = icon == null ? EmptyIcon.create(0) : icon;
    }

    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.icon instanceof RotateIcon) {
            ((RotateIcon)((Object)this.icon)).paintIcon(c, g, x, y, this.getAngle());
        } else if (this.icon != null) {
            Graphics2D g2 = (Graphics2D)g.create();
            AffineTransform transform = new AffineTransform();
            transform.rotate(this.getAngle(), (double)x + (double)this.getIconWidth() / 2.0, (double)y + (double)this.getIconHeight() / 2.0);
            g2.transform(transform);
            this.icon.paintIcon(c, g2, x, y);
        }
    }

    public double getAngle() {
        return this.angle;
    }

    @Override
    public int getIconWidth() {
        return this.icon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.icon.getIconHeight();
    }

    public Alignment getOrientation() {
        return this.alignment;
    }

    public void setOrientation(Alignment alignment) {
        this.alignment = alignment != null ? alignment : Alignment.NORTH;
        this.angle = this.alignment.getAngle();
    }

    public void setRotation(double angle) {
        this.alignment = null;
        this.angle = angle;
    }
}

