/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.colorchooser;

import com.github.weisj.darklaf.ui.colorchooser.ColorPreviewComponent;
import com.github.weisj.darklaf.ui.colorchooser.MainSwatchPanel;
import com.github.weisj.darklaf.ui.colorchooser.RecentSwatchPanel;
import com.github.weisj.darklaf.ui.colorchooser.SwatchPanel;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;

public class DarkSwatchesChooserPanel
extends AbstractColorChooserPanel {
    private SwatchPanel swatchPanel;
    private RecentSwatchPanel recentSwatchPanel;
    private ColorPreviewComponent previewPanel;
    private MouseListener mainSwatchListener;
    private MouseListener recentSwatchListener;
    private KeyListener mainSwatchKeyListener;
    private KeyListener recentSwatchKeyListener;

    public DarkSwatchesChooserPanel() {
        this.setInheritsPopupMenu(true);
    }

    @Override
    public void updateChooser() {
    }

    @Override
    protected void buildChooser() {
        this.setLayout(new BoxLayout(this, 1));
        String recentStr = UIManager.getString((Object)"ColorChooser.swatchesRecentText", this.getLocale());
        this.previewPanel = new ColorPreviewComponent();
        this.previewPanel.setColor(this.getColorFromModel());
        this.swatchPanel = new MainSwatchPanel();
        this.swatchPanel.putClientProperty("AccessibleName", this.getDisplayName());
        this.swatchPanel.setInheritsPopupMenu(true);
        this.recentSwatchPanel = new RecentSwatchPanel();
        this.recentSwatchPanel.putClientProperty("AccessibleName", recentStr);
        this.mainSwatchKeyListener = new MainSwatchKeyListener();
        this.mainSwatchListener = new MainSwatchListener();
        this.swatchPanel.addMouseListener(this.mainSwatchListener);
        this.swatchPanel.addKeyListener(this.mainSwatchKeyListener);
        this.recentSwatchListener = new RecentSwatchListener();
        this.recentSwatchKeyListener = new RecentSwatchKeyListener();
        this.recentSwatchPanel.addMouseListener(this.recentSwatchListener);
        this.recentSwatchPanel.addKeyListener(this.recentSwatchKeyListener);
        JPanel mainHolder = new JPanel(new GridBagLayout());
        LineBorder border = new LineBorder(UIManager.getColor("ColorChooser.swatchBorderColor"));
        this.swatchPanel.setBorder(border);
        mainHolder.add(this.swatchPanel);
        this.recentSwatchPanel.setInheritsPopupMenu(true);
        JPanel recentHolder = new JPanel(new GridBagLayout());
        this.recentSwatchPanel.setBorder(border);
        recentHolder.setInheritsPopupMenu(true);
        recentHolder.add(this.recentSwatchPanel);
        JLabel l = new JLabel(recentStr);
        l.setLabelFor(this.recentSwatchPanel);
        JPanel labelHolder = new JPanel(new FlowLayout(0));
        labelHolder.add(l);
        JPanel previewHolder = new JPanel(new BorderLayout());
        previewHolder.add(Box.createVerticalStrut(25), "West");
        previewHolder.add((Component)this.previewPanel, "Center");
        previewHolder.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        JPanel swatches = new JPanel();
        swatches.setInheritsPopupMenu(true);
        swatches.setLayout(new BoxLayout(swatches, 1));
        swatches.add(mainHolder);
        swatches.add(labelHolder);
        swatches.add(recentHolder);
        this.add(previewHolder);
        this.add(swatches);
    }

    @Override
    public String getDisplayName() {
        return UIManager.getString((Object)"ColorChooser.swatchesNameText", this.getLocale());
    }

    @Override
    public int getDisplayedMnemonicIndex() {
        return PropertyUtil.getMnemonic("ColorChooser.swatchesLabelMnemonic", this.getLocale());
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public void installChooserPanel(JColorChooser enclosingChooser) {
        super.installChooserPanel(enclosingChooser);
    }

    @Override
    public void uninstallChooserPanel(JColorChooser enclosingChooser) {
        super.uninstallChooserPanel(enclosingChooser);
        this.swatchPanel.removeMouseListener(this.mainSwatchListener);
        this.swatchPanel.removeKeyListener(this.mainSwatchKeyListener);
        this.recentSwatchPanel.removeMouseListener(this.recentSwatchListener);
        this.recentSwatchPanel.removeKeyListener(this.recentSwatchKeyListener);
        this.swatchPanel = null;
        this.recentSwatchPanel = null;
        this.mainSwatchListener = null;
        this.mainSwatchKeyListener = null;
        this.recentSwatchListener = null;
        this.recentSwatchKeyListener = null;
        this.removeAll();
    }

    protected void setSelectedColor(Color color) {
        ColorSelectionModel model = this.getColorSelectionModel();
        this.previewPanel.setColor(color);
        if (model != null) {
            model.setSelectedColor(color);
        }
    }

    protected class MainSwatchKeyListener
    extends KeyAdapter {
        protected MainSwatchKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (32 == e.getKeyCode()) {
                Color color = DarkSwatchesChooserPanel.this.swatchPanel.getSelectedColor();
                DarkSwatchesChooserPanel.this.setSelectedColor(color);
                DarkSwatchesChooserPanel.this.recentSwatchPanel.setMostRecentColor(color);
            }
        }
    }

    protected class MainSwatchListener
    extends MouseAdapter
    implements Serializable {
        protected MainSwatchListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (DarkSwatchesChooserPanel.this.isEnabled()) {
                Color color = DarkSwatchesChooserPanel.this.swatchPanel.getColorForLocation(e.getX(), e.getY());
                DarkSwatchesChooserPanel.this.setSelectedColor(color);
                DarkSwatchesChooserPanel.this.swatchPanel.setSelectedColorFromLocation(e.getX(), e.getY());
                DarkSwatchesChooserPanel.this.recentSwatchPanel.setMostRecentColor(color);
                DarkSwatchesChooserPanel.this.swatchPanel.requestFocusInWindow();
            }
        }
    }

    protected class RecentSwatchListener
    extends MouseAdapter
    implements Serializable {
        protected RecentSwatchListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (DarkSwatchesChooserPanel.this.isEnabled()) {
                Color color = DarkSwatchesChooserPanel.this.recentSwatchPanel.getColorForLocation(e.getX(), e.getY());
                DarkSwatchesChooserPanel.this.recentSwatchPanel.setSelectedColorFromLocation(e.getX(), e.getY());
                DarkSwatchesChooserPanel.this.setSelectedColor(color);
                DarkSwatchesChooserPanel.this.recentSwatchPanel.requestFocusInWindow();
            }
        }
    }

    protected class RecentSwatchKeyListener
    extends KeyAdapter {
        protected RecentSwatchKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (32 == e.getKeyCode()) {
                Color color = DarkSwatchesChooserPanel.this.recentSwatchPanel.getSelectedColor();
                DarkSwatchesChooserPanel.this.setSelectedColor(color);
            }
        }
    }
}

