/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabbedpane;

import com.github.weisj.darklaf.ui.tabbedpane.DarkTabbedPaneUI;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;

public class TabbedPaneUtil
implements SwingConstants {
    private static final Rectangle EMPTY_RECT = new Rectangle(0, 0, 0, 0);

    public static int getDroppedTabIndex(Rectangle tabBounds, JTabbedPane tabbedPane, DarkTabbedPaneUI ui, Point p) {
        int tab = tabbedPane.indexAtLocation(p.x, p.y);
        if (ui != null) {
            if (tab == -1) {
                Rectangle bounds = ui.getTabAreaBounds();
                if (bounds.contains(p)) {
                    int tabPlacement;
                    if (tabbedPane.getTabCount() > 0) {
                        int x;
                        Rectangle minb = ui.getTabBounds(tabbedPane, 0);
                        Rectangle maxb = ui.getTabBounds(tabbedPane, tabbedPane.getTabCount() - 1);
                        if (tabbedPane.getComponentOrientation().isLeftToRight()) {
                            x = Math.max(bounds.x, minb.x);
                            bounds.width = Math.min(bounds.x + bounds.width - x, maxb.x + maxb.width - x);
                            bounds.x = x;
                        } else {
                            x = Math.max(bounds.x, maxb.x);
                            bounds.width = Math.min(bounds.x + bounds.width - x, minb.x + minb.width - x);
                            bounds.x = x;
                        }
                        int y = Math.max(bounds.y, minb.y);
                        bounds.height = Math.min(bounds.y + bounds.height - y, maxb.x + maxb.height - y);
                    }
                    if ((tabPlacement = tabbedPane.getTabPlacement()) == 1 || tabPlacement == 3) {
                        tab = tabbedPane.getComponentOrientation().isLeftToRight() ? (p.x <= bounds.x + bounds.width / 2 ? 0 : tabbedPane.getTabCount()) : (p.x >= bounds.x + bounds.width / 2 ? 1 : tabbedPane.getTabCount());
                    } else if (tabPlacement == 2 || tabPlacement == 4) {
                        tab = p.y <= bounds.y + bounds.height / 2 ? 0 : tabbedPane.getTabCount();
                    }
                }
            } else if (tab < tabbedPane.getTabCount()) {
                Rectangle b = tabbedPane.getBoundsAt(tab);
                if (tab >= 1 && !ui.scrollableTabLayoutEnabled()) {
                    Rectangle prev = tabbedPane.getBoundsAt(tab - 1);
                    if (b.y + b.height < p.y && prev.y <= p.y && p.y <= prev.y + prev.height) {
                        b = prev;
                    }
                }
                Rectangle sb = ui.scrollableTabLayoutEnabled() ? tabBounds : EMPTY_RECT;
                switch (tabbedPane.getTabPlacement()) {
                    case 1: 
                    case 3: {
                        if (tabbedPane.getComponentOrientation().isLeftToRight()) {
                            if (p.x < b.x + sb.width + (b.width - sb.width) / 2) break;
                            ++tab;
                            break;
                        }
                        if (p.x > b.x + (b.width - sb.width) / 2) break;
                        ++tab;
                        break;
                    }
                    case 2: 
                    case 4: {
                        if (p.y < b.y + sb.height + (b.height - sb.height) / 2) break;
                        ++tab;
                    }
                }
            }
        } else if (tab == -1) {
            tab = tabbedPane.getTabCount();
        }
        return tab;
    }

    public static Rectangle getDropRect(DarkTabbedPaneUI ui, JTabbedPane destTabbedPane, JTabbedPane source, Point mouseLocation, Rectangle tabBounds, int tab, int sourceIndex, int lastTab) {
        if (destTabbedPane.getTabCount() == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int tabPlacement = destTabbedPane.getTabPlacement();
        Rectangle destRect = destTabbedPane.getBoundsAt(Math.min(tab, destTabbedPane.getTabCount() - 1));
        if (ui.scrollableTabLayoutEnabled()) {
            TabbedPaneUtil.calculateDropRectScrollLayout(destTabbedPane, source, tabBounds, tab, sourceIndex, lastTab, tabPlacement, destRect);
        } else {
            TabbedPaneUtil.calculateDropRectWrapLayout(ui, destTabbedPane, source, mouseLocation, tabBounds, tab, sourceIndex, destRect);
        }
        return tabBounds;
    }

    private static void calculateDropRectScrollLayout(JTabbedPane destTabbedPane, JTabbedPane source, Rectangle tabBounds, int tab, int sourceIndex, int lastTab, int tabPlacement, Rectangle destRect) {
        boolean lastInSource = false;
        if (destTabbedPane == source && (tab == sourceIndex || sourceIndex == source.getTabCount() - 1 && tab == source.getTabCount())) {
            lastInSource = true;
            destRect.width = tabBounds.width;
            destRect.height = tabBounds.height;
        }
        switch (tabPlacement) {
            case 1: 
            case 3: {
                if (destTabbedPane.getComponentOrientation().isLeftToRight()) {
                    if (tab >= destTabbedPane.getTabCount() && !lastInSource) {
                        destRect.x += destRect.width;
                    }
                    tabBounds.x = destRect.x;
                    if (lastTab != -1 && lastTab < tab) {
                        tabBounds.x -= tabBounds.width;
                    }
                } else {
                    if (tab >= destTabbedPane.getTabCount()) {
                        destRect.x -= 2 * tabBounds.width;
                        if (lastTab < tab) {
                            destRect.x += destRect.width;
                        }
                    }
                    tabBounds.x = destRect.x + tabBounds.width;
                    if (lastTab != -1 && lastTab > tab) {
                        tabBounds.x -= tabBounds.width;
                    }
                }
                tabBounds.y = destRect.y + destRect.height - tabBounds.height;
                break;
            }
            case 2: 
            case 4: {
                if (tab >= destTabbedPane.getTabCount()) {
                    destRect.y += destRect.height;
                }
                tabBounds.y = destRect.y;
                tabBounds.x = destRect.x + destRect.width - tabBounds.width;
                if (lastTab == -1 || lastTab >= tab) break;
                tabBounds.y -= tabBounds.height;
            }
        }
    }

    private static void calculateDropRectWrapLayout(DarkTabbedPaneUI ui, JTabbedPane destTabbedPane, JTabbedPane source, Point mouseLocation, Rectangle tabBounds, int tab, int sourceIndex, Rectangle destRect) {
        if (source == destTabbedPane && (tab == sourceIndex || tab == sourceIndex + 1)) {
            tabBounds.setRect(0.0, 0.0, 0.0, 0.0);
        } else {
            Rectangle prev;
            int placement = destTabbedPane.getTabPlacement();
            Rectangle b = ui.getTabAreaBounds();
            Rectangle rectangle = prev = tab > 0 ? destTabbedPane.getBoundsAt(tab - 1) : EMPTY_RECT;
            if (placement == 2 || placement == 4) {
                DarkUIUtil.rotateRectangle(tabBounds);
                DarkUIUtil.rotateRectangle(destRect);
                DarkUIUtil.rotateRectangle(prev);
                DarkUIUtil.rotateRectangle(b);
                DarkUIUtil.rotatePoint(mouseLocation);
            }
            if (tab == destTabbedPane.getTabCount()) {
                tabBounds.x = destRect.x + destRect.width / 2;
                tabBounds.width = Math.min(b.x + b.width - tabBounds.x, tabBounds.width);
            } else if (tab == 0) {
                tabBounds.x = destRect.x;
                tabBounds.width = Math.min(tabBounds.width / 2, destRect.width / 2);
            } else {
                int diff;
                if (destRect.y + destRect.height <= mouseLocation.y && prev.y <= mouseLocation.y && mouseLocation.y <= prev.y + prev.height) {
                    destRect.x = prev.x + prev.width;
                    destRect.y = prev.y;
                    destRect.height = prev.height;
                }
                tabBounds.x = destRect.x;
                tabBounds.setLocation(destRect.getLocation());
                tabBounds.x -= tabBounds.width / 2;
                if (tabBounds.x < b.x) {
                    diff = b.x - tabBounds.x;
                    tabBounds.width -= diff;
                    tabBounds.x = b.x;
                }
                if (tabBounds.x + tabBounds.width > b.x + b.width) {
                    diff = tabBounds.width + tabBounds.x - b.width - b.x;
                    tabBounds.width -= diff;
                }
            }
            tabBounds.y = destRect.y + destRect.height - tabBounds.height;
            if (placement == 2 || placement == 4) {
                DarkUIUtil.rotateRectangle(tabBounds);
            }
        }
    }

    public static boolean moveTabs(JTabbedPane sourcePane, JTabbedPane tabbedPane, int sourceIndex, int tab) {
        if (tabbedPane == sourcePane && sourceIndex == tab) {
            Component comp = sourcePane.getTabComponentAt(tab);
            if (comp != null) {
                comp.setVisible(true);
            }
            TabbedPaneUtil.selectTab(sourcePane, sourceIndex);
            return false;
        }
        int destIndex = tab;
        if (tabbedPane.getTabCount() == 0) {
            destIndex = 0;
        }
        if (destIndex < 0 || destIndex > tabbedPane.getTabCount()) {
            return false;
        }
        String tabName = sourcePane.getTitleAt(sourceIndex);
        Icon icon = sourcePane.getIconAt(sourceIndex);
        Component comp = sourcePane.getComponentAt(sourceIndex);
        String toolTip = sourcePane.getToolTipTextAt(sourceIndex);
        Color foreground = sourcePane.getForegroundAt(sourceIndex);
        Component tabComp = sourcePane.getTabComponentAt(sourceIndex);
        sourcePane.removeTabAt(sourceIndex);
        int index = destIndex;
        if (tabbedPane == sourcePane && sourceIndex < index) {
            --index;
        }
        tabbedPane.insertTab(tabName, icon, comp, toolTip, index);
        if (tabComp != null) {
            tabComp.setVisible(true);
            tabbedPane.setTabComponentAt(index, tabComp);
        }
        tabbedPane.setForegroundAt(index, foreground);
        TabbedPaneUtil.selectTab(tabbedPane, index);
        sourcePane.revalidate();
        return true;
    }

    protected static void selectTab(JTabbedPane tabbedPane, int index) {
        SwingUtilities.invokeLater(() -> {
            tabbedPane.setSelectedIndex(index);
            tabbedPane.requestFocusInWindow();
        });
    }
}

