/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table;

import com.github.weisj.darklaf.compatibility.SwingUtil;
import com.github.weisj.darklaf.components.OverlayScrollPane;
import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.ui.HasRendererPane;
import com.github.weisj.darklaf.ui.cell.CellUtil;
import com.github.weisj.darklaf.ui.cell.DarkBooleanCellRenderer;
import com.github.weisj.darklaf.ui.cell.DarkCellRendererPane;
import com.github.weisj.darklaf.ui.cell.hint.CellHintPopupListener;
import com.github.weisj.darklaf.ui.table.DarkTableUIBridge;
import com.github.weisj.darklaf.ui.table.TableCellContainer;
import com.github.weisj.darklaf.ui.table.TableConstants;
import com.github.weisj.darklaf.ui.table.TableUIBridge;
import com.github.weisj.darklaf.ui.table.renderer.DarkColorTableCellRendererEditor;
import com.github.weisj.darklaf.ui.table.renderer.DarkTableCellEditorDelegate;
import com.github.weisj.darklaf.ui.table.renderer.DarkTableCellRenderer;
import com.github.weisj.darklaf.ui.table.renderer.DarkTableCellRendererDelegate;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import com.github.weisj.darklaf.util.Pair;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.CellRendererPane;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DarkTableUI
extends DarkTableUIBridge
implements TableConstants,
HasRendererPane {
    private static final int ROW_HEIGHT_FALLBACK = 22;
    private static final boolean CELL_POPUP_ENABLED = false;
    protected Color selectionBackgroundNoFocus;
    protected Color selectionBackground;
    protected Color borderColor;
    protected TableUIBridge.Handler handler;
    protected CellHintPopupListener<JTable, ?> popupListener;
    private TableCellRenderer cellRenderer;
    private DarkColorTableCellRendererEditor colorRendererEditor;
    private TableCellRenderer booleanCellRenderer;
    private TableCellEditor cellEditor;
    private TableCellRenderer oldObjectRenderer;
    private TableCellRenderer oldBooleanRenderer;
    private TableCellEditor oldObjectEditor;
    private TableCellEditor oldNumberEditor;
    private TableCellEditor oldBooleanEditor;
    protected DarkTableCellRendererDelegate rendererDelegate;

    public static ComponentUI createUI(JComponent c) {
        return new DarkTableUI();
    }

    @Override
    protected boolean pointOutsidePrefSize(int row, int column, Point p) {
        return false;
    }

    @Override
    protected FocusListener createFocusListener() {
        return this.getHandler();
    }

    @Override
    protected KeyListener createKeyListener() {
        return this.getHandler();
    }

    @Override
    protected TableUIBridge.Handler getHandler() {
        if (this.handler == null) {
            this.handler = new DarkHandler(super.createKeyListener(), super.createFocusListener());
        }
        return this.handler;
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        Container oldUnwrapped = DarkUIUtil.getUnwrappedParent(this.table.getParent());
        LookAndFeel.uninstallBorder((JComponent)oldUnwrapped);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        int rowHeight = UIManager.getInt("Table.rowHeight");
        if (rowHeight > 0) {
            LookAndFeel.installProperty(this.table, "rowHeight", 22);
        }
        PropertyUtil.installBooleanProperty(this.table, "JTable.renderBooleanAsCheckBox", "Table.renderBooleanAsCheckBox");
        PropertyUtil.installBooleanProperty(this.table, "JTable.alternateRowColor", "Table.alternateRowColor");
        PropertyUtil.installBooleanProperty(this.table, "terminateEditOnFocusLost", "Table.terminateEditOnFocusLost");
        PropertyUtil.installProperty(this.table, "JTable.booleanRenderType", UIManager.getString("Table.booleanRenderType"));
        this.table.setFillsViewportHeight(true);
        this.installRenderers(this.table);
        this.borderColor = UIManager.getColor("TableHeader.borderColor");
        this.selectionBackground = UIManager.getColor("Table.backgroundSelected");
        this.selectionBackgroundNoFocus = UIManager.getColor("Table.backgroundSelectedNoFocus");
        this.rendererPane = this.createCellRendererPane();
        this.table.setSurrendersFocusOnKeystroke(true);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallRenderers(this.table);
        super.uninstallUI(c);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
    }

    protected CellHintPopupListener<JTable, ?> createPopupMouseListener() {
        return new CellHintPopupListener<JTable, Pair<Integer, Integer>>(new TableCellContainer(this.table, this));
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.popupListener != null) {
            this.popupListener.uninstall();
            this.popupListener = null;
        }
        this.handler = null;
    }

    protected CellRendererPane createCellRendererPane() {
        return new DarkCellRendererPane();
    }

    private TableCellEditor installEditor(JTable table, Class<?> type, TableCellEditor renderer) {
        TableCellEditor oldRenderer = table.getDefaultEditor(type);
        if (PropertyUtil.canOverwrite(oldRenderer) || Objects.equals(oldRenderer.getClass().getEnclosingClass(), JTable.class)) {
            table.setDefaultEditor(type, renderer);
        }
        return oldRenderer;
    }

    private TableCellRenderer installRenderer(JTable table, Class<?> type, TableCellRenderer renderer) {
        TableCellRenderer oldRenderer = table.getDefaultRenderer(type);
        if (PropertyUtil.canOverwrite(oldRenderer)) {
            table.setDefaultRenderer(type, renderer);
        }
        return oldRenderer;
    }

    private void installRenderers(JTable table) {
        this.booleanCellRenderer = new DarkBooleanCellRenderer(true);
        this.cellRenderer = new DarkTableCellRenderer();
        this.cellEditor = new DarkTableCellEditorDelegate();
        this.colorRendererEditor = new DarkColorTableCellRendererEditor();
        this.oldObjectRenderer = this.installRenderer(table, Object.class, this.cellRenderer);
        this.oldBooleanRenderer = this.installRenderer(table, Boolean.class, this.booleanCellRenderer);
        this.installRenderer(table, Color.class, this.colorRendererEditor);
        this.oldObjectEditor = this.installEditor(table, Object.class, this.cellEditor);
        this.oldNumberEditor = this.installEditor(table, Number.class, this.cellEditor);
        this.oldBooleanEditor = this.installEditor(table, Boolean.class, this.cellEditor);
        this.installEditor(table, Color.class, this.colorRendererEditor);
    }

    private void uninstallRenderers(JTable table) {
        if (table.getDefaultRenderer(Object.class) == this.cellRenderer) {
            table.setDefaultRenderer(Object.class, this.oldObjectRenderer);
            if (this.oldObjectRenderer instanceof JComponent) {
                ((JComponent)((Object)this.oldObjectRenderer)).updateUI();
            }
        }
        if (table.getDefaultRenderer(Boolean.class) == this.booleanCellRenderer) {
            table.setDefaultRenderer(Boolean.class, this.oldBooleanRenderer);
            if (this.oldBooleanRenderer instanceof JComponent) {
                ((JComponent)((Object)this.oldBooleanRenderer)).updateUI();
            }
        }
        if (table.getDefaultRenderer(Color.class) == this.colorRendererEditor) {
            table.setDefaultRenderer(Color.class, null);
        }
        this.uninstallEditor(Object.class, this.oldObjectEditor, this.cellEditor);
        this.uninstallEditor(Number.class, this.oldNumberEditor, this.cellEditor);
        this.uninstallEditor(Boolean.class, this.oldBooleanEditor, this.cellEditor);
        if (table.getDefaultEditor(Color.class) == this.colorRendererEditor) {
            table.setDefaultEditor(Color.class, null);
        }
    }

    private void uninstallEditor(Class<?> type, TableCellEditor old, TableCellEditor current) {
        if (this.table.getDefaultEditor(type) == current) {
            Component comp;
            this.table.setDefaultEditor(type, old);
            if (old instanceof DefaultCellEditor && (comp = ((DefaultCellEditor)old).getComponent()) instanceof JComponent) {
                ((JComponent)comp).updateUI();
            }
        }
    }

    @Override
    protected void paintGrid(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        block12: {
            g.setColor(this.table.getGridColor());
            Rectangle minCell = this.table.getCellRect(rMin, cMin, true);
            Rectangle maxCell = this.table.getCellRect(rMax, cMax, true);
            Rectangle damagedArea = minCell.union(maxCell);
            JTableHeader header = this.table.getTableHeader();
            int draggedIndex = -1;
            if (header != null) {
                draggedIndex = this.viewIndexForColumn(header.getDraggedColumn());
            }
            if (this.table.getShowHorizontalLines()) {
                int tableWidth = damagedArea.x + damagedArea.width;
                if (this.table.getComponentOrientation().isLeftToRight()) {
                    if (draggedIndex >= 0 && draggedIndex == cMax) {
                        --tableWidth;
                    }
                } else if (draggedIndex >= 0 && draggedIndex == cMin) {
                    --tableWidth;
                }
                int y = damagedArea.y;
                for (int row = rMin; row <= rMax; ++row) {
                    PaintUtil.drawHLine(g, damagedArea.x, tableWidth - 1, (y += this.table.getRowHeight(row)) - 1);
                }
            }
            boolean scrollPaneRtl = this.isScrollPaneRtl();
            boolean scrollVisible = this.scrollBarVisible();
            if (!this.table.getShowVerticalLines()) break block12;
            TableColumnModel cm = this.table.getColumnModel();
            int tableHeight = this.table.getHeight();
            boolean ltr = this.table.getComponentOrientation().isLeftToRight();
            int x = damagedArea.x;
            if (scrollPaneRtl && this.scrollBarVisible()) {
                PaintUtil.drawVLine(g, x, 0, tableHeight - 1);
            }
            if (ltr) {
                for (int column = cMin; column <= cMax; ++column) {
                    int w = cm.getColumn(column).getWidth();
                    x += w;
                    if (!this.showVerticalLine(true, scrollVisible, !scrollPaneRtl, column, draggedIndex, cMin, cMax)) continue;
                    PaintUtil.drawVLine(g, x - 1, 0, tableHeight - 1);
                }
            } else {
                for (int column = cMax; column >= cMin; --column) {
                    int w = cm.getColumn(column).getWidth();
                    x += w;
                    if (!this.showVerticalLine(false, scrollVisible, !scrollPaneRtl, column, draggedIndex, cMin, cMax)) continue;
                    PaintUtil.drawVLine(g, x - 1, 0, tableHeight - 1);
                }
            }
        }
    }

    protected boolean isScrollPaneRtl() {
        if (!this.isInScrollPane()) {
            return false;
        }
        Container comp = DarkUIUtil.getUnwrappedParent(this.table).getParent();
        return !comp.getComponentOrientation().isLeftToRight();
    }

    protected boolean scrollBarVisible() {
        JScrollPane comp = DarkUIUtil.getParentOfType(JScrollPane.class, this.table, 2);
        if (comp == null) {
            return false;
        }
        OverlayScrollPane overlayScrollPane = DarkUIUtil.getParentOfType(OverlayScrollPane.class, this.table, 3);
        return overlayScrollPane == null && comp.getVerticalScrollBar().isVisible();
    }

    protected boolean showVerticalLine(boolean ltr, boolean scrollVisible, boolean scrollLtR, int column, int draggedIndex, int cMin, int cMax) {
        boolean isDragged;
        JTableHeader header = this.table.getTableHeader();
        int dist = header != null ? DarkTableUI.adjustDistance(header.getDraggedDistance(), this.table.getCellRect(0, draggedIndex, true), this.table) : 0;
        boolean bl = isDragged = column == draggedIndex && dist != 0;
        if (!scrollVisible) {
            if (ltr) {
                return column != cMax;
            }
            return column != cMin;
        }
        if (ltr) {
            if (scrollLtR) {
                return column != cMax || !isDragged;
            }
            return column != cMax;
        }
        if (scrollLtR) {
            return column != cMin || !isDragged;
        }
        return column != cMin;
    }

    protected boolean isInScrollPane() {
        Container comp = DarkUIUtil.getUnwrappedParent(this.table);
        if (comp != null) {
            comp = comp.getParent();
        }
        return comp instanceof JScrollPane;
    }

    @Override
    protected void paintDraggedArea(Graphics g, int rMin, int rMax, int cMin, int cMax, TableColumn draggedColumn, int distance) {
        Container par;
        int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
        Rectangle minCell = this.table.getCellRect(rMin, draggedColumnIndex, true);
        Rectangle maxCell = this.table.getCellRect(rMax, draggedColumnIndex, true);
        Rectangle vacatedColumnRect = minCell.union(maxCell);
        int dist = DarkTableUI.adjustDistance(distance, vacatedColumnRect, this.table);
        Container parent = this.table.getParent();
        if (this.isInScrollPane() && (par = DarkUIUtil.getUnwrappedParent(this.table).getParent()) != null && par.getParent() != null) {
            parent = par.getParent();
        }
        int tableHeight = this.table.getHeight();
        g.setColor(parent.getBackground());
        int width = vacatedColumnRect.width;
        if (draggedColumnIndex < cMax) {
            --width;
        }
        g.fillRect(vacatedColumnRect.x, 0, width, tableHeight);
        vacatedColumnRect.x += dist;
        boolean ltr = this.table.getComponentOrientation().isLeftToRight();
        g.setColor(this.table.getBackground());
        g.fillRect(vacatedColumnRect.x, 0, vacatedColumnRect.width, tableHeight);
        if (this.table.getShowVerticalLines()) {
            boolean onRightEdge;
            boolean onLeftEdge;
            g.setColor(this.table.getGridColor());
            int x1 = vacatedColumnRect.x;
            int y1 = 0;
            int x2 = x1 + vacatedColumnRect.width - 1;
            int y2 = y1 + tableHeight;
            boolean bl = ltr ? draggedColumnIndex == cMin : (onLeftEdge = draggedColumnIndex == cMax);
            boolean bl2 = ltr ? draggedColumnIndex == cMax : (onRightEdge = draggedColumnIndex == cMin);
            if (this.scrollBarVisible()) {
                if (this.isScrollPaneRtl()) {
                    onLeftEdge = false;
                } else {
                    onRightEdge = false;
                }
            }
            if (dist != 0 || !onLeftEdge) {
                if (draggedColumnIndex == cMin && this.scrollBarVisible() && this.isScrollPaneRtl()) {
                    ++x1;
                }
                g.fillRect(x1 - 1, y1, 1, y2 - y1);
            }
            if (dist != 0 || !onRightEdge) {
                g.fillRect(x2, y1, 1, y2 - y1);
            }
        }
        for (int row = rMin; row <= rMax; ++row) {
            Rectangle r = this.table.getCellRect(row, draggedColumnIndex, false);
            r.x += dist;
            this.paintCell(g, r, row, draggedColumnIndex, cMin, cMax);
            if (!this.table.getShowHorizontalLines()) continue;
            g.setColor(this.table.getGridColor());
            Rectangle rcr = this.table.getCellRect(row, draggedColumnIndex, true);
            rcr.x += dist;
            int x1 = rcr.x;
            int y1 = rcr.y;
            int x2 = x1 + rcr.width;
            int y2 = y1 + rcr.height - 1;
            g.fillRect(x1, y2, x2 - x1, 1);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.table.getShowVerticalLines()) {
            Rectangle r = g.getClipBounds();
            int spacing = this.table.getColumnModel().getColumnMargin();
            if (r.x + r.width == c.getWidth() - spacing) {
                r.x += r.width;
                r.width = spacing;
                c.repaint(r);
            }
        }
        super.paint(g, c);
    }

    public static boolean ignoreKeyCodeOnEdit(KeyEvent event, JTable table) {
        if (event != null) {
            int keyCode = event.getKeyCode();
            switch (keyCode) {
                case 12: 
                case 20: 
                case 27: 
                case 36: 
                case 144: 
                case 145: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 524: 
                case 525: 
                case 65406: {
                    return true;
                }
            }
            if (table == null) {
                return false;
            }
            KeyStroke stroke = KeyStroke.getKeyStroke(event.getExtendedKeyCode(), event.getModifiersEx());
            String actionName = String.valueOf(table.getInputMap(1).get(stroke));
            if ("null".equals(actionName)) {
                actionName = null;
            }
            String cutActionName = String.valueOf(TransferHandler.getCutAction().getValue("Name"));
            String copyActionName = String.valueOf(TransferHandler.getCopyAction().getValue("Name"));
            return Objects.equals(actionName, copyActionName) || Objects.equals(actionName, cutActionName);
        }
        return false;
    }

    @Override
    protected void paintCell(Graphics g, Rectangle r, int row, int column, int cMin, int cMax) {
        boolean isEditorCell = this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column;
        int x = r.x;
        int y = r.y;
        int w = r.width;
        int h = r.height;
        if (this.table.getShowVerticalLines() && !this.scrollBarVisible() && column == this.table.getColumnCount() - 1) {
            ++w;
        }
        if (isEditorCell && !this.table.getShowVerticalLines()) {
            if (column > cMin) {
                --x;
            }
            if (column > cMin && column < cMax) {
                ++w;
            }
        }
        if (isEditorCell) {
            Component component = this.table.getEditorComponent();
            component.setBounds(x, y, w, h);
            component.validate();
        } else {
            TableCellRenderer renderer = this.getCellRenderer(row, column);
            Component component = this.table.prepareRenderer(renderer, row, column);
            CellUtil.setSelectedFlag(component, this.table.isCellSelected(row, column));
            this.rendererPane.paintComponent(g, component, this.table, x, y, w, h, true);
        }
    }

    protected TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer = this.table.getCellRenderer(row, column);
        if (renderer instanceof DarkTableCellRendererDelegate) {
            return renderer;
        }
        if (this.rendererDelegate == null) {
            this.rendererDelegate = new DarkTableCellRendererDelegate(renderer, this.booleanCellRenderer);
        }
        this.rendererDelegate.setDelegate(renderer);
        return this.rendererDelegate;
    }

    public static int adjustDistance(int distance, Rectangle rect, JTable comp) {
        int dist = distance;
        int min = 0;
        int max = comp.getWidth();
        if (rect.x + dist <= min) {
            dist = min - rect.x;
        }
        if (rect.x + rect.width + dist >= max) {
            dist = max - rect.x - rect.width;
        }
        return dist;
    }

    @Override
    public Container getRendererPane() {
        return this.rendererPane;
    }

    protected class DarkHandler
    extends TableUIBridge.Handler {
        protected int lastIndex;

        protected DarkHandler(KeyListener keyListener, FocusListener focusListener) {
            super(DarkTableUI.this, keyListener, focusListener);
            this.lastIndex = -1;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            if (DarkTableUI.this.isFileList && SwingUtilities.isLeftMouseButton(e)) {
                boolean isSelected;
                int row = DarkTableUI.this.table.rowAtPoint(e.getPoint());
                JFileChooser fc = this.getFileChooser();
                if (row < 0 || fc == null) {
                    return;
                }
                int column = this.getFileNameColumnIndex();
                boolean bl = isSelected = DarkTableUI.this.table.getSelectionModel().getLeadSelectionIndex() == row && DarkTableUI.this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex() == column;
                if ((!fc.isMultiSelectionEnabled() || fc.getSelectedFiles().length <= 1) && isSelected && this.lastIndex == row && DarkUIUtil.isOverText(e, row, column, DarkTableUI.this.table)) {
                    this.startEditing(row, column);
                } else {
                    this.lastIndex = row;
                }
            }
        }

        protected JFileChooser getFileChooser() {
            Object obj = PropertyUtil.getObject(DarkTableUI.this.table, "JTable.fileChooserParent", Supplier.class, Object::new).get();
            return obj instanceof JFileChooser ? (JFileChooser)obj : null;
        }

        protected Integer getFileNameColumnIndex() {
            return PropertyUtil.getInteger(DarkTableUI.this.table, "JTable.fileNameColumnIndex");
        }

        protected void startEditing(int row, int column) {
            DarkTableUI.this.table.editCellAt(row, column, null);
            Component editorComponent = DarkTableUI.this.table.getEditorComponent();
            if (editorComponent != null && !editorComponent.hasFocus()) {
                SwingUtil.compositeRequestFocus(editorComponent);
            }
        }

        @Override
        protected void maybeStartTimer() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (DarkTableUI.ignoreKeyCodeOnEdit(e, DarkTableUI.this.table)) {
                e.consume();
                return;
            }
            super.keyTyped(e);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            super.propertyChange(e);
            String key = e.getPropertyName();
            if ("showHorizontalLines".equals(key)) {
                boolean b = Boolean.TRUE.equals(e.getNewValue());
                DarkTableUI.this.table.setRowMargin(b ? 1 : 0);
            } else if ("showVerticalLines".equals(key)) {
                boolean b = Boolean.TRUE.equals(e.getNewValue());
                TableColumnModel cm = DarkTableUI.this.table.getColumnModel();
                cm.setColumnMargin(b ? 1 : 0);
            } else if ("ancestor".equals(key)) {
                Container newUnwrapped;
                Object oldVal = e.getOldValue();
                Object newVal = e.getNewValue();
                if (oldVal instanceof Component) {
                    Container oldUnwrapped = DarkUIUtil.getUnwrappedParent((Component)oldVal);
                    LookAndFeel.uninstallBorder((JComponent)oldUnwrapped);
                }
                if (newVal instanceof Component && (newUnwrapped = DarkUIUtil.getUnwrappedParent((Component)newVal)) instanceof JScrollPane) {
                    LookAndFeel.installBorder((JComponent)newUnwrapped, "Table.scrollPaneBorder");
                }
                this.checkFocus();
            } else if ("componentOrientation".equals(key)) {
                DarkTableUI.this.table.doLayout();
                DarkTableUI.this.table.repaint();
            } else if ("JTable.alternateRowColor".equals(key) || "JTable.renderBooleanAsCheckBox".equals(key) || "JTable.booleanRenderType".equals(key)) {
                DarkTableUI.this.table.repaint();
            } else if ("enabled".equals(key)) {
                DarkUIUtil.repaint(DarkTableUI.this.table.getTableHeader());
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            Component comp;
            Color bg = DarkTableUI.this.table.getSelectionBackground();
            if (bg instanceof UIResource) {
                DarkTableUI.this.table.setSelectionBackground(DarkTableUI.this.selectionBackground);
            }
            if ((comp = DarkTableUI.this.table.getEditorComponent()) != null) {
                Color newBg = CellUtil.getTableBackground(comp, DarkTableUI.this.table, true, true, DarkTableUI.this.table.getEditingRow());
                CellUtil.setupBackground(comp, newBg);
            }
            DarkTableUI.this.table.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            Component comp;
            Color bg = DarkTableUI.this.table.getSelectionBackground();
            if (bg instanceof UIResource) {
                if (DarkTableUI.this.table.isEditing()) {
                    DarkTableUI.this.table.setSelectionBackground(DarkTableUI.this.table.getBackground());
                } else {
                    DarkTableUI.this.table.setSelectionBackground(DarkTableUI.this.selectionBackgroundNoFocus);
                }
            }
            if ((comp = DarkTableUI.this.table.getEditorComponent()) != null && !DarkUIUtil.hasFocus(comp, e)) {
                Color newBg = CellUtil.getTableBackground(comp, DarkTableUI.this.table, true, false, DarkTableUI.this.table.getEditingRow());
                CellUtil.setupBackground(comp, newBg);
            }
            DarkTableUI.this.table.repaint();
        }

        protected void checkFocus() {
            boolean focus = DarkUIUtil.hasFocus(DarkTableUI.this.table);
            if (focus) {
                this.focusGained(null);
            } else {
                this.focusLost(null);
            }
        }
    }
}

