/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.togglebutton;

import com.github.weisj.darklaf.graphics.Animator;
import com.github.weisj.darklaf.graphics.DefaultInterpolator;
import com.github.weisj.darklaf.ui.button.DarkButtonListener;
import com.github.weisj.darklaf.ui.togglebutton.DarkToggleButtonUI;
import com.github.weisj.darklaf.ui.togglebutton.ToggleButtonConstants;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;

public class DarkToggleButtonListener
extends DarkButtonListener<DarkToggleButtonUI>
implements ToggleButtonConstants {
    private final SliderAnimator animator;
    private final AbstractButton button;
    private boolean selected;

    public DarkToggleButtonListener(AbstractButton b, DarkToggleButtonUI ui) {
        super(b, ui);
        this.selected = b.isSelected();
        this.button = b;
        this.animator = this.createAnimator();
        this.animator.setEnabled(UIManager.getBoolean("ToggleButton.animated"));
        this.animator.state = this.selected ? 1.0f : 0.0f;
    }

    protected SliderAnimator createAnimator() {
        return new SliderAnimator(this.button);
    }

    public float getAnimationState() {
        return this.animator.getState();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        AbstractButton b = (AbstractButton)evt.getSource();
        String key = evt.getPropertyName();
        if ("JToggleButton.variant".equals(key)) {
            Object oldVal = evt.getOldValue();
            Object newVal = evt.getNewValue();
            if (oldVal != null && oldVal.equals(newVal)) {
                return;
            }
            b.setBorderPainted(!"slider".equals(newVal));
            ((DarkToggleButtonUI)this.ui).updateMargins(b);
        } else if ("componentOrientation".equals(key)) {
            b.doLayout();
            b.repaint();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        super.stateChanged(e);
        if (!ToggleButtonConstants.isSlider(this.button)) {
            return;
        }
        boolean sel = this.button.isSelected();
        if (sel != this.selected) {
            if (!this.animator.pause()) {
                this.animator.reset();
            }
            this.selected = sel;
            float endState = sel ? 1.0f : 0.0f;
            this.animator.animationBounds = ((DarkToggleButtonUI)this.ui).getSliderBounds(this.button);
            this.animator.reverse = !sel;
            this.animator.setEndValue(endState);
            this.animator.resume(this.button);
        }
    }

    protected static class SliderAnimator
    extends Animator {
        private final JComponent c;
        private float state;
        private float endValue;
        private boolean reverse;
        private Rectangle animationBounds;

        public SliderAnimator(JComponent c) {
            super(100L, DefaultInterpolator.EASE_OUT_QUAD);
            this.c = c;
        }

        public float getState() {
            return this.state;
        }

        @Override
        public void paintAnimationFrame(float fraction) {
            this.state = this.reverse ? 1.0f - fraction : fraction;
            this.repaint();
        }

        @Override
        protected void onAnimationFinished() {
            this.state = this.endValue;
            this.repaint();
            this.animationBounds = null;
        }

        private void repaint() {
            if (this.c != null) {
                this.c.paintImmediately(this.animationBounds != null ? this.animationBounds : this.c.getVisibleRect());
            }
        }

        public void setEndValue(float endValue) {
            this.endValue = endValue;
        }
    }
}

