/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify;

import com.google.common.base.Throwables;
import cpw.mods.fml.common.FMLLog;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.gen.structure.StructureStrongholdPieces;
import org.apache.commons.lang3.ArrayUtils;

public class EnumHelper {
    private static Class[][] commonTypes = new Class[][]{{EnumAction.class}, {ItemArmor.ArmorMaterial.class, Integer.TYPE, int[].class, Integer.TYPE}, {EntityPainting.EnumArt.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, {EnumCreatureAttribute.class}, {EnumCreatureType.class, Class.class, Integer.TYPE, Material.class, Boolean.TYPE, Boolean.TYPE}, {StructureStrongholdPieces.Stronghold.Door.class}, {EnumEnchantmentType.class}, {Entity.EnumEntitySize.class}, {BlockPressurePlate.Sensitivity.class}, {MovingObjectPosition.MovingObjectType.class}, {EnumSkyBlock.class, Integer.TYPE}, {EntityPlayer.EnumStatus.class}, {Item.ToolMaterial.class, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE}, {EnumRarity.class, EnumChatFormatting.class, String.class}};
    private static final Map<Class<? extends Enum<?>>, Map<String, Enum<?>>> enumConstants = new HashMap();
    private static final Class<?> extensibleEnumIface;
    private static final MethodHandle setFieldHandle;

    public static EnumAction addAction(String name) {
        return EnumHelper.addEnum(EnumAction.class, name, new Object[0]);
    }

    public static ItemArmor.ArmorMaterial addArmorMaterial(String name, int durability, int[] reductionAmounts, int enchantability) {
        return EnumHelper.addEnum(ItemArmor.ArmorMaterial.class, name, durability, reductionAmounts, enchantability);
    }

    public static EntityPainting.EnumArt addArt(String name, String tile, int sizeX, int sizeY, int offsetX, int offsetY) {
        return EnumHelper.addEnum(EntityPainting.EnumArt.class, name, tile, sizeX, sizeY, offsetX, offsetY);
    }

    public static EnumCreatureAttribute addCreatureAttribute(String name) {
        return EnumHelper.addEnum(EnumCreatureAttribute.class, name, new Object[0]);
    }

    public static EnumCreatureType addCreatureType(String name, Class typeClass, int maxNumber, Material material, boolean peaceful, boolean animal) {
        return EnumHelper.addEnum(EnumCreatureType.class, name, typeClass, maxNumber, material, peaceful, animal);
    }

    public static StructureStrongholdPieces.Stronghold.Door addDoor(String name) {
        return EnumHelper.addEnum(StructureStrongholdPieces.Stronghold.Door.class, name, new Object[0]);
    }

    public static EnumEnchantmentType addEnchantmentType(String name) {
        return EnumHelper.addEnum(EnumEnchantmentType.class, name, new Object[0]);
    }

    public static Entity.EnumEntitySize addEntitySize(String name) {
        return EnumHelper.addEnum(Entity.EnumEntitySize.class, name, new Object[0]);
    }

    public static BlockPressurePlate.Sensitivity addSensitivity(String name) {
        return EnumHelper.addEnum(BlockPressurePlate.Sensitivity.class, name, new Object[0]);
    }

    public static MovingObjectPosition.MovingObjectType addMovingObjectType(String name) {
        return EnumHelper.addEnum(MovingObjectPosition.MovingObjectType.class, name, new Object[0]);
    }

    public static EnumSkyBlock addSkyBlock(String name, int lightValue) {
        return EnumHelper.addEnum(EnumSkyBlock.class, name, lightValue);
    }

    public static EntityPlayer.EnumStatus addStatus(String name) {
        return EnumHelper.addEnum(EntityPlayer.EnumStatus.class, name, new Object[0]);
    }

    public static Item.ToolMaterial addToolMaterial(String name, int harvestLevel, int maxUses, float efficiency, float damage, int enchantability) {
        return EnumHelper.addEnum(Item.ToolMaterial.class, name, harvestLevel, maxUses, Float.valueOf(efficiency), Float.valueOf(damage), enchantability);
    }

    public static EnumRarity addRarity(String name, EnumChatFormatting color, String displayName) {
        return EnumHelper.addEnum(EnumRarity.class, name, color, displayName);
    }

    public static void setFailsafeFieldValue(Field field, Object target, Object value) throws Exception {
        try {
            setFieldHandle.invokeExact(field, target, value);
        }
        catch (Throwable e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public static <T extends Enum<?>> T addEnum(Class<T> enumType, String enumName, Object ... paramValues) {
        return EnumHelper.addEnum(commonTypes, enumType, enumName, paramValues);
    }

    public static <T extends Enum<?>> T addEnum(Class[][] map, Class<T> enumType, String enumName, Object ... paramValues) {
        for (Class[] lookup : map) {
            if (lookup[0] != enumType) continue;
            Class[] paramTypes = new Class[lookup.length - 1];
            if (paramTypes.length > 0) {
                System.arraycopy(lookup, 1, paramTypes, 0, paramTypes.length);
            }
            return EnumHelper.addEnum(enumType, enumName, paramTypes, paramValues);
        }
        return null;
    }

    public static <T extends Enum<?>> T addEnum(Class<T> enumType, String enumName, Class<?>[] paramTypes, Object[] paramValues) {
        if (!extensibleEnumIface.isAssignableFrom(enumType)) {
            throw new RuntimeException("Enum " + enumType.getName() + " was not made extensible, add it to lwjgl3ify configs.");
        }
        Map<Class<? extends Enum<?>>, Map<String, Enum<?>>> map = enumConstants;
        synchronized (map) {
            Map enumMap = enumConstants.computeIfAbsent(enumType, k -> new HashMap());
            if (enumMap.containsKey(enumName.toUpperCase())) {
                String newName;
                int suffix = 1;
                do {
                    newName = enumName + "$" + suffix;
                    ++suffix;
                } while (enumMap.containsKey(newName.toUpperCase()));
                FMLLog.info((String)String.format("Duplicate Enum found for %s mapping to %s", enumName, newName), (Object[])new Object[0]);
                enumName = newName;
            }
            try {
                paramTypes = (Class[])ArrayUtils.add((Object[])paramTypes, (int)0, String.class);
                paramValues = ArrayUtils.add((Object[])paramValues, (int)0, (Object)enumName);
                Method creatorHandle = enumType.getMethod("dynamicCreate", paramTypes);
                Enum newValue = (Enum)creatorHandle.invoke(null, paramValues);
                enumMap.put(enumName.toUpperCase(), newValue);
                return (T)newValue;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to add enum constant: " + enumName, e);
            }
        }
    }

    public static void setup() {
    }

    public static Object getConstructorAccessor(Class<?> enumClass, Class<?>[] additionalParameterTypes) {
        return null;
    }

    public static <T extends Enum<?>> T makeEnum(Class<T> enumClass, String value, int ordinal, Class<?>[] additionalTypes, Object[] additionalValues) {
        return null;
    }

    public static void blankField(Class<?> enumClass, String fieldName) {
    }

    public static void cleanEnumCache(Class<?> enumClass) {
    }

    static {
        try {
            extensibleEnumIface = Class.forName("me.eigenraven.lwjgl3ify.IExtensibleEnum");
            Class<?> unsafeHacks = Class.forName("me.eigenraven.lwjgl3ify.UnsafeHacks");
            Method setFieldM = unsafeHacks.getMethod("setField", Field.class, Object.class, Object.class);
            setFieldHandle = MethodHandles.publicLookup().unreflect(setFieldM);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

