/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.properties.parser;

import com.github.weisj.darklaf.properties.parser.ActiveObjectParser;
import com.github.weisj.darklaf.properties.parser.DimensionParser;
import com.github.weisj.darklaf.properties.parser.FallbackParser;
import com.github.weisj.darklaf.properties.parser.FontParser;
import com.github.weisj.darklaf.properties.parser.IconParser;
import com.github.weisj.darklaf.properties.parser.InsetParser;
import com.github.weisj.darklaf.properties.parser.LazyObjectParser;
import com.github.weisj.darklaf.properties.parser.ListParser;
import com.github.weisj.darklaf.properties.parser.MapParser;
import com.github.weisj.darklaf.properties.parser.NullParser;
import com.github.weisj.darklaf.properties.parser.ParseResult;
import com.github.weisj.darklaf.properties.parser.ParserContext;
import com.github.weisj.darklaf.properties.parser.ParserUtil;
import com.github.weisj.darklaf.properties.parser.PrimitiveParser;
import com.github.weisj.darklaf.properties.parser.PropertyParser;
import com.github.weisj.darklaf.properties.parser.ReferenceParser;
import java.util.Arrays;
import java.util.List;

public final class Parser {
    public static final Object EMPTY_VALUE = new Object();
    private static final List<PropertyParser> steps = Arrays.asList(new NullParser(), new FallbackParser(), new ReferenceParser(), new PrimitiveParser(), new InsetParser(), new LazyObjectParser(), new ActiveObjectParser(), new FontParser(), new IconParser(), new DimensionParser(), new ListParser(), new MapParser());
    private static boolean debugMode;

    public static void setDebugMode(boolean debugMode) {
        Parser.debugMode = debugMode;
    }

    public static boolean isDebugMode() {
        return debugMode;
    }

    public static ParseResult parse(ParseResult parseResult, ParserContext context) {
        ParseResult p = parseResult;
        String savedValue = parseResult.value;
        for (PropertyParser step : steps) {
            if (p.finished) {
                return p;
            }
            p = step.parse(p, context);
        }
        if (!p.finished) {
            for (String warning : p.warnings) {
                ParserUtil.warning(warning);
            }
            ParserUtil.setNonNull(p, savedValue);
        }
        return p;
    }

    public static ParseResult createParseResult(String key, String value) {
        if (Parser.isDebugMode()) {
            return new DebugParseResult(key, value);
        }
        return new ParseResult(key, value);
    }

    public static class DebugParseResult
    extends ParseResult {
        public String originalKey;
        public String originalValue;
        public String referenceKey;

        public DebugParseResult(String key, String value) {
            super(key, value);
            this.originalKey = key;
            this.originalValue = value;
        }
    }
}

