/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.api;

import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class InputEvents {
    private static final ArrayList<KeyboardListener> keyboardListeners = new ArrayList();
    private static final ArrayList<WeakReference<KeyboardListener>> weakKeyboardListeners = new ArrayList();

    public static void addKeyboardListener(KeyboardListener listener) {
        keyboardListeners.add(listener);
    }

    public static void removeKeyboardListener(KeyboardListener listener) {
        keyboardListeners.remove(listener);
    }

    public static void addWeakKeyboardListener(KeyboardListener listener) {
        weakKeyboardListeners.add(new WeakReference<KeyboardListener>(listener));
    }

    public static void removeWeakKeyboardListener(KeyboardListener listener) {
        for (int i = 0; i < weakKeyboardListeners.size(); ++i) {
            if (weakKeyboardListeners.get(i).get() != listener) continue;
            weakKeyboardListeners.remove(i);
            return;
        }
    }

    public static void injectKeyEvent(KeyEvent ev) {
        int i;
        for (i = 0; i < keyboardListeners.size(); ++i) {
            KeyboardListener listener = keyboardListeners.get(i);
            listener.onKeyEvent(ev);
        }
        for (i = 0; i < weakKeyboardListeners.size(); ++i) {
            WeakReference<KeyboardListener> weak = weakKeyboardListeners.get(i);
            KeyboardListener strong = (KeyboardListener)weak.get();
            if (strong == null) {
                weakKeyboardListeners.remove(i);
                --i;
                continue;
            }
            strong.onKeyEvent(ev);
        }
    }

    public static void injectTextEvent(TextEvent ev) {
        int i;
        for (i = 0; i < keyboardListeners.size(); ++i) {
            KeyboardListener listener = keyboardListeners.get(i);
            listener.onTextEvent(ev);
        }
        for (i = 0; i < weakKeyboardListeners.size(); ++i) {
            WeakReference<KeyboardListener> weak = weakKeyboardListeners.get(i);
            KeyboardListener strong = (KeyboardListener)weak.get();
            if (strong == null) {
                weakKeyboardListeners.remove(i);
                --i;
                continue;
            }
            strong.onTextEvent(ev);
        }
    }

    public static interface KeyboardListener {
        default public void onKeyEvent(KeyEvent event) {
        }

        default public void onTextEvent(TextEvent event) {
        }
    }

    public static class KeyEvent {
        public final int lwjgl2KeyCode;
        public final int glfwKeyCode;
        public final int glfwScanCode;
        public final KeyAction action;
        public final boolean controlPressed;
        public final boolean shiftPressed;
        public final boolean altPressed;
        public final boolean superPressed;

        public KeyEvent(int lwjgl2KeyCode, int glfwKeyCode, int glfwScanCode, KeyAction action, boolean controlPressed, boolean shiftPressed, boolean altPressed, boolean superPressed) {
            this.lwjgl2KeyCode = lwjgl2KeyCode;
            this.glfwKeyCode = glfwKeyCode;
            this.glfwScanCode = glfwScanCode;
            this.action = action;
            this.controlPressed = controlPressed;
            this.shiftPressed = shiftPressed;
            this.altPressed = altPressed;
            this.superPressed = superPressed;
        }
    }

    public static class TextEvent {
        public final String text;

        public TextEvent(String text) {
            this.text = text;
        }
    }

    public static enum KeyAction {
        PRESSED,
        REPEATED,
        RELEASED;

    }
}

