/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.relauncher;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Paths;
import java.util.List;
import me.eigenraven.lwjgl3ify.relauncher.Relauncher;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.LogManager;

public class Lwjgl3ifyRelauncherTweaker
implements ITweaker {
    private static boolean coremodInjected = false;

    public Lwjgl3ifyRelauncherTweaker() {
        if (FMLLaunchHandler.side() != null) {
            this.injectMyCoremod();
        }
    }

    private void injectMyCoremod() {
        if (coremodInjected) {
            return;
        }
        try {
            URL mySrc = Lwjgl3ifyRelauncherTweaker.class.getProtectionDomain().getCodeSource().getLocation();
            while (mySrc.getProtocol().equals("jar")) {
                String all = mySrc.toString();
                mySrc = new URL(all.substring("jar:".length(), all.lastIndexOf(33)));
            }
            File myFile = new File(".");
            if (mySrc.getProtocol().equals("file")) {
                myFile = Paths.get(mySrc.toURI()).toFile();
            }
            String coreModName = myFile.getName();
            boolean isReparseable = !System.getProperty("java.class.path").contains(coreModName);
            FMLRelaunchLog.log.getLogger().info("Lwjgl3ify reparseable status: {} (name: {})", new Object[]{isReparseable, coreModName});
            Launch.classLoader.addTransformerExclusion("me.eigenraven.lwjgl3ify.core.Lwjgl3ifyCoremod");
            Class<?> cmmClass = Class.forName("cpw.mods.fml.relauncher.CoreModManager", true, (ClassLoader)Launch.classLoader);
            if (isReparseable) {
                Method cmmGetReparseableCoremods = cmmClass.getMethod("getReparseableCoremods", new Class[0]);
                Method cmmGetLoadedCoremods = cmmClass.getMethod("getLoadedCoremods", new Class[0]);
                List reparseableCoremods = (List)cmmGetReparseableCoremods.invoke(null, new Object[0]);
                List loadedCoremods = (List)cmmGetLoadedCoremods.invoke(null, new Object[0]);
                if (loadedCoremods.remove(coreModName)) {
                    FMLRelaunchLog.log.getLogger().info("Removed lwjgl3ify from the list of non-mod coremods");
                }
                if (!reparseableCoremods.contains(coreModName)) {
                    reparseableCoremods.add(coreModName);
                }
            }
            Method cmmAddCoremod = cmmClass.getDeclaredMethod("loadCoreMod", LaunchClassLoader.class, String.class, File.class);
            cmmAddCoremod.setAccessible(true);
            cmmAddCoremod.invoke(null, Launch.classLoader, "me.eigenraven.lwjgl3ify.core.Lwjgl3ifyCoremod", myFile);
            coremodInjected = true;
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)throwable;
                throw re;
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
        if (Launch.blackboard.get("lwjgl3ify:rfb-booted") != Boolean.TRUE) {
            if (FMLLaunchHandler.side().isServer()) {
                LogManager.getLogger().fatal("lwjgl3ify relauncher does not support server launches, install according to lwjgl3ify's README.");
                FMLCommonHandler.instance().exitJava(1, false);
            }
            try {
                new Relauncher(args.toArray(new String[0]), profile).run();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
        this.injectMyCoremod();
    }

    public String getLaunchTarget() {
        return null;
    }

    public String[] getLaunchArguments() {
        return new String[0];
    }
}

