/*
 * Decompiled with CFR 0.152.
 */
package magicbees.main.utils;

import cpw.mods.fml.common.FMLLog;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.logging.Logger;
import magicbees.main.utils.LogHelper;
import magicbees.main.utils.TickHandlerVersion;

public class VersionInfo {
    public static final String ModName = "MagicBees";
    public static final String Version = "2.5.3-GTNH";
    public static final String MCVersion = "1.7.10";
    public static final String VersionURL = "https://raw.githubusercontent.com/MagicBees/MagicBees/master/etc/version-1.7.txt";
    public static final String DownloadURL = "http://minecraft.curseforge.com/mc-mods/65764-magic-bees/files";
    public static final String GUI_FACTORY_CLASS = "magicbees.client.gui.GuiFactory";
    public static final String Logo = "/gfx/magicbees/logo.png";
    public static final String Depends = "required-after:Forestry@[4.2.5,);after:Thaumcraft;after:ExtraBees;after:EE3;after:ArsMagica;after:TConstruct;after:Railcraft;after:ThermalFoundation;after:ThermalExpansion;after:RedstoneArsenal;after:AWWayofTime;after:Botania;after:appliedenergistics2";
    boolean criticalUpdate;
    boolean newVersion;
    boolean versionCheckComplete;
    String latestModVersion;
    String description = "";
    String modName;
    String modVersion;
    String releaseURL;

    public static int[] parseVersion(String rawVersion) {
        ArrayList<Integer> versionTokens = new ArrayList<Integer>();
        String[] tokens = rawVersion.trim().split("[\\. ]");
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
            if (tokens[i].matches("[0-9]+")) {
                versionTokens.add(Integer.valueOf(tokens[i]));
                continue;
            }
            if (!tokens[i].matches("[0-9]+[a-z]")) continue;
            String numberString = tokens[i].substring(0, tokens[i].length() - 1);
            versionTokens.add(Integer.valueOf(numberString));
            versionTokens.add(Character.getNumericValue(tokens[i].charAt(tokens[i].length() - 1)));
        }
        int[] value = new int[versionTokens.size()];
        for (int i = 0; i < value.length; ++i) {
            value[i] = (Integer)versionTokens.get(i);
        }
        return value;
    }

    public static boolean beforeTargetVersion(String version, String target) {
        boolean result = false;
        int[] versionTokens = VersionInfo.parseVersion(version);
        int[] targetTokens = VersionInfo.parseVersion(target);
        for (int i = 0; i < versionTokens.length && i < targetTokens.length; ++i) {
            if (versionTokens[i] < targetTokens[i]) {
                result = true;
                break;
            }
            if (versionTokens[i] > targetTokens[i]) {
                result = false;
                break;
            }
            if (i != versionTokens.length - 1 || versionTokens.length >= targetTokens.length) continue;
            result = true;
        }
        return result;
    }

    public static boolean afterTargetVersion(String version, String target) {
        boolean result = false;
        int[] versionTokens = VersionInfo.parseVersion(version);
        int[] targetTokens = VersionInfo.parseVersion(target);
        for (int i = 0; i < versionTokens.length && i < targetTokens.length; ++i) {
            if (versionTokens[i] <= targetTokens[i]) continue;
            result = true;
            break;
        }
        return result;
    }

    public VersionInfo(String name, String version, String url) {
        this.modName = name;
        this.modVersion = this.latestModVersion = version;
        this.releaseURL = url;
    }

    public VersionInfo(String name, String version, String url, Logger logger) {
        this.modName = name;
        this.modVersion = this.latestModVersion = version;
        this.releaseURL = url;
    }

    public void checkForNewVersion() {
        VersionCheckThread versionCheckThread = new VersionCheckThread();
        versionCheckThread.start();
    }

    public String getCurrentVersion() {
        return this.modVersion;
    }

    public String getLatestVersion() {
        return this.latestModVersion;
    }

    public String getVersionDescription() {
        return this.description;
    }

    public boolean isCriticalUpdate() {
        return this.criticalUpdate;
    }

    public boolean isNewVersionAvailable() {
        return this.newVersion;
    }

    public boolean isVersionCheckComplete() {
        return this.versionCheckComplete;
    }

    public static void doVersionCheck() {
        VersionInfo versionInfo = new VersionInfo(ModName, Version, VersionURL);
        TickHandlerVersion.go(versionInfo);
        VersionInfo versionInfo2 = versionInfo;
        versionInfo2.getClass();
        VersionCheckThread thread = versionInfo2.new VersionCheckThread();
        thread.start();
    }

    private class VersionCheckThread
    extends Thread {
        private VersionCheckThread() {
        }

        @Override
        public void run() {
            try {
                String location = VersionInfo.VersionURL;
                URLConnection connection = null;
                while (location != null && !location.isEmpty()) {
                    URL url = new URL(location);
                    connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.60 Safari/537.17");
                    connection.connect();
                    location = connection.getHeaderField("Location");
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                VersionInfo.this.latestModVersion = reader.readLine();
                VersionInfo.this.criticalUpdate = Boolean.parseBoolean(reader.readLine());
                while (reader.ready()) {
                    VersionInfo.this.description = VersionInfo.this.description + reader.readLine();
                }
                reader.close();
                if (VersionInfo.beforeTargetVersion(VersionInfo.this.modVersion, VersionInfo.this.latestModVersion)) {
                    FMLLog.info((String)("An updated version of " + VersionInfo.this.modName + " is available: " + VersionInfo.this.latestModVersion + ". You are currently using " + VersionInfo.Version), (Object[])new Object[0]);
                    VersionInfo.this.newVersion = true;
                    if (VersionInfo.this.criticalUpdate) {
                        LogHelper.info("This update has been marked as CRITICAL and will ignore notification suppression.");
                    }
                }
            }
            catch (Exception e) {
                LogHelper.warn("Version check Failed: " + e.getMessage());
            }
            VersionInfo.this.versionCheckComplete = true;
        }
    }
}

