/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees.allele.effect;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.genetics.IEffectData;
import java.util.List;
import magicbees.bees.AlleleEffect;
import magicbees.bees.BeeManager;
import magicbees.bees.allele.effect.EffectData;
import magicbees.main.utils.BlockUtil;
import magicbees.main.utils.compat.thaumcraft.NodeHelper;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import thaumcraft.api.nodes.NodeType;

public class AlleleEffectNodeConversion
extends AlleleEffect {
    private NodeType targetType;

    public AlleleEffectNodeConversion(String id, NodeType targetNodeType, boolean isDominant, int timeout) {
        super(id, isDominant, timeout);
        this.targetType = targetNodeType;
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData == null || !(storedData instanceof EffectData)) {
            storedData = new EffectData(1, 0, 0);
        }
        return storedData;
    }

    @Override
    protected IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorld();
        ChunkCoordinates coords = housing.getCoordinates();
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        int range = (int)Math.ceil((float)genome.getTerritory()[0] * beeModifier.getTerritoryModifier(genome, 1.0f));
        List<Chunk> chunks = BlockUtil.getChunksInSearchRange(world, coords.field_71574_a, coords.field_71573_c, range);
        if (NodeHelper.convertNodeInRangeToType(chunks, world, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, range, this.targetType)) {
            storedData.setInteger(0, storedData.getInteger(0) - this.throttle);
        }
        return storedData;
    }
}

