/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.List;
import net.malisis.core.renderer.IRenderWorldLast;
import net.minecraft.client.Minecraft;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;

public class RenderWorldEventHandler {
    private static RenderWorldEventHandler instance = new RenderWorldEventHandler();
    private List<IRenderWorldLast> renderers = new ArrayList<IRenderWorldLast>();

    private void _register(IRenderWorldLast renderer) {
        if (this.renderers.size() == 0) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        this.renderers.add(renderer);
    }

    private void _unregister(IRenderWorldLast renderer) {
        this.renderers.remove(renderer);
        if (this.renderers.size() == 0) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    @SubscribeEvent
    public void onRenderLast(RenderWorldLastEvent event) {
        for (IRenderWorldLast renderer : this.renderers) {
            if (!renderer.shouldRender(event, (IBlockAccess)Minecraft.func_71410_x().field_71441_e)) continue;
            renderer.renderWorldLastEvent(event, (IBlockAccess)Minecraft.func_71410_x().field_71441_e);
        }
    }

    public static void register(IRenderWorldLast renderer) {
        instance._register(renderer);
    }

    public static void unregister(IRenderWorldLast renderer) {
        instance._unregister(renderer);
    }
}

