/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.container;

import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.element.SimpleGuiShape;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import org.lwjgl.opengl.GL11;

public class UIBackgroundContainer
extends UIContainer<UIBackgroundContainer>
implements ITransformable.Color {
    protected int topLeftColor = -1;
    protected int topRightColor = -1;
    protected int bottomLeftColor = -1;
    protected int bottomRightColor = -1;
    protected int topLeftAlpha = 255;
    protected int topRightAlpha = 255;
    protected int bottomLeftAlpha = 255;
    protected int bottomRightAlpha = 255;

    public UIBackgroundContainer(MalisisGui gui) {
        super(gui);
        this.shape = new SimpleGuiShape();
    }

    public UIBackgroundContainer(MalisisGui gui, String title) {
        this(gui);
        this.setTitle(title);
    }

    public UIBackgroundContainer(MalisisGui gui, int width, int height) {
        this(gui);
        this.setSize(width, height);
    }

    public UIBackgroundContainer(MalisisGui gui, String title, int width, int height) {
        this(gui);
        this.setTitle(title);
        this.setSize(width, height);
    }

    public int getTopLeftColor() {
        return this.topLeftColor;
    }

    public UIBackgroundContainer setTopLeftColor(int topLeftColor) {
        this.topLeftColor = topLeftColor;
        return this;
    }

    public int getTopRightColor() {
        return this.topRightColor;
    }

    public UIBackgroundContainer setTopRightColor(int topRightColor) {
        this.topRightColor = topRightColor;
        return this;
    }

    public int getBottomLeftColor() {
        return this.bottomLeftColor;
    }

    public UIBackgroundContainer setBottomLeftColor(int bottomLeftColor) {
        this.bottomLeftColor = bottomLeftColor;
        return this;
    }

    public int getBottomRightColor() {
        return this.bottomRightColor;
    }

    public UIBackgroundContainer setBottomRightColor(int bottomRightColor) {
        this.bottomRightColor = bottomRightColor;
        return this;
    }

    public UIBackgroundContainer setTopColor(int color) {
        this.setTopLeftColor(color);
        this.setTopRightColor(color);
        return this;
    }

    public UIBackgroundContainer setBottomColor(int color) {
        this.setBottomLeftColor(color);
        this.setBottomRightColor(color);
        return this;
    }

    public UIBackgroundContainer setLeftColor(int color) {
        this.setTopLeftColor(color);
        this.setBottomLeftColor(color);
        return this;
    }

    public UIBackgroundContainer setRightColor(int color) {
        this.setTopRightColor(color);
        this.setBottomRightColor(color);
        return this;
    }

    @Override
    public void setColor(int color) {
        this.setTopColor(color);
        this.setBottomColor(color);
    }

    public int getTopLeftAlpha() {
        return this.topLeftAlpha;
    }

    public UIBackgroundContainer setTopLeftAlpha(int topLeftAlpha) {
        this.topLeftAlpha = topLeftAlpha;
        return this;
    }

    public int getTopRightAlpha() {
        return this.topRightAlpha;
    }

    public UIBackgroundContainer setTopRightAlpha(int topRightAlpha) {
        this.topRightAlpha = topRightAlpha;
        return this;
    }

    public int getBottomLeftAlpha() {
        return this.bottomLeftAlpha;
    }

    public UIBackgroundContainer setBottomLeftAlpha(int bottomLeftAlpha) {
        this.bottomLeftAlpha = bottomLeftAlpha;
        return this;
    }

    public int getBottomRightAlpha() {
        return this.bottomRightAlpha;
    }

    public UIBackgroundContainer setBottomRightAlpha(int bottomRightAlpha) {
        this.bottomRightAlpha = bottomRightAlpha;
        return this;
    }

    public UIBackgroundContainer setTopAlpha(int alpha) {
        this.setTopLeftAlpha(alpha);
        this.setTopRightAlpha(alpha);
        return this;
    }

    public UIBackgroundContainer setBottomAlpha(int alpha) {
        this.setBottomLeftAlpha(alpha);
        this.setBottomRightAlpha(alpha);
        return this;
    }

    public UIBackgroundContainer setLeftAlpha(int alpha) {
        this.setTopLeftAlpha(alpha);
        this.setBottomLeftAlpha(alpha);
        return this;
    }

    public UIBackgroundContainer setRightAlpha(int alpha) {
        this.setTopRightAlpha(alpha);
        this.setBottomRightAlpha(alpha);
        return this;
    }

    public UIBackgroundContainer setBackgroundAlpha(int alpha) {
        this.setTopAlpha(alpha);
        this.setBottomAlpha(alpha);
        return this;
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        if (this.alpha == 0) {
            return;
        }
        renderer.enableBlending();
        this.rp.usePerVertexColor.set(true);
        this.rp.usePerVertexAlpha.set(true);
        this.shape.getVertexes("TopLeft").get(0).setColor(this.topLeftColor).setAlpha(this.topLeftAlpha);
        this.shape.getVertexes("TopRight").get(0).setColor(this.topRightColor).setAlpha(this.topRightAlpha);
        this.shape.getVertexes("BottomLeft").get(0).setColor(this.bottomLeftColor).setAlpha(this.bottomLeftAlpha);
        this.shape.getVertexes("BottomRight").get(0).setColor(this.bottomRightColor).setAlpha(this.bottomRightAlpha);
        renderer.disableTextures();
        renderer.drawShape(this.shape, this.rp);
        renderer.next();
        GL11.glEnable((int)3553);
    }
}

