/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.malisis.doors.MalisisDoors;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PlayerSensor
extends Block {
    public static int FLAG_POWERED = 8;

    public PlayerSensor() {
        super(Material.field_151594_q);
        this.func_149647_a(MalisisDoors.tab);
        this.func_149663_c("player_sensor");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("malisisdoors:" + this.func_149739_a().substring(5));
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        return null;
    }

    public boolean func_149707_d(World world, int x, int y, int z, int d) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)d);
        return world.isSideSolid(x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ, dir);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!world.isSideSolid(x - dir.offsetX, y - dir.offsetY, z + dir.offsetZ, dir)) continue;
            return true;
        }
        return false;
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        return side + (world.func_72805_g(x, y, z) & FLAG_POWERED);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        float f = 0.125f;
        ForgeDirection dir = PlayerSensor.getDirection(world, x, y, z);
        if (dir == ForgeDirection.EAST) {
            this.func_149676_a(0.0f, f, f, f, 2.0f * f, 1.0f - f);
        } else if (dir == ForgeDirection.WEST) {
            this.func_149676_a(1.0f - f, f, f, 1.0f, 2.0f * f, 1.0f - f);
        } else if (dir == ForgeDirection.SOUTH) {
            this.func_149676_a(f, f, 0.0f, 1.0f - f, 2.0f * f, f);
        } else if (dir == ForgeDirection.NORTH) {
            this.func_149676_a(f, f, 1.0f - f, 1.0f - f, 2.0f * f, 1.0f);
        } else if (dir == ForgeDirection.DOWN) {
            this.func_149676_a(0.5f - f, 1.0f - f / 2.0f, 0.5f - f, 0.5f + f, 1.0f, 0.5f + f);
        } else if (dir == ForgeDirection.UP) {
            this.func_149676_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f / 2.0f, 0.5f + f);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        ForgeDirection dir = PlayerSensor.getDirection((IBlockAccess)world, x, y, z);
        if (!world.isSideSolid(x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ, dir)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        if (PlayerSensor.isPowered(metadata)) {
            this.notifyPower(world, x, y, z);
        }
        super.func_149749_a(world, x, y, z, block, metadata);
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        return PlayerSensor.isPowered(world.func_72805_g(x, y, z)) ? 15 : 0;
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        if (PlayerSensor.isPowered(world.func_72805_g(x, y, z)) && PlayerSensor.getDirection(world, x, y, z).ordinal() == side) {
            return 15;
        }
        return 0;
    }

    public boolean func_149744_f() {
        return true;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
    }

    private AxisAlignedBB getDetectionBox(World world, int x, int y, int z) {
        ForgeDirection dir = PlayerSensor.getDirection((IBlockAccess)world, x, y, z);
        double x1 = x;
        double x2 = x;
        double z1 = z;
        double z2 = z;
        int yOffset = 1;
        int factor = -1;
        if (dir == ForgeDirection.EAST) {
            x1 -= 1.0;
            x2 += 2.0;
            z2 += 1.0;
        } else if (dir == ForgeDirection.WEST) {
            x1 -= 1.0;
            x2 += 2.0;
            z2 += 1.0;
        } else if (dir == ForgeDirection.NORTH) {
            x2 += 1.0;
            z1 -= 1.0;
            z2 += 2.0;
        } else if (dir == ForgeDirection.SOUTH) {
            x2 += 1.0;
            z1 -= 1.0;
            z2 += 2.0;
        } else if (dir == ForgeDirection.UP) {
            x2 += 1.0;
            z2 += 1.0;
            factor = 1;
        } else if (dir == ForgeDirection.DOWN) {
            x2 += 1.0;
            z2 += 1.0;
        }
        boolean isAir = world.func_147437_c(x, y + 1 * factor, z);
        while (isAir && yOffset < 6) {
            isAir = world.func_147437_c(x, y + factor * yOffset++, z);
        }
        int y2 = Math.max(y, y + factor * yOffset);
        y = Math.min(y, y + factor * yOffset);
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)x1, (double)y, (double)z1, (double)x2, (double)y2, (double)z2);
        return aabb;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!world.field_72995_K) {
            world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
            List list = world.func_72872_a(EntityPlayer.class, this.getDetectionBox(world, x, y, z));
            int metadata = world.func_72805_g(x, y, z);
            if (list != null && !list.isEmpty()) {
                if (PlayerSensor.isPowered(metadata)) {
                    return;
                }
                world.func_72921_c(x, y, z, metadata |= FLAG_POWERED, 3);
                this.notifyPower(world, x, y, z);
            } else if ((metadata & 8) != 0) {
                world.func_72921_c(x, y, z, metadata &= ~FLAG_POWERED, 3);
                this.notifyPower(world, x, y, z);
            }
        }
    }

    public void func_149683_g() {
        float f = 0.125f;
        this.func_149676_a(f, 0.5f - f, 0.5f - f, 1.0f - f, 0.5f + f, 0.5f + f);
    }

    private void notifyPower(World world, int x, int y, int z) {
        world.func_147459_d(x, y, z, (Block)this);
        ForgeDirection dir = PlayerSensor.getDirection((IBlockAccess)world, x, y, z);
        world.func_147459_d(x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ, (Block)this);
    }

    public int func_149738_a(World par1World) {
        return 5;
    }

    public static boolean isPowered(int metadata) {
        return (metadata & FLAG_POWERED) != 0;
    }

    public static ForgeDirection getDirection(IBlockAccess world, int x, int y, int z) {
        return ForgeDirection.getOrientation((int)(world.func_72805_g(x, y, z) & 7));
    }
}

