/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.building;

import com.recursive_pineapple.matter_manipulator.GlobalMMConfig;
import com.recursive_pineapple.matter_manipulator.MMMod;
import com.recursive_pineapple.matter_manipulator.common.building.BlockSpec;
import com.recursive_pineapple.matter_manipulator.common.building.IPseudoInventory;
import com.recursive_pineapple.matter_manipulator.common.building.PendingBlock;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.Location;
import com.recursive_pineapple.matter_manipulator.common.utils.BigFluidStack;
import com.recursive_pineapple.matter_manipulator.common.utils.BigItemStack;
import com.recursive_pineapple.matter_manipulator.common.utils.FluidId;
import com.recursive_pineapple.matter_manipulator.common.utils.ItemId;
import com.recursive_pineapple.matter_manipulator.common.utils.MMUtils;
import it.unimi.dsi.fastutil.booleans.BooleanObjectImmutablePair;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.joml.Vector3i;

public class BlockAnalyzer {
    private BlockAnalyzer() {
    }

    public static RegionAnalysis analyzeRegion(World world, Location a, Location b, boolean checkTiles) {
        Vector3i deltas;
        if (a == null || b == null || world.field_73011_w.field_76574_g != a.worldId || a.worldId != b.worldId) {
            return null;
        }
        long pre = System.nanoTime();
        RegionAnalysis analysis = new RegionAnalysis();
        analysis.deltas = deltas = MMUtils.getRegionDeltas(a, b);
        analysis.blocks = new ArrayList<PendingBlock>();
        for (Vector3i voxel : MMUtils.getBlocksInBB(a, deltas)) {
            BlockSpec spec = BlockSpec.fromBlock(null, world, voxel.x, voxel.y, voxel.z);
            if (spec.skipWhenCopying()) continue;
            PendingBlock pending = spec.instantiate(world, voxel.x, voxel.y, voxel.z);
            if (checkTiles) {
                pending.analyze(world.func_147438_o(voxel.x, voxel.y, voxel.z), 0xFFFFFFFF & ~PendingBlock.ANALYZE_ARCH);
            }
            pending.x -= a.x;
            pending.y -= a.y;
            pending.z -= a.z;
            analysis.blocks.add(pending);
        }
        long post = System.nanoTime();
        if (GlobalMMConfig.DebugConfig.debug) {
            MMMod.LOG.info("Analysis took " + (double)(post - pre) / 1000000.0 + " ms");
        }
        return analysis;
    }

    public static RequiredItemAnalysis getRequiredItemsForBuild(EntityPlayer player, List<PendingBlock> blocks, boolean fromScratch) {
        BlockItemCheckContext context = new BlockItemCheckContext();
        context.player = player;
        context.world = player.func_130014_f_();
        BlockSpec pooled = new BlockSpec();
        for (PendingBlock block : blocks) {
            if (!block.isInWorld(context.world)) continue;
            boolean isNew = true;
            if (!fromScratch && !context.world.func_147437_c(block.x, block.y, block.z)) {
                BlockSpec.fromBlock(pooled, context.world, block.x, block.y, block.z);
                if (pooled.isEquivalent(block.spec)) {
                    isNew = false;
                }
            }
            if (isNew && !block.isFree()) {
                context.tryConsumeItems(block.getStack());
            }
            context.x = block.x;
            context.y = block.y;
            context.z = block.z;
            if (isNew) {
                block.getRequiredItemsForNewBlock(context);
                continue;
            }
            block.getRequiredItemsForExistingBlock(context);
        }
        RequiredItemAnalysis analysis = new RequiredItemAnalysis();
        analysis.requiredItems = context.requiredItems;
        analysis.storedItems = context.storedItems;
        analysis.storedFluids = context.storedFluids;
        return analysis;
    }

    public static class RegionAnalysis {
        public Vector3i deltas;
        public List<PendingBlock> blocks;
    }

    private static class BlockItemCheckContext
    implements IBlockApplyContext {
        public World world;
        public int x;
        public int y;
        public int z;
        public EntityPlayer player;
        public Object2LongOpenHashMap<ItemId> requiredItems = new Object2LongOpenHashMap();
        public Object2LongOpenHashMap<ItemId> storedItems = new Object2LongOpenHashMap();
        public Object2LongOpenHashMap<FluidId> storedFluids = new Object2LongOpenHashMap();

        private BlockItemCheckContext() {
        }

        @Override
        public World getWorld() {
            return this.world;
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }

        @Override
        public int getZ() {
            return this.z;
        }

        @Override
        public TileEntity getTileEntity() {
            return this.world.func_147438_o(this.x, this.y, this.z);
        }

        @Override
        public EntityPlayer getRealPlayer() {
            return this.player;
        }

        @Override
        public boolean tryApplyAction(double complexity) {
            return true;
        }

        @Override
        public BooleanObjectImmutablePair<List<BigItemStack>> tryConsumeItems(List<BigItemStack> items, int flags) {
            boolean fuzzy;
            boolean simulate = (flags & 1) != 0;
            boolean bl = fuzzy = (flags & 2) != 0;
            if ((flags & 0x10) != 0) {
                return BooleanObjectImmutablePair.of((boolean)false, new ArrayList());
            }
            ArrayList<BigItemStack> extractedItems = new ArrayList<BigItemStack>();
            for (BigItemStack req : items) {
                block7: {
                    block6: {
                        if (req.getStackSize() == 0L) continue;
                        if (fuzzy) break block6;
                        long amtInPending = this.storedItems.getLong((Object)req.getId());
                        long toRemove = Math.min(amtInPending, req.getStackSize());
                        if (toRemove <= 0L) break block7;
                        extractedItems.add(req.copy().setStackSize(toRemove));
                        amtInPending -= toRemove;
                        req.decStackSize(toRemove);
                        if (simulate) break block7;
                        if (amtInPending == 0L) {
                            this.storedItems.removeLong((Object)req.getId());
                        } else {
                            this.storedItems.put((Object)req.getId(), amtInPending);
                        }
                        break block7;
                    }
                    ObjectIterator iter = this.storedItems.object2LongEntrySet().iterator();
                    while (iter.hasNext()) {
                        long amtInPending;
                        long toRemove;
                        ItemStack stack;
                        Object2LongMap.Entry e = (Object2LongMap.Entry)iter.next();
                        if (e.getLongValue() == 0L || (stack = ((ItemId)e.getKey()).getItemStack()).func_77973_b() != req.getItem() || stack.func_77981_g() && Items.field_151008_G.getDamage(stack) != req.getItemDamage() || (toRemove = Math.min(amtInPending = e.getLongValue(), req.getStackSize())) <= 0L) continue;
                        extractedItems.add(req.copy().setStackSize(toRemove));
                        amtInPending -= toRemove;
                        req.decStackSize(toRemove);
                        if (simulate) continue;
                        if (amtInPending == 0L) {
                            iter.remove();
                            continue;
                        }
                        e.setValue(amtInPending);
                    }
                }
                ItemId id = fuzzy && !req.getItem().func_77614_k() ? ItemId.createAsWildcard(req.getItemStack()) : ItemId.create(req.getItemStack());
                this.requiredItems.addTo((Object)id, req.getStackSize());
            }
            return BooleanObjectImmutablePair.of((boolean)true, items);
        }

        @Override
        public void givePlayerItems(List<BigItemStack> items) {
            for (BigItemStack item : items) {
                this.storedItems.addTo((Object)item.getId(), item.stackSize);
            }
        }

        @Override
        public void givePlayerFluids(List<BigFluidStack> fluids) {
            for (BigFluidStack fluid : fluids) {
                this.storedFluids.addTo((Object)fluid.getId(), fluid.amount);
            }
        }

        @Override
        public void warn(String message) {
            MMUtils.sendWarningToPlayer(this.player, StatCollector.func_74837_a((String)"mm.info.warning", (Object[])new Object[]{this.x, this.y, this.z, message}));
        }

        @Override
        public void error(String message) {
            MMUtils.sendErrorToPlayer(this.player, StatCollector.func_74837_a((String)"mm.info.error", (Object[])new Object[]{this.x, this.y, this.z, message}));
        }
    }

    public static interface IBlockApplyContext
    extends IPseudoInventory {
        public World getWorld();

        public int getX();

        public int getY();

        public int getZ();

        public TileEntity getTileEntity();

        public EntityPlayer getRealPlayer();

        public boolean tryApplyAction(double var1);

        public void warn(String var1);

        public void error(String var1);
    }

    public static class RequiredItemAnalysis {
        public Map<ItemId, Long> requiredItems;
        public Map<ItemId, Long> storedItems;
        public Map<FluidId, Long> storedFluids;
    }
}

