/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.building;

import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import com.recursive_pineapple.matter_manipulator.MMMod;
import com.recursive_pineapple.matter_manipulator.common.building.AEAnalysisResult;
import com.recursive_pineapple.matter_manipulator.common.building.ArchitectureCraftAnalysisResult;
import com.recursive_pineapple.matter_manipulator.common.building.BlockAnalyzer;
import com.recursive_pineapple.matter_manipulator.common.building.BlockSpec;
import com.recursive_pineapple.matter_manipulator.common.building.CopyableProperty;
import com.recursive_pineapple.matter_manipulator.common.building.GTAnalysisResult;
import com.recursive_pineapple.matter_manipulator.common.building.ITileAnalysisIntegration;
import com.recursive_pineapple.matter_manipulator.common.building.ImmutableBlockSpec;
import com.recursive_pineapple.matter_manipulator.common.building.InventoryAnalysis;
import com.recursive_pineapple.matter_manipulator.common.building.providers.IItemProvider;
import com.recursive_pineapple.matter_manipulator.common.compat.BlockProperty;
import com.recursive_pineapple.matter_manipulator.common.compat.BlockPropertyRegistry;
import com.recursive_pineapple.matter_manipulator.common.compat.Orientation;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.Location;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.Transform;
import com.recursive_pineapple.matter_manipulator.common.utils.Mods;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public class PendingBlock
extends Location {
    public ImmutableBlockSpec spec;
    public ITileAnalysisIntegration gt;
    public ITileAnalysisIntegration ae;
    public ITileAnalysisIntegration arch;
    public ITileAnalysisIntegration mp;
    public InventoryAnalysis inventory = null;
    public int renderOrder;
    public int buildOrder;
    private static int counter = 0;
    public static final int ANALYZE_GT = 1 << counter++;
    public static final int ANALYZE_AE = 1 << counter++;
    public static final int ANALYZE_ARCH = 1 << counter++;
    public static final int ANALYZE_MP = 1 << counter++;
    public static final int ANALYZE_INV = 1 << counter++;
    public static final int ANALYZE_ALL = -1;

    public PendingBlock(int worldId, int x, int y, int z, @NotNull ImmutableBlockSpec spec) {
        super(worldId, x, y, z);
        this.spec = spec;
    }

    private PendingBlock() {
    }

    public PendingBlock reset() {
        this.spec = null;
        this.gt = null;
        this.ae = null;
        this.arch = null;
        this.inventory = null;
        this.renderOrder = 0;
        this.buildOrder = 0;
        return this;
    }

    public PendingBlock setBlock(ImmutableBlockSpec spec) {
        this.reset();
        this.spec = spec;
        return this;
    }

    public PendingBlock setBlock(Block block, int metadata) {
        this.reset();
        this.spec = new BlockSpec().setObject(block, metadata);
        return this;
    }

    public PendingBlock setBlock(ItemStack stack) {
        this.reset();
        this.spec = new BlockSpec().setObject(stack);
        return this;
    }

    public PendingBlock setOrders(int renderOrder, int buildOrder) {
        this.renderOrder = renderOrder;
        this.buildOrder = buildOrder;
        return this;
    }

    public Block getBlock() {
        return this.spec.getBlock();
    }

    public Item getItem() {
        return this.spec.getItem();
    }

    private List<ITileAnalysisIntegration> getIntegrations() {
        ArrayList<ITileAnalysisIntegration> list = new ArrayList<ITileAnalysisIntegration>();
        if (this.gt != null) {
            list.add(this.gt);
        }
        if (this.ae != null) {
            list.add(this.ae);
        }
        if (this.arch != null) {
            list.add(this.arch);
        }
        return list;
    }

    private String getItemDetails() {
        ArrayList<String> details = new ArrayList<String>(0);
        this.spec.getItemDetails(details);
        for (ITileAnalysisIntegration analysis : this.getIntegrations()) {
            analysis.getItemDetails(details);
        }
        return details.isEmpty() ? "" : String.format(" (%s)", String.join((CharSequence)", ", details));
    }

    public ItemStack getStack() {
        ItemStack stack = this.spec.getStack();
        if (stack == null) {
            return null;
        }
        NBTTagCompound tag = stack.func_77978_p() != null ? stack.func_77978_p() : new NBTTagCompound();
        for (ITileAnalysisIntegration analysis : this.getIntegrations()) {
            analysis.getItemTag(tag);
        }
        stack.func_77982_d(tag.func_82582_d() ? null : tag);
        return stack;
    }

    public boolean getRequiredItemsForExistingBlock(BlockAnalyzer.IBlockApplyContext context) {
        TileEntity te = context.getTileEntity();
        for (ITileAnalysisIntegration analysis : this.getIntegrations()) {
            if (analysis.getRequiredItemsForExistingBlock(context)) continue;
            return false;
        }
        if (this.inventory != null && te instanceof IInventory) {
            IInventory inventory = (IInventory)te;
            this.inventory.apply(context, inventory, true, true);
        }
        return true;
    }

    public boolean getRequiredItemsForNewBlock(BlockAnalyzer.IBlockApplyContext context) {
        for (ITileAnalysisIntegration analysis : this.getIntegrations()) {
            if (analysis.getRequiredItemsForNewBlock(context)) continue;
            return false;
        }
        if (this.inventory != null) {
            for (IItemProvider item : this.inventory.mItems) {
                if (item == null) continue;
                item.getStack(context, true);
            }
        }
        return true;
    }

    public String getDisplayName() {
        return this.getStack().func_82833_r() + this.getItemDetails();
    }

    public boolean isFree() {
        return this.spec.isFree();
    }

    @Override
    public PendingBlock clone() {
        PendingBlock dup = new PendingBlock();
        dup.worldId = this.worldId;
        dup.x = this.x;
        dup.y = this.y;
        dup.z = this.z;
        dup.spec = this.spec;
        if (this.gt != null) {
            dup.gt = this.gt.clone();
        }
        if (this.ae != null) {
            dup.ae = this.ae.clone();
        }
        if (this.arch != null) {
            dup.arch = this.arch.clone();
        }
        if (this.mp != null) {
            dup.mp = this.mp.clone();
        }
        if (this.inventory != null) {
            dup.inventory = this.inventory.clone();
        }
        dup.renderOrder = this.renderOrder;
        dup.buildOrder = this.buildOrder;
        return dup;
    }

    public void transform(Transform transform) {
        EnumMap<CopyableProperty, String> p = new EnumMap<CopyableProperty, String>(CopyableProperty.class);
        for (CopyableProperty property : CopyableProperty.VALUES) {
            String value = this.spec.getProperty(property);
            if (value == null || value.isEmpty()) continue;
            p.put(property, value);
        }
        this.transform(p, CopyableProperty.FACING, transform);
        this.transform(p, CopyableProperty.FORWARD, transform);
        this.transform(p, CopyableProperty.UP, transform);
        this.transform(p, CopyableProperty.LEFT, transform);
        if (p.containsKey((Object)CopyableProperty.TOP) && transform.apply(ForgeDirection.UP) == ForgeDirection.DOWN) {
            String value = p.get((Object)CopyableProperty.TOP);
            p.put(CopyableProperty.TOP, "true".equals(value) ? "false" : "true");
        }
        if (p.containsKey((Object)CopyableProperty.ROTATION)) {
            try {
                int rotation = Integer.parseInt(p.get((Object)CopyableProperty.ROTATION));
                Vector3f v = new Vector3f(0.0f, 0.0f, 1.0f).rotateAxis((float)rotation * (float)Math.PI * 2.0f / 360.0f, 0.0f, 1.0f, 0.0f).mulTransposeDirection((Matrix4fc)transform.getRotation());
                rotation = MathHelper.func_76128_c((double)(Math.atan2(v.x, v.z) * 360.0 / Math.PI / 2.0 + 0.5));
                rotation = (rotation % 360 + 360) % 360;
                p.put(CopyableProperty.ROTATION, Integer.toString(rotation));
            }
            catch (NumberFormatException e) {
                MMMod.LOG.error("could not transform rotation", (Throwable)e);
            }
        }
        if (p.containsKey((Object)CopyableProperty.ORIENTATION)) {
            try {
                Orientation o = Orientation.valueOf(p.get((Object)CopyableProperty.ORIENTATION).toUpperCase());
                o = Orientation.getOrientation(transform.apply(o.a), transform.apply(o.b));
                p.put(CopyableProperty.ORIENTATION, o.name().toLowerCase());
            }
            catch (Exception e) {
                MMMod.LOG.error("could not transform orientation", (Throwable)e);
            }
        }
        this.spec = this.spec.withProperties(p.isEmpty() ? null : p);
        for (ITileAnalysisIntegration analysis : this.getIntegrations()) {
            analysis.transform(transform);
        }
    }

    private void transform(EnumMap<CopyableProperty, String> p, CopyableProperty prop, Transform transform) {
        ForgeDirection dir;
        String value = p.get((Object)prop);
        if (value == null || value.isEmpty()) {
            return;
        }
        try {
            dir = ForgeDirection.valueOf((String)value.toUpperCase());
        }
        catch (Exception e) {
            MMMod.LOG.error("could not transform " + (Object)((Object)prop), (Throwable)e);
            return;
        }
        dir = transform.apply(dir);
        p.put(prop, dir.name().toLowerCase());
    }

    public boolean apply(BlockAnalyzer.IBlockApplyContext context, World world) {
        class RefCell {
            public boolean didSomething = false;

            RefCell() {
            }
        }
        RefCell ref = new RefCell();
        Object2ObjectOpenHashMap properties = new Object2ObjectOpenHashMap();
        BlockPropertyRegistry.getProperties(world, this.x, this.y, this.z, properties);
        for (CopyableProperty property : CopyableProperty.VALUES) {
            String existing;
            BlockProperty prop;
            String value = this.spec.getProperty(property);
            if (value == null || (prop = (BlockProperty)properties.get(property.toString())) == null || (existing = prop.getValueAsString(world, this.x, this.y, this.z)).equals(value)) continue;
            ref.didSomething = true;
            try {
                prop.setValueFromText(world, this.x, this.y, this.z, value);
            }
            catch (Exception e) {
                context.error("Could not apply property " + (Object)((Object)property) + ": " + e.getMessage());
            }
        }
        for (ITileAnalysisIntegration analysis : this.getIntegrations()) {
            if (analysis.apply(context)) continue;
            return false;
        }
        TileEntity tileEntity = context.getTileEntity();
        if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            if (this.inventory != null && !this.inventory.apply(context, inventory, true, false)) {
                return false;
            }
        }
        world.func_147460_e(this.x, this.y, this.z, Blocks.field_150350_a);
        return ref.didSomething;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.spec == null ? 0 : this.spec.hashCode());
        result = 31 * result + (this.gt == null ? 0 : this.gt.hashCode());
        result = 31 * result + (this.ae == null ? 0 : this.ae.hashCode());
        result = 31 * result + (this.arch == null ? 0 : this.arch.hashCode());
        result = 31 * result + (this.mp == null ? 0 : this.mp.hashCode());
        result = 31 * result + (this.inventory == null ? 0 : this.inventory.hashCode());
        result = 31 * result + this.renderOrder;
        result = 31 * result + this.buildOrder;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PendingBlock other = (PendingBlock)obj;
        if (this.spec == null ? other.spec != null : !this.spec.equals(other.spec)) {
            return false;
        }
        if (this.gt == null ? other.gt != null : !this.gt.equals(other.gt)) {
            return false;
        }
        if (this.ae == null ? other.ae != null : !this.ae.equals(other.ae)) {
            return false;
        }
        if (this.arch == null ? other.arch != null : !this.arch.equals(other.arch)) {
            return false;
        }
        if (this.mp == null ? other.mp != null : !this.mp.equals(other.mp)) {
            return false;
        }
        if (this.inventory == null ? other.inventory != null : !this.inventory.equals(other.inventory)) {
            return false;
        }
        if (this.renderOrder != other.renderOrder) {
            return false;
        }
        return this.buildOrder == other.buildOrder;
    }

    public static Comparator<PendingBlock> getComparator() {
        return Comparator.comparingInt(b -> b.buildOrder).thenComparing(b -> b.spec, ImmutableBlockSpec.getComparator()).thenComparingInt(b -> b.x >> 4).thenComparingInt(b -> b.z >> 4).thenComparingLong(value -> CoordinatePacker.pack((int)value.x, (int)value.y, (int)value.z));
    }

    public static PendingBlock fromBlock(World world, int x, int y, int z) {
        return BlockSpec.fromBlock(null, world, x, y, z).instantiate(world, x, y, z);
    }

    public PendingBlock analyze(TileEntity te, int flags) {
        if (te != null) {
            if ((flags & ANALYZE_GT) != 0 && Mods.GregTech.isModLoaded()) {
                this.gt = GTAnalysisResult.analyze(te);
            }
            if ((flags & ANALYZE_AE) != 0 && Mods.AppliedEnergistics2.isModLoaded()) {
                this.ae = AEAnalysisResult.analyze(te);
            }
            if ((flags & ANALYZE_ARCH) != 0 && Mods.ArchitectureCraft.isModLoaded()) {
                this.arch = ArchitectureCraftAnalysisResult.analyze(te);
            }
            if ((flags & ANALYZE_INV) != 0 && te instanceof IInventory) {
                IInventory inventory = (IInventory)te;
                this.inventory = InventoryAnalysis.fromInventory(inventory, false);
            }
        }
        return this;
    }

    public PendingBlock migrate() {
        if (this.gt != null) {
            this.gt.migrate();
        }
        if (this.ae != null) {
            this.ae.migrate();
        }
        if (this.arch != null) {
            this.arch.migrate();
        }
        if (this.mp != null) {
            this.mp.migrate();
        }
        return this;
    }

    public static boolean areEquivalent(PendingBlock a, PendingBlock b) {
        ItemStack sa = a.getStack();
        ItemStack sb = b.getStack();
        if (sa == null && sb == null) {
            return a.spec.equals(b.spec);
        }
        return ItemStack.func_77989_b((ItemStack)sa, (ItemStack)sb);
    }
}

