/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.client.gui;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.ItemDrawable;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.recursive_pineapple.matter_manipulator.client.gui.RadialMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;

public class RadialMenuBuilder {
    public final UIBuildContext buildContext;
    public final List<RadialMenuOptionBuilder<RadialMenuBuilder>> options = new ArrayList<RadialMenuOptionBuilder<RadialMenuBuilder>>();
    public float innerRadius = 0.25f;
    public float outerRadius = 0.6f;
    public IDrawable innerIcon;

    public RadialMenuBuilder(UIBuildContext buildContext) {
        this.buildContext = buildContext;
    }

    public RadialMenuBuilder innerIcon(IDrawable icon) {
        this.innerIcon = icon;
        return this;
    }

    public RadialMenuBuilder innerIcon(ItemStack item) {
        this.innerIcon = new ItemDrawable(item).withOffset(-8.0f, -8.0f).withFixedSize(32.0f, 32.0f);
        return this;
    }

    public RadialMenuBuilder innerRadius(float radius) {
        this.innerRadius = radius;
        return this;
    }

    public RadialMenuBuilder outerRadius(float radius) {
        this.outerRadius = radius;
        return this;
    }

    public RadialMenuBuilder option(RadialMenuOptionBuilder<RadialMenuBuilder> option) {
        this.options.add(option);
        return this;
    }

    public RadialMenuOptionBuilderLeaf<RadialMenuBuilder> option() {
        RadialMenuOptionBuilderLeaf<RadialMenuBuilder> leaf = new RadialMenuOptionBuilderLeaf<RadialMenuBuilder>(this.buildContext, this);
        this.options.add(leaf);
        return leaf;
    }

    public RadialMenuOptionBuilderBranch<RadialMenuBuilder> branch() {
        RadialMenuOptionBuilderBranch<RadialMenuBuilder> branch = new RadialMenuOptionBuilderBranch<RadialMenuBuilder>(this.buildContext, this);
        this.options.add(branch);
        return branch;
    }

    public RadialMenuBuilder pipe(Consumer<RadialMenuBuilder> fn) {
        fn.accept(this);
        return this;
    }

    public RadialMenu build() {
        RadialMenu menu = new RadialMenu();
        menu.innerIcon = this.innerIcon;
        menu.innerRadius = this.innerRadius;
        menu.outerRadius = this.outerRadius;
        for (RadialMenuOptionBuilder<RadialMenuBuilder> option : this.options) {
            option.apply(menu);
        }
        return menu;
    }

    public static class RadialMenuOptionBuilderLeaf<Parent>
    extends RadialMenuOptionBuilder<Parent> {
        public RadialMenu.RadialMenuClickHandler onClicked;

        public RadialMenuOptionBuilderLeaf(UIBuildContext buildContext, Parent parent) {
            super(buildContext, parent);
        }

        public RadialMenuOptionBuilderLeaf<Parent> label(Supplier<String> label) {
            this.label = label;
            return this;
        }

        public RadialMenuOptionBuilderLeaf<Parent> label(String label) {
            this.label = () -> label;
            return this;
        }

        public RadialMenuOptionBuilderLeaf<Parent> weight(double weight) {
            this.weight = weight;
            return this;
        }

        public RadialMenuOptionBuilderLeaf<Parent> hidden(boolean hidden) {
            this.hidden = () -> hidden;
            return this;
        }

        public RadialMenuOptionBuilderLeaf<Parent> hidden(BooleanSupplier hidden) {
            this.hidden = hidden;
            return this;
        }

        public RadialMenuOptionBuilderLeaf<Parent> onClicked(RadialMenu.RadialMenuClickHandler onClicked) {
            this.onClicked = onClicked;
            return this;
        }

        public RadialMenuOptionBuilderLeaf<Parent> onClicked(Runnable onClicked) {
            this.onClicked = (menu, option, mouseButton, doubleClicked) -> {
                onClicked.run();
                this.buildContext.getPlayer().func_71053_j();
            };
            return this;
        }

        public RadialMenuOptionBuilderLeaf<Parent> onClicked(BooleanSupplier onClicked) {
            this.onClicked = (menu, option, mouseButton, doubleClicked) -> {
                if (onClicked.getAsBoolean()) {
                    this.buildContext.getPlayer().func_71053_j();
                }
            };
            return this;
        }

        public RadialMenuOptionBuilderLeaf<Parent> onClicked(int buttonId, Runnable onClicked) {
            this.onClicked = (menu, option, mouseButton, doubleClicked) -> {
                if (mouseButton == buttonId) {
                    onClicked.run();
                    this.buildContext.getPlayer().func_71053_j();
                }
            };
            return this;
        }

        @Override
        public void apply(RadialMenu menu) {
            RadialMenu.RadialMenuOption opt = new RadialMenu.RadialMenuOption();
            opt.label = this.label;
            opt.weight = this.weight;
            opt.hidden = this.hidden;
            opt.onClick = this.onClicked;
            menu.options.add(opt);
        }
    }

    public static class RadialMenuOptionBuilderBranch<Parent>
    extends RadialMenuOptionBuilder<Parent> {
        public final List<RadialMenuOptionBuilder<RadialMenuOptionBuilderBranch<Parent>>> children = new ArrayList<RadialMenuOptionBuilder<RadialMenuOptionBuilderBranch<Parent>>>();

        public RadialMenuOptionBuilderBranch(UIBuildContext buildContext, Parent parent) {
            super(buildContext, parent);
        }

        public RadialMenuOptionBuilderBranch<Parent> label(Supplier<String> label) {
            this.label = label;
            return this;
        }

        public RadialMenuOptionBuilderBranch<Parent> label(String label) {
            this.label = () -> label;
            return this;
        }

        public RadialMenuOptionBuilderBranch<Parent> weight(double weight) {
            this.weight = weight;
            return this;
        }

        public RadialMenuOptionBuilderBranch<Parent> hidden(boolean hidden) {
            this.hidden = () -> hidden;
            return this;
        }

        public RadialMenuOptionBuilderBranch<Parent> hidden(BooleanSupplier hidden) {
            this.hidden = hidden;
            return this;
        }

        public RadialMenuOptionBuilderBranch<Parent> option(RadialMenuOptionBuilder<RadialMenuOptionBuilderBranch<Parent>> option) {
            this.children.add(option);
            return this;
        }

        public RadialMenuOptionBuilderLeaf<RadialMenuOptionBuilderBranch<Parent>> option() {
            RadialMenuOptionBuilderLeaf<RadialMenuOptionBuilderBranch<Parent>> leaf = new RadialMenuOptionBuilderLeaf<RadialMenuOptionBuilderBranch<Parent>>(this.buildContext, this);
            this.children.add(leaf);
            return leaf;
        }

        public RadialMenuOptionBuilderBranch<RadialMenuOptionBuilderBranch<Parent>> branch() {
            RadialMenuOptionBuilderBranch<RadialMenuOptionBuilderBranch<Parent>> branch = new RadialMenuOptionBuilderBranch<RadialMenuOptionBuilderBranch<Parent>>(this.buildContext, this);
            this.children.add(branch);
            return branch;
        }

        @Override
        public void apply(RadialMenu menu) {
            RadialMenu.RadialMenuOption opt = new RadialMenu.RadialMenuOption();
            opt.label = this.label;
            opt.weight = this.weight;
            opt.hidden = this.hidden;
            opt.onClick = (_1, option, mouseButton, doubleClicked) -> {
                menu.options.clear();
                for (RadialMenuOptionBuilder<RadialMenuOptionBuilderBranch<Parent>> child : this.children) {
                    child.apply(menu);
                }
            };
            menu.options.add(opt);
        }
    }

    public static abstract class RadialMenuOptionBuilder<Parent> {
        public final UIBuildContext buildContext;
        public final Parent parent;
        public Supplier<String> label;
        public double weight = 1.0;
        public BooleanSupplier hidden = () -> false;

        public RadialMenuOptionBuilder(UIBuildContext buildContext, Parent parent) {
            this.buildContext = buildContext;
            this.parent = parent;
        }

        public abstract void apply(RadialMenu var1);

        public Parent done() {
            return this.parent;
        }
    }
}

