/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.building;

import appeng.helpers.ICustomNameObject;
import com.google.gson.JsonElement;
import com.gtnewhorizon.structurelib.alignment.IAlignment;
import com.gtnewhorizon.structurelib.alignment.IAlignmentProvider;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.alignment.enumerable.Flip;
import com.gtnewhorizon.structurelib.alignment.enumerable.Rotation;
import com.recursive_pineapple.matter_manipulator.MMMod;
import com.recursive_pineapple.matter_manipulator.common.building.BlockAnalyzer;
import com.recursive_pineapple.matter_manipulator.common.building.CoverData;
import com.recursive_pineapple.matter_manipulator.common.building.ITileAnalysisIntegration;
import com.recursive_pineapple.matter_manipulator.common.building.PortableItemStack;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.Transform;
import com.recursive_pineapple.matter_manipulator.common.utils.MMUtils;
import gregtech.api.covers.CoverRegistry;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.VoidingMode;
import gregtech.api.interfaces.IConfigurationCircuitSupport;
import gregtech.api.interfaces.IDataCopyable;
import gregtech.api.interfaces.IMEConnectable;
import gregtech.api.interfaces.metatileentity.IConnectable;
import gregtech.api.interfaces.metatileentity.IFluidLockable;
import gregtech.api.interfaces.metatileentity.IItemLockable;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicMachine;
import gregtech.api.metatileentity.implementations.MTEFluidPipe;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.common.covers.Cover;
import gregtech.common.tileentities.machines.multi.MTEIntegratedOreFactory;
import gtnhlanth.common.beamline.MTEBeamlinePipe;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.thing.metaTileEntity.hatch.MTEHatchDynamoTunnel;
import tectech.thing.metaTileEntity.hatch.MTEHatchEnergyTunnel;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;
import tectech.thing.metaTileEntity.pipe.MTEPipeData;
import tectech.thing.metaTileEntity.pipe.MTEPipeLaser;

public class GTAnalysisResult
implements ITileAnalysisIntegration {
    public byte mConnections = 0;
    public byte mGTColour = (byte)-1;
    public ForgeDirection mGTFront = null;
    public ForgeDirection mGTMainFacing = null;
    public short mGTFlags = 0;
    public ExtendedFacing mGTFacing = null;
    public CoverData[] mCovers = null;
    public byte mStrongRedstone = 0;
    public String mGTCustomName = null;
    public byte mGTGhostCircuit = 0;
    public PortableItemStack mGTItemLock = null;
    public String mGTFluidLock = null;
    public int mGTMode = 0;
    public JsonElement mGTData = null;
    public double[] mTTParams = null;
    public int mAmperes = 0;
    public byte mFluidPipeRestriction = 0;
    private static int counter = 0;
    private static final short GT_MACHINE_ENABLED = (short)(1 << counter++);
    private static final short GT_BASIC_IO_PUSH_ITEMS = (short)(1 << counter++);
    private static final short GT_BASIC_IO_PUSH_FLUIDS = (short)(1 << counter++);
    private static final short GT_BASIC_IO_DISABLE_FILTER = (short)(1 << counter++);
    private static final short GT_BASIC_IO_DISABLE_MULTISTACK = (short)(1 << counter++);
    private static final short GT_BASIC_IO_INPUT_FROM_OUTPUT_SIDE = (short)(1 << counter++);
    private static final short GT_INPUT_BUS_NO_SORTING = (short)(1 << counter++);
    private static final short GT_INPUT_BUS_NO_LIMITING = (short)(1 << counter++);
    private static final short GT_INPUT_BUS_NO_FILTERING = (short)(1 << counter++);
    private static final short GT_MULTI_PROTECT_ITEMS = (short)(1 << counter++);
    private static final short GT_MULTI_PROTECT_FLUIDS = (short)(1 << counter++);
    private static final short GT_MULTI_BATCH_MODE = (short)(1 << counter++);
    private static final short GT_MULTI_INPUT_SEPARATION = (short)(1 << counter++);
    private static final short GT_MULTI_RECIPE_LOCK = (short)(1 << counter++);
    private static final short GT_ME_CONNECT_ALL_SIDES = (short)(1 << counter++);
    private static final GTAnalysisResult NO_OP = new GTAnalysisResult();
    private static final MethodHandle GET_IOF_MODE = MMUtils.exposeFieldGetter(MTEIntegratedOreFactory.class, "sMode");
    private static final MethodHandle SET_IOF_MODE = MMUtils.exposeFieldSetter(MTEIntegratedOreFactory.class, "sMode");

    public static GTAnalysisResult analyze(TileEntity te) {
        if (te instanceof IGregTechTileEntity) {
            IGregTechTileEntity igte = (IGregTechTileEntity)te;
            GTAnalysisResult result = new GTAnalysisResult(igte);
            return result.equals(NO_OP) ? null : result;
        }
        return null;
    }

    public GTAnalysisResult() {
    }

    public GTAnalysisResult(IGregTechTileEntity igte) {
        IMEConnectable me;
        IItemLockable lockable;
        IConfigurationCircuitSupport ghostCircuit;
        ICustomNameObject customName;
        IConnectable connectable;
        IMetaTileEntity mte = igte.getMetaTileEntity();
        if (igte.getColorization() != -1) {
            this.mGTColour = igte.getColorization();
        }
        if (igte.isAllowedToWork()) {
            this.mGTFlags = (short)(this.mGTFlags | GT_MACHINE_ENABLED);
        }
        if (mte instanceof MTEBasicMachine) {
            MTEBasicMachine basicMachine = (MTEBasicMachine)mte;
            this.mGTMainFacing = basicMachine.mMainFacing;
            if (basicMachine.mItemTransfer) {
                this.mGTFlags = (short)(this.mGTFlags | GT_BASIC_IO_PUSH_ITEMS);
            }
            if (basicMachine.mFluidTransfer) {
                this.mGTFlags = (short)(this.mGTFlags | GT_BASIC_IO_PUSH_FLUIDS);
            }
            if (basicMachine.mDisableFilter) {
                this.mGTFlags = (short)(this.mGTFlags | GT_BASIC_IO_DISABLE_FILTER);
            }
            if (basicMachine.mDisableMultiStack) {
                this.mGTFlags = (short)(this.mGTFlags | GT_BASIC_IO_DISABLE_MULTISTACK);
            }
            if (basicMachine.mAllowInputFromOutputSide) {
                this.mGTFlags = (short)(this.mGTFlags | GT_BASIC_IO_INPUT_FROM_OUTPUT_SIDE);
            }
        }
        if (mte instanceof IConnectable && this.shouldMutateConnections(connectable = (IConnectable)mte)) {
            byte con = 0;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (!connectable.isConnectedAtSide(dir)) continue;
                con = (byte)(con | dir.flag);
            }
            this.mConnections = con;
        }
        if (mte instanceof MTEFluidPipe) {
            MTEFluidPipe fluidPipe = (MTEFluidPipe)mte;
            this.mFluidPipeRestriction = fluidPipe.mDisableInput;
        }
        if (mte instanceof IAlignmentProvider) {
            IAlignmentProvider provider = (IAlignmentProvider)mte;
            IAlignment alignment = provider.getAlignment();
            this.mGTFacing = alignment != null ? alignment.getExtendedFacing() : null;
        } else {
            this.mGTFront = MMUtils.nullIfUnknown(igte.getFrontFacing());
        }
        CoverData[] covers = new CoverData[6];
        boolean hasCover = false;
        byte strongRedstone = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!igte.hasCoverAtSide(dir)) continue;
            covers[dir.ordinal()] = CoverData.fromMachine((ICoverable)igte, dir);
            hasCover = true;
            if (!igte.getRedstoneOutputStrength(dir)) continue;
            strongRedstone = (byte)(strongRedstone | dir.flag);
        }
        if (hasCover) {
            this.mCovers = covers;
        }
        this.mStrongRedstone = strongRedstone;
        if (mte instanceof ICustomNameObject && (customName = (ICustomNameObject)mte).hasCustomName()) {
            this.mGTCustomName = customName.getCustomName();
        }
        if (mte instanceof IConfigurationCircuitSupport && (ghostCircuit = (IConfigurationCircuitSupport)mte).allowSelectCircuit()) {
            ItemStack circuit = mte.func_70301_a(ghostCircuit.getCircuitSlot());
            if (circuit == null || circuit.func_77973_b() == null) {
                this.mGTGhostCircuit = 0;
            } else if (circuit.func_77973_b() == ItemList.Circuit_Integrated.getItem()) {
                this.mGTGhostCircuit = (byte)Items.field_151008_G.getDamage(circuit);
            }
        }
        if (mte instanceof MTEHatchInputBus) {
            MTEHatchInputBus inputBus = (MTEHatchInputBus)mte;
            if (inputBus.disableSort) {
                this.mGTFlags = (short)(this.mGTFlags | GT_INPUT_BUS_NO_SORTING);
            }
            if (inputBus.disableLimited) {
                this.mGTFlags = (short)(this.mGTFlags | GT_INPUT_BUS_NO_LIMITING);
            }
            if (inputBus.disableFilter) {
                this.mGTFlags = (short)(this.mGTFlags | GT_INPUT_BUS_NO_FILTERING);
            }
        }
        if (mte instanceof IItemLockable && (lockable = (IItemLockable)mte).acceptsItemLock() && lockable.getLockedItem() != null) {
            this.mGTItemLock = new PortableItemStack(lockable.getLockedItem());
        }
        if (mte instanceof MTEHatchOutput) {
            MTEHatchOutput outputHatch = (MTEHatchOutput)mte;
            this.mGTMode = outputHatch.getMode();
        }
        if (mte instanceof IFluidLockable && (lockable = (IFluidLockable)mte).isFluidLocked()) {
            this.mGTFluidLock = lockable.getLockedFluidName();
        }
        if (mte instanceof MTEMultiBlockBase) {
            MTEMultiBlockBase multi = (MTEMultiBlockBase)mte;
            if (multi instanceof MTEIntegratedOreFactory) {
                MTEIntegratedOreFactory iof = (MTEIntegratedOreFactory)multi;
                this.mGTMode = GTAnalysisResult.getIOFMode(iof);
            } else {
                this.mGTMode = multi.machineMode;
            }
            if (multi.getVoidingMode().protectFluid) {
                this.mGTFlags = (short)(this.mGTFlags | GT_MULTI_PROTECT_FLUIDS);
            }
            if (multi.getVoidingMode().protectItem) {
                this.mGTFlags = (short)(this.mGTFlags | GT_MULTI_PROTECT_ITEMS);
            }
            if (multi.isBatchModeEnabled()) {
                this.mGTFlags = (short)(this.mGTFlags | GT_MULTI_BATCH_MODE);
            }
            if (multi.isInputSeparationEnabled()) {
                this.mGTFlags = (short)(this.mGTFlags | GT_MULTI_INPUT_SEPARATION);
            }
            if (multi.isRecipeLockingEnabled()) {
                this.mGTFlags = (short)(this.mGTFlags | GT_MULTI_RECIPE_LOCK);
            }
        }
        if (mte instanceof IDataCopyable) {
            IDataCopyable copyable = (IDataCopyable)mte;
            try {
                NBTTagCompound data = copyable.getCopiedData(null);
                if (data != null && !data.func_82582_d()) {
                    this.mGTData = MMUtils.toJsonObject((NBTBase)data);
                }
            }
            catch (Throwable t) {
                MMMod.LOG.error("Could not copy IDataCopyable's data", t);
            }
        }
        if (mte instanceof TTMultiblockBase) {
            TTMultiblockBase tt = (TTMultiblockBase)mte;
            if (tt.parametrization.hasInputs()) {
                this.mTTParams = tt.parametrization.getInputs();
            }
        }
        if (mte instanceof MTEHatchEnergyTunnel) {
            MTEHatchEnergyTunnel hatch = (MTEHatchEnergyTunnel)mte;
            this.mAmperes = hatch.Amperes;
        }
        if (mte instanceof MTEHatchDynamoTunnel) {
            MTEHatchDynamoTunnel dynamo = (MTEHatchDynamoTunnel)mte;
            this.mAmperes = dynamo.Amperes;
        }
        if (mte instanceof IMEConnectable && (me = (IMEConnectable)mte).connectsToAllSides()) {
            this.mGTFlags = (short)(this.mGTFlags | GT_ME_CONNECT_ALL_SIDES);
        }
    }

    private static int getIOFMode(MTEIntegratedOreFactory cal) {
        return GET_IOF_MODE.invokeExact(cal);
    }

    private static void setIOFMode(MTEIntegratedOreFactory cal, int mode) {
        SET_IOF_MODE.invokeExact(cal, mode);
    }

    @Override
    public boolean apply(BlockAnalyzer.IBlockApplyContext ctx) {
        TileEntity te = ctx.getTileEntity();
        if (te instanceof IGregTechTileEntity) {
            IItemLockable lockable;
            IConfigurationCircuitSupport ghostCircuit;
            IConnectable connectable;
            IGregTechTileEntity gte = (IGregTechTileEntity)te;
            IMetaTileEntity mte = gte.getMetaTileEntity();
            gte.setColorization(this.mGTColour);
            if ((this.mGTFlags & GT_MACHINE_ENABLED) != 0) {
                gte.enableWorking();
            } else {
                gte.disableWorking();
            }
            if (mte instanceof MTEBasicMachine) {
                MTEBasicMachine basicMachine = (MTEBasicMachine)mte;
                if (this.mGTMainFacing != null) {
                    basicMachine.setMainFacing(this.mGTMainFacing);
                    basicMachine.mHasBeenUpdated = true;
                }
                basicMachine.mItemTransfer = (this.mGTFlags & GT_BASIC_IO_PUSH_ITEMS) != 0;
                basicMachine.mFluidTransfer = (this.mGTFlags & GT_BASIC_IO_PUSH_FLUIDS) != 0;
                basicMachine.mDisableFilter = (this.mGTFlags & GT_BASIC_IO_DISABLE_FILTER) != 0;
                basicMachine.mDisableMultiStack = (this.mGTFlags & GT_BASIC_IO_DISABLE_MULTISTACK) != 0;
                boolean bl = basicMachine.mAllowInputFromOutputSide = (this.mGTFlags & GT_BASIC_IO_INPUT_FROM_OUTPUT_SIDE) != 0;
            }
            if (mte instanceof IConnectable && this.shouldMutateConnections(connectable = (IConnectable)mte)) {
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    boolean shouldBeConnected;
                    boolean bl = shouldBeConnected = (this.mConnections & dir.flag) != 0;
                    if (connectable.isConnectedAtSide(dir) == shouldBeConnected) continue;
                    if (shouldBeConnected) {
                        connectable.connect(dir);
                        continue;
                    }
                    connectable.disconnect(dir);
                }
            }
            if (mte instanceof MTEFluidPipe) {
                MTEFluidPipe fluidPipe = (MTEFluidPipe)mte;
                fluidPipe.mDisableInput = this.mFluidPipeRestriction;
            }
            if (mte instanceof IAlignmentProvider) {
                ForgeDirection[] provider = (ForgeDirection[])mte;
                IAlignment alignment = provider.getAlignment();
                if (this.mGTFacing != null && alignment != null) {
                    ExtendedFacing facing = this.mGTFacing;
                    if (!alignment.isNewExtendedFacingValid(facing)) {
                        facing = ExtendedFacing.of((ForgeDirection)this.mGTFacing.getDirection(), (Rotation)this.mGTFacing.getRotation(), (Flip)Flip.NONE);
                    }
                    if (alignment.isNewExtendedFacingValid(facing)) {
                        gte.setFrontFacing(facing.getDirection());
                        alignment.toolSetExtendedFacing(facing);
                    } else {
                        ctx.error("Could not set direction to '" + facing.getLocalizedName() + "'");
                    }
                }
            } else if (this.mGTFront != null) {
                gte.setFrontFacing(this.mGTFront);
            }
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                CoverData expected = this.mCovers == null ? null : this.mCovers[dir.ordinal()];
                Cover actual = gte.getCoverAtSide(dir);
                if (actual == CoverRegistry.NO_COVER && expected != null) {
                    this.installCover(ctx, gte, dir, expected);
                } else if (actual != CoverRegistry.NO_COVER && expected == null) {
                    this.removeCover(ctx, gte, dir);
                } else if (actual != CoverRegistry.NO_COVER) {
                    if (!ItemStack.func_77989_b((ItemStack)expected.getCoverStack(), (ItemStack)gte.getCoverItemAtSide(dir))) {
                        this.removeCover(ctx, gte, dir);
                        this.installCover(ctx, gte, dir, expected);
                    } else if (!Objects.equals(actual.writeToNBT(new NBTTagCompound()), expected.coverData)) {
                        this.updateCover(ctx, gte, dir, expected);
                    }
                }
                gte.setRedstoneOutputStrength(dir, (this.mStrongRedstone & dir.flag) != 0);
            }
            if (mte instanceof ICustomNameObject) {
                ICustomNameObject customName = (ICustomNameObject)mte;
                if (this.mGTCustomName != null) {
                    customName.setCustomName(this.mGTCustomName);
                }
            }
            if (mte instanceof IConfigurationCircuitSupport && (ghostCircuit = (IConfigurationCircuitSupport)mte).allowSelectCircuit()) {
                ItemStack circuit = null;
                if (this.mGTGhostCircuit > 0) {
                    circuit = ItemList.Circuit_Integrated.getWithDamage(0L, (long)this.mGTGhostCircuit, new Object[0]);
                }
                mte.func_70299_a(ghostCircuit.getCircuitSlot(), circuit);
                mte.func_70296_d();
            }
            if (mte instanceof MTEHatchInputBus) {
                MTEHatchInputBus inputBus = (MTEHatchInputBus)mte;
                inputBus.disableSort = (this.mGTFlags & GT_INPUT_BUS_NO_SORTING) != 0;
                inputBus.disableLimited = (this.mGTFlags & GT_INPUT_BUS_NO_LIMITING) != 0;
                boolean bl = inputBus.disableFilter = (this.mGTFlags & GT_INPUT_BUS_NO_FILTERING) != 0;
            }
            if (mte instanceof IItemLockable && (lockable = (IItemLockable)mte).acceptsItemLock()) {
                ItemStack lockedItem = this.mGTItemLock == null ? null : this.mGTItemLock.toStack();
                lockable.setLockedItem(lockedItem);
            }
            if (mte instanceof MTEHatchOutput) {
                MTEHatchOutput outputHatch = (MTEHatchOutput)mte;
                outputHatch.mMode = (byte)this.mGTMode;
            }
            if (mte instanceof IFluidLockable && (lockable = (IFluidLockable)mte).isFluidLocked()) {
                lockable.setLockedFluidName(this.mGTFluidLock);
            }
            if (mte instanceof MTEMultiBlockBase) {
                MTEMultiBlockBase multi = (MTEMultiBlockBase)mte;
                if (mte instanceof MTEIntegratedOreFactory) {
                    MTEIntegratedOreFactory iof = (MTEIntegratedOreFactory)mte;
                    GTAnalysisResult.setIOFMode(iof, this.mGTMode);
                } else {
                    multi.machineMode = this.mGTMode;
                }
                if (multi.supportsVoidProtection()) {
                    boolean protectFluids = (this.mGTFlags & GT_MULTI_PROTECT_FLUIDS) != 0;
                    boolean protectItems = (this.mGTFlags & GT_MULTI_PROTECT_ITEMS) != 0;
                    VoidingMode voidingMode = null;
                    for (VoidingMode mode : VoidingMode.values()) {
                        if (mode.protectFluid != protectFluids || mode.protectItem != protectItems) continue;
                        voidingMode = mode;
                        break;
                    }
                    if (voidingMode != null) {
                        multi.setVoidingMode(voidingMode);
                    } else {
                        throw new RuntimeException("This should never happen. protectFluids=" + protectFluids + ", protectItems=" + protectItems);
                    }
                }
                if (multi.supportsBatchMode()) {
                    multi.setBatchMode((this.mGTFlags & GT_MULTI_BATCH_MODE) != 0);
                }
                if (multi.supportsInputSeparation()) {
                    multi.setInputSeparation((this.mGTFlags & GT_MULTI_INPUT_SEPARATION) != 0);
                }
                if (multi.supportsSingleRecipeLocking()) {
                    multi.setRecipeLocking((this.mGTFlags & GT_MULTI_RECIPE_LOCK) != 0);
                }
            }
            if (mte instanceof IDataCopyable) {
                IDataCopyable copyable = (IDataCopyable)mte;
                NBTTagCompound data = this.mGTData == null ? new NBTTagCompound() : (NBTTagCompound)MMUtils.toNbt(this.mGTData);
                try {
                    if (!copyable.pasteCopiedData(null, data)) {
                        return false;
                    }
                }
                catch (Throwable t) {
                    MMMod.LOG.error("Could not paste IDataCopyable's data", t);
                }
            }
            if (this.mTTParams != null && this.mTTParams.length == 20 && mte instanceof TTMultiblockBase) {
                TTMultiblockBase tt = (TTMultiblockBase)mte;
                tt.parametrization.setInputs(this.mTTParams);
            }
            if (this.mAmperes > 0 && mte instanceof MTEHatchEnergyTunnel) {
                MTEHatchEnergyTunnel hatch = (MTEHatchEnergyTunnel)mte;
                hatch.Amperes = MMUtils.clamp(this.mAmperes, 0, hatch.maxAmperes);
            }
            if (this.mAmperes > 0 && mte instanceof MTEHatchDynamoTunnel) {
                MTEHatchDynamoTunnel dynamo = (MTEHatchDynamoTunnel)mte;
                dynamo.Amperes = MMUtils.clamp(this.mAmperes, 0, dynamo.maxAmperes);
            }
            if (mte instanceof IMEConnectable) {
                IMEConnectable me = (IMEConnectable)mte;
                me.setConnectsToAllSides((this.mGTFlags & GT_ME_CONNECT_ALL_SIDES) != 0);
            }
            if (mte instanceof MTEPipeLaser) {
                MTEPipeLaser laserPipe = (MTEPipeLaser)mte;
                laserPipe.updateNeighboringNetworks();
            }
            if (mte instanceof MTEPipeData) {
                MTEPipeData dataPipe = (MTEPipeData)mte;
                dataPipe.updateNeighboringNetworks();
            }
        }
        return true;
    }

    private void removeCover(BlockAnalyzer.IBlockApplyContext context, IGregTechTileEntity gte, ForgeDirection side) {
        if (gte.hasCoverAtSide(side)) {
            context.givePlayerItems(gte.detachCover(side));
        }
    }

    private void installCover(BlockAnalyzer.IBlockApplyContext context, IGregTechTileEntity gte, ForgeDirection side, CoverData cover) {
        ItemStack stack = cover.getCoverStack();
        if (!this.canPlace(gte, side, cover)) {
            context.error("Was not allowed to put cover on " + side.name().toLowerCase() + "side: " + stack.func_82833_r());
            return;
        }
        if (!context.tryConsumeItems(stack)) {
            context.error("Could not find cover: " + stack.func_82833_r());
            return;
        }
        CoverRegistry.getCoverPlacer((ItemStack)stack).placeCover(context.getRealPlayer(), stack, (ICoverable)gte, side);
        if (gte.getCoverAtSide(side).allowsCopyPasteTool()) {
            gte.updateAttachedCover(cover.coverID, side, cover.coverData);
        }
    }

    private void updateCover(BlockAnalyzer.IBlockApplyContext context, IGregTechTileEntity gte, ForgeDirection side, CoverData target) {
        Cover cover;
        if (gte.hasCoverAtSide(side) && ItemStack.func_77989_b((ItemStack)gte.getCoverItemAtSide(side), (ItemStack)target.getCoverStack()) && (cover = gte.getCoverAtSide(side)).allowsCopyPasteTool()) {
            gte.updateAttachedCover(target.coverID, cover.getSide(), target.coverData);
        }
    }

    private boolean shouldMutateConnections(IConnectable conn) {
        if (conn instanceof MTEPipeLaser) {
            return false;
        }
        if (conn instanceof MTEPipeData) {
            return false;
        }
        return !(conn instanceof MTEBeamlinePipe);
    }

    @Override
    public boolean getRequiredItemsForExistingBlock(BlockAnalyzer.IBlockApplyContext context) {
        TileEntity te = context.getTileEntity();
        if (te instanceof IGregTechTileEntity) {
            IGregTechTileEntity gte = (IGregTechTileEntity)te;
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                CoverData target = this.mCovers == null ? null : this.mCovers[side.ordinal()];
                Cover actual = gte.getCoverAtSide(side);
                ItemStack actualItem = gte.getCoverItemAtSide(side);
                if (!(actual == CoverRegistry.NO_COVER || target != null && ItemStack.func_77989_b((ItemStack)actualItem, (ItemStack)target.getCoverStack()))) {
                    context.givePlayerItems(actualItem);
                    actual = null;
                }
                if (actual != null || target == null || !this.canPlace(gte, side, target)) continue;
                context.tryConsumeItems(target.getCoverStack());
            }
        }
        return true;
    }

    @Override
    public boolean getRequiredItemsForNewBlock(BlockAnalyzer.IBlockApplyContext context) {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            CoverData target;
            CoverData coverData = target = this.mCovers == null ? null : this.mCovers[side.ordinal()];
            if (target == null) continue;
            context.tryConsumeItems(target.getCoverStack());
        }
        return true;
    }

    private boolean canPlace(IGregTechTileEntity gte, ForgeDirection side, CoverData cover) {
        ItemStack stack = cover.getCoverStack();
        return gte.getMetaTileEntity().allowCoverOnSide(side, stack);
    }

    @Override
    public void getItemTag(NBTTagCompound tag) {
    }

    @Override
    public void getItemDetails(List<String> details) {
    }

    @Override
    public void transform(Transform transform) {
        this.mGTFront = transform.apply(this.mGTFront);
        this.mGTMainFacing = transform.apply(this.mGTMainFacing);
        this.mGTFacing = transform.apply(this.mGTFacing);
        if (this.mCovers != null) {
            CoverData[] coversOut = new CoverData[this.mCovers.length];
            for (int i = 0; i < coversOut.length; ++i) {
                coversOut[transform.apply((ForgeDirection)ForgeDirection.VALID_DIRECTIONS[i]).ordinal()] = this.mCovers[i];
            }
            this.mCovers = coversOut;
        }
        this.mConnections = transform.applyBits(this.mConnections);
        this.mStrongRedstone = transform.applyBits(this.mStrongRedstone);
        this.mFluidPipeRestriction = transform.applyBits(this.mFluidPipeRestriction);
    }

    @Override
    public void migrate() {
        this.mGTMode = 0;
        this.mTTParams = null;
        this.mAmperes = 0;
    }

    @Override
    public GTAnalysisResult clone() {
        GTAnalysisResult dup = new GTAnalysisResult();
        dup.mConnections = this.mConnections;
        dup.mGTColour = this.mGTColour;
        dup.mGTFront = this.mGTFront;
        dup.mGTMainFacing = this.mGTMainFacing;
        dup.mGTFlags = this.mGTFlags;
        dup.mGTFacing = this.mGTFacing;
        dup.mCovers = this.mCovers == null ? null : MMUtils.mapToArray(this.mCovers, CoverData[]::new, x -> x == null ? null : x.clone());
        dup.mStrongRedstone = this.mStrongRedstone;
        dup.mGTCustomName = this.mGTCustomName;
        dup.mGTGhostCircuit = this.mGTGhostCircuit;
        dup.mGTItemLock = this.mGTItemLock == null ? null : this.mGTItemLock.clone();
        dup.mGTFluidLock = this.mGTFluidLock;
        dup.mGTMode = this.mGTMode;
        dup.mGTData = this.mGTData == null ? null : MMUtils.toJsonObject(MMUtils.toNbt(this.mGTData));
        dup.mTTParams = this.mTTParams == null ? null : (double[])this.mTTParams.clone();
        dup.mAmperes = this.mAmperes;
        dup.mFluidPipeRestriction = this.mFluidPipeRestriction;
        return dup;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mConnections;
        result = 31 * result + this.mGTColour;
        result = 31 * result + (this.mGTFront == null ? 0 : this.mGTFront.hashCode());
        result = 31 * result + (this.mGTMainFacing == null ? 0 : this.mGTMainFacing.hashCode());
        result = 31 * result + this.mGTFlags;
        result = 31 * result + (this.mGTFacing == null ? 0 : this.mGTFacing.hashCode());
        result = 31 * result + Arrays.hashCode(this.mCovers);
        result = 31 * result + this.mStrongRedstone;
        result = 31 * result + (this.mGTCustomName == null ? 0 : this.mGTCustomName.hashCode());
        result = 31 * result + this.mGTGhostCircuit;
        result = 31 * result + (this.mGTItemLock == null ? 0 : this.mGTItemLock.hashCode());
        result = 31 * result + (this.mGTFluidLock == null ? 0 : this.mGTFluidLock.hashCode());
        result = 31 * result + this.mGTMode;
        result = 31 * result + (this.mGTData == null ? 0 : this.mGTData.hashCode());
        result = 31 * result + Arrays.hashCode(this.mTTParams);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GTAnalysisResult other = (GTAnalysisResult)obj;
        if (this.mConnections != other.mConnections) {
            return false;
        }
        if (this.mGTColour != other.mGTColour) {
            return false;
        }
        if (this.mGTFront != other.mGTFront) {
            return false;
        }
        if (this.mGTMainFacing != other.mGTMainFacing) {
            return false;
        }
        if (this.mGTFlags != other.mGTFlags) {
            return false;
        }
        if (this.mGTFacing != other.mGTFacing) {
            return false;
        }
        if (!Arrays.equals(this.mCovers, other.mCovers)) {
            return false;
        }
        if (this.mStrongRedstone != other.mStrongRedstone) {
            return false;
        }
        if (this.mGTCustomName == null ? other.mGTCustomName != null : !this.mGTCustomName.equals(other.mGTCustomName)) {
            return false;
        }
        if (this.mGTGhostCircuit != other.mGTGhostCircuit) {
            return false;
        }
        if (this.mGTItemLock == null ? other.mGTItemLock != null : !this.mGTItemLock.equals(other.mGTItemLock)) {
            return false;
        }
        if (this.mGTFluidLock == null ? other.mGTFluidLock != null : !this.mGTFluidLock.equals(other.mGTFluidLock)) {
            return false;
        }
        if (this.mGTMode != other.mGTMode) {
            return false;
        }
        if (this.mGTData == null ? other.mGTData != null : !this.mGTData.equals(other.mGTData)) {
            return false;
        }
        return Arrays.equals(this.mTTParams, other.mTTParams);
    }
}

