/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.utils;

import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.implementations.parts.IPartCable;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.ICellWorkbenchItem;
import appeng.parts.automation.UpgradeInventory;
import appeng.util.Platform;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.gtnewhorizon.structurelib.util.XSTR;
import com.recursive_pineapple.matter_manipulator.MMMod;
import com.recursive_pineapple.matter_manipulator.asm.Optional;
import com.recursive_pineapple.matter_manipulator.common.building.BlockAnalyzer;
import com.recursive_pineapple.matter_manipulator.common.building.BlockSpec;
import com.recursive_pineapple.matter_manipulator.common.building.IPseudoInventory;
import com.recursive_pineapple.matter_manipulator.common.building.ImmutableBlockSpec;
import com.recursive_pineapple.matter_manipulator.common.building.InteropConstants;
import com.recursive_pineapple.matter_manipulator.common.building.MMInventory;
import com.recursive_pineapple.matter_manipulator.common.building.PendingBlock;
import com.recursive_pineapple.matter_manipulator.common.building.PortableItemStack;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.ItemMatterManipulator;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.Location;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.MMState;
import com.recursive_pineapple.matter_manipulator.common.utils.BigItemStack;
import com.recursive_pineapple.matter_manipulator.common.utils.InventoryAdapter;
import com.recursive_pineapple.matter_manipulator.common.utils.ItemId;
import com.recursive_pineapple.matter_manipulator.common.utils.Mods;
import cpw.mods.fml.relauncher.ReflectionHelper;
import gregtech.api.GregTechAPI;
import gregtech.api.interfaces.metatileentity.IConnectable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasInventory;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.common.blocks.BlockMachines;
import gregtech.common.tileentities.machines.MTEHatchInputBusME;
import gregtech.common.tileentities.machines.MTEHatchInputME;
import it.unimi.dsi.fastutil.booleans.BooleanObjectImmutablePair;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemReed;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public class MMUtils {
    public static final int TOOLTIP_AE_WORKS = 1;
    public static final int TOOLTIP_UPLINK_WORKS = 2;
    private static final Map<Locale, DecimalFormat> decimalFormatters = new HashMap<Locale, DecimalFormat>();
    public static final String BLACK = EnumChatFormatting.BLACK.toString();
    public static final String DARK_BLUE = EnumChatFormatting.DARK_BLUE.toString();
    public static final String DARK_GREEN = EnumChatFormatting.DARK_GREEN.toString();
    public static final String DARK_AQUA = EnumChatFormatting.DARK_AQUA.toString();
    public static final String DARK_RED = EnumChatFormatting.DARK_RED.toString();
    public static final String DARK_PURPLE = EnumChatFormatting.DARK_PURPLE.toString();
    public static final String GOLD = EnumChatFormatting.GOLD.toString();
    public static final String GRAY = EnumChatFormatting.GRAY.toString();
    public static final String DARK_GRAY = EnumChatFormatting.DARK_GRAY.toString();
    public static final String BLUE = EnumChatFormatting.BLUE.toString();
    public static final String GREEN = EnumChatFormatting.GREEN.toString();
    public static final String AQUA = EnumChatFormatting.AQUA.toString();
    public static final String RED = EnumChatFormatting.RED.toString();
    public static final String LIGHT_PURPLE = EnumChatFormatting.LIGHT_PURPLE.toString();
    public static final String YELLOW = EnumChatFormatting.YELLOW.toString();
    public static final String WHITE = EnumChatFormatting.WHITE.toString();
    public static final String OBFUSCATED = EnumChatFormatting.OBFUSCATED.toString();
    public static final String BOLD = EnumChatFormatting.BOLD.toString();
    public static final String STRIKETHROUGH = EnumChatFormatting.STRIKETHROUGH.toString();
    public static final String UNDERLINE = EnumChatFormatting.UNDERLINE.toString();
    public static final String ITALIC = EnumChatFormatting.ITALIC.toString();
    public static final String RESET = EnumChatFormatting.RESET.toString();
    public static final Pattern FORMATTING_CODE_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    private static final Pattern INTEGER = Pattern.compile("\\d+");
    private static final Pattern FLOAT = Pattern.compile("\\d+\\.\\d+");
    public static final int PLAN_AUTO_SUBMIT = 1;
    public static final int PLAN_ALL = 2;
    private static final XSTR RNG = new XSTR();

    private MMUtils() {
    }

    public static int clamp(int val, int lo, int hi) {
        return MathHelper.func_76125_a((int)val, (int)lo, (int)hi);
    }

    public static long clamp(long val, long lo, long hi) {
        return val < lo ? lo : (val > hi ? hi : val);
    }

    public static int min(int first, int ... rest) {
        for (int i = 0; i < rest.length; ++i) {
            int l = rest[i];
            if (l >= first) continue;
            first = l;
        }
        return first;
    }

    public static long min(long first, long ... rest) {
        for (int i = 0; i < rest.length; ++i) {
            long l = rest[i];
            if (l >= first) continue;
            first = l;
        }
        return first;
    }

    public static int max(int first, int ... rest) {
        for (int i = 0; i < rest.length; ++i) {
            int l = rest[i];
            if (l <= first) continue;
            first = l;
        }
        return first;
    }

    public static long max(long first, long ... rest) {
        for (int i = 0; i < rest.length; ++i) {
            long l = rest[i];
            if (l <= first) continue;
            first = l;
        }
        return first;
    }

    public static int ceilDiv(int lhs, int rhs) {
        return (lhs + rhs - 1) / rhs;
    }

    public static int ceilDiv2(int lhs, int rhs) {
        int sign = MMUtils.signum(lhs) * MMUtils.signum(rhs);
        if (lhs == 0) {
            return 0;
        }
        if (rhs == 0) {
            throw new ArithmeticException("/ by zero");
        }
        lhs = Math.abs(lhs);
        rhs = Math.abs(rhs);
        int unsigned = 1 + (lhs - 1) / rhs;
        return unsigned * sign;
    }

    public static long ceilDiv(long lhs, long rhs) {
        return (lhs + rhs - 1L) / rhs;
    }

    public static int signum(int x) {
        return x < 0 ? -1 : (x > 0 ? 1 : 0);
    }

    public static long signum(long x) {
        return x < 0L ? -1L : (x > 0L ? 1L : 0L);
    }

    public static Vector3i signum(Vector3i v) {
        v.x = MMUtils.signum(v.x);
        v.y = MMUtils.signum(v.y);
        v.z = MMUtils.signum(v.z);
        return v;
    }

    public static long ceilLong(double d) {
        long l = (long)d;
        return d > (double)l ? l + 1L : l;
    }

    public static MovingObjectPosition getHitResult(EntityPlayer player, boolean includeLiquids) {
        double d;
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP mp = (EntityPlayerMP)player;
            d = mp.field_71134_c.getBlockReachDistance();
        } else {
            d = Minecraft.func_71410_x().field_71442_b.func_78757_d();
        }
        double reachDistance = d;
        Vec3 posVec = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + (double)player.func_70047_e()), (double)player.field_70161_v);
        Vec3 lookVec = player.func_70676_i(1.0f);
        Vec3 modifiedPosVec = posVec.func_72441_c(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance);
        MovingObjectPosition hit = player.field_70170_p.func_72901_a(posVec, modifiedPosVec, includeLiquids);
        return hit != null && hit.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK ? null : hit;
    }

    public static Vector3i getLookingAtLocation(EntityPlayer player) {
        Vector3i target;
        Vec3 end;
        MovingObjectPosition hit;
        double d;
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP mp = (EntityPlayerMP)player;
            d = mp.field_71134_c.getBlockReachDistance();
        } else {
            d = Minecraft.func_71410_x().field_71442_b.func_78757_d();
        }
        double dist = d;
        Vec3 start = player.func_70666_h(0.0f);
        Vec3 look = player.func_70040_Z();
        if (player instanceof EntityPlayerMP) {
            start.field_72448_b += (double)player.func_70047_e();
        }
        if ((hit = player.field_70170_p.func_72933_a(start, end = Vec3.func_72443_a((double)(start.field_72450_a + look.field_72450_a * dist), (double)(start.field_72448_b + look.field_72448_b * dist), (double)(start.field_72449_c + look.field_72449_c * dist)))) != null && hit.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            target = new Vector3i(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
            if (!player.func_70093_af()) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)hit.field_72310_e);
                target.add(dir.offsetX, dir.offsetY, dir.offsetZ);
            }
        } else {
            target = new Vector3i(MathHelper.func_76128_c((double)end.field_72450_a), MathHelper.func_76128_c((double)end.field_72448_b), MathHelper.func_76128_c((double)end.field_72449_c));
        }
        return target;
    }

    public static Vector3i getRegionDeltas(Location a, Location b) {
        if (a == null || b == null || a.worldId != b.worldId) {
            return null;
        }
        int x1 = a.x;
        int y1 = a.y;
        int z1 = a.z;
        int x2 = b.x;
        int y2 = b.y;
        int z2 = b.z;
        int minX = Math.min(x1, x2);
        int minY = Math.min(y1, y2);
        int minZ = Math.min(z1, z2);
        int maxX = Math.max(x1, x2);
        int maxY = Math.max(y1, y2);
        int maxZ = Math.max(z1, z2);
        int dX = (maxX - minX) * (minX < x1 ? -1 : 1);
        int dY = (maxY - minY) * (minY < y1 ? -1 : 1);
        int dZ = (maxZ - minZ) * (minZ < z1 ? -1 : 1);
        return new Vector3i(dX, dY, dZ);
    }

    public static Vector3i getRegionDeltas(Location a, Location b, Location c) {
        if (a == null || b == null || c == null || a.worldId != b.worldId || a.worldId != c.worldId) {
            return null;
        }
        Vector3i vA = a.toVec();
        Vector3i vB = b.toVec();
        Vector3i vC = c.toVec();
        Vector3i max = new Vector3i((Vector3ic)vA).max((Vector3ic)vB).max((Vector3ic)vC);
        Vector3i min = new Vector3i((Vector3ic)vA).min((Vector3ic)vB).min((Vector3ic)vC);
        int dX = (max.x - min.x) * (min.x < a.x ? -1 : 1);
        int dY = (max.y - min.y) * (min.y < a.y ? -1 : 1);
        int dZ = (max.z - min.z) * (min.z < a.z ? -1 : 1);
        return new Vector3i(dX, dY, dZ);
    }

    public static AxisAlignedBB getBoundingBox(Location l, Vector3i deltas) {
        int minX = Math.min(l.x, l.x + deltas.x);
        int minY = Math.min(l.y, l.y + deltas.y);
        int minZ = Math.min(l.z, l.z + deltas.z);
        int maxX = Math.max(l.x, l.x + deltas.x) + 1;
        int maxY = Math.max(l.y, l.y + deltas.y) + 1;
        int maxZ = Math.max(l.z, l.z + deltas.z) + 1;
        return AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public static List<Vector3i> getBlocksInBB(Location l, Vector3i deltas) {
        int minX = Math.min(l.x, l.x + deltas.x);
        int minY = Math.min(l.y, l.y + deltas.y);
        int minZ = Math.min(l.z, l.z + deltas.z);
        int maxX = Math.max(l.x, l.x + deltas.x) + 1;
        int maxY = Math.max(l.y, l.y + deltas.y) + 1;
        int maxZ = Math.max(l.z, l.z + deltas.z) + 1;
        int dX = maxX - minX;
        int dY = maxY - minY;
        int dZ = maxZ - minZ;
        ArrayList<Vector3i> blocks = new ArrayList<Vector3i>();
        for (int y = 0; y < dY; ++y) {
            for (int z = 0; z < dZ; ++z) {
                for (int x = 0; x < dX; ++x) {
                    blocks.add(new Vector3i(minX + x, minY + y, minZ + z));
                }
            }
        }
        return blocks;
    }

    public static void sendErrorToPlayer(EntityPlayer aPlayer, String aChatMessage) {
        if (aPlayer instanceof EntityPlayerMP && aChatMessage != null) {
            aPlayer.func_146105_b((IChatComponent)new ChatComponentText(RED + aChatMessage));
        }
    }

    public static void sendWarningToPlayer(EntityPlayer aPlayer, String aChatMessage) {
        if (aPlayer instanceof EntityPlayerMP && aChatMessage != null) {
            aPlayer.func_146105_b((IChatComponent)new ChatComponentText(GOLD + aChatMessage));
        }
    }

    public static void sendInfoToPlayer(EntityPlayer aPlayer, String aChatMessage) {
        if (aPlayer instanceof EntityPlayerMP && aChatMessage != null) {
            aPlayer.func_146105_b((IChatComponent)new ChatComponentText(GRAY + aChatMessage));
        }
    }

    public static void sendChatToPlayer(EntityPlayer aPlayer, String aChatMessage) {
        if (aPlayer instanceof EntityPlayerMP && aChatMessage != null) {
            aPlayer.func_146105_b((IChatComponent)new ChatComponentText(aChatMessage));
        }
    }

    public static String stripFormat(String text) {
        return FORMATTING_CODE_PATTERN.matcher(text).replaceAll("");
    }

    private static DecimalFormat getDecimalFormat() {
        return decimalFormatters.computeIfAbsent(Locale.getDefault(Locale.Category.FORMAT), locale -> {
            DecimalFormat numberFormat = new DecimalFormat();
            numberFormat.setGroupingUsed(true);
            numberFormat.setMaximumFractionDigits(2);
            numberFormat.setRoundingMode(RoundingMode.HALF_UP);
            DecimalFormatSymbols decimalFormatSymbols = numberFormat.getDecimalFormatSymbols();
            decimalFormatSymbols.setGroupingSeparator(',');
            numberFormat.setDecimalFormatSymbols(decimalFormatSymbols);
            return numberFormat;
        });
    }

    public static String formatNumbers(BigInteger aNumber) {
        return MMUtils.getDecimalFormat().format(aNumber);
    }

    public static String formatNumbers(long aNumber) {
        return MMUtils.getDecimalFormat().format(aNumber);
    }

    public static String formatNumbers(double aNumber) {
        return MMUtils.getDecimalFormat().format(aNumber);
    }

    public static EntityPlayer getPlayerById(UUID playerId) {
        for (EntityPlayer player : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            if (!player.func_146103_bH().getId().equals(playerId)) continue;
            return player;
        }
        return null;
    }

    public static Object2LongOpenHashMap<ItemId> getItemStackHistogram(Iterable<ItemStack> stacks) {
        return MMUtils.getItemStackHistogram(stacks, true);
    }

    public static Object2LongOpenHashMap<ItemId> getItemStackHistogram(Iterable<ItemStack> stacks, boolean NBTSensitive) {
        Object2LongOpenHashMap histogram = new Object2LongOpenHashMap();
        if (stacks == null) {
            return histogram;
        }
        for (ItemStack stack : stacks) {
            if (stack == null || stack.func_77973_b() == null) continue;
            histogram.addTo((Object)ItemId.create(stack), (long)stack.field_77994_a);
        }
        return histogram;
    }

    public static StackMapDiff getStackMapDiff(Object2LongOpenHashMap<ItemId> before, Object2LongOpenHashMap<ItemId> after) {
        HashSet keys = new HashSet();
        keys.addAll(before.keySet());
        keys.addAll(after.keySet());
        StackMapDiff diff = new StackMapDiff();
        for (ItemId id : keys) {
            long beforeAmount = before.getLong((Object)id);
            long afterAmount = after.getLong((Object)id);
            if (afterAmount < beforeAmount) {
                diff.removed.addTo((Object)id, beforeAmount - afterAmount);
                continue;
            }
            if (beforeAmount >= afterAmount) continue;
            diff.added.addTo((Object)id, afterAmount - beforeAmount);
        }
        return diff;
    }

    public static List<ItemStack> getStacksOfSize(Object2LongOpenHashMap<ItemId> map, int maxStackSize) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        map.forEach((item, amount) -> {
            while (amount > 0L) {
                int toRemove = Math.min(amount > Integer.MAX_VALUE ? Integer.MAX_VALUE : amount.intValue(), maxStackSize);
                list.add(item.getItemStack(toRemove));
                amount = amount - (long)toRemove;
            }
        });
        return list;
    }

    public static List<ItemStack> getStacksOfSize(List<ItemStack> map, int maxStackSize) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        map.forEach(stack -> {
            while (stack.field_77994_a > 0) {
                int toRemove = Math.min(stack.field_77994_a, maxStackSize);
                ItemStack copy = stack.func_77946_l();
                copy.field_77994_a = toRemove;
                list.add(copy);
                stack.field_77994_a -= toRemove;
            }
        });
        return list;
    }

    public static List<ItemStack> mergeStacks(List<ItemStack> stacks) {
        return MMUtils.mergeStacks(stacks, false, false);
    }

    public static List<ItemStack> mergeStacks(List<ItemStack> stacks, boolean keepNBT, boolean NBTSensitive) {
        ArrayList<ItemStack> out = new ArrayList<ItemStack>();
        HashMap<ItemId, ItemStack> map = new HashMap<ItemId, ItemStack>();
        for (ItemStack stack : stacks) {
            if (stack == null || stack.func_77973_b() == null) continue;
            ItemId id = NBTSensitive ? ItemId.create(stack) : ItemId.createWithoutNBT(stack);
            ItemStack match = (ItemStack)map.get(id);
            if (match == null) {
                match = stack.func_77946_l();
                if (!keepNBT) {
                    match.func_77982_d(null);
                }
                map.put(id, match);
                out.add(match);
                continue;
            }
            match.field_77994_a += stack.field_77994_a;
        }
        return out;
    }

    public static <S, T> List<T> mapToList(Collection<S> in, Function<S, T> mapper) {
        if (in == null) {
            return null;
        }
        ArrayList<T> out = new ArrayList<T>(in.size());
        for (S s : in) {
            out.add(mapper.apply(s));
        }
        return out;
    }

    public static <S, T> List<T> mapToList(S[] in, Function<S, T> mapper) {
        if (in == null) {
            return null;
        }
        ArrayList<T> out = new ArrayList<T>(in.length);
        for (S s : in) {
            out.add(mapper.apply(s));
        }
        return out;
    }

    public static <S, T> T[] mapToArray(Collection<S> in, IntFunction<T[]> ctor, Function<S, T> mapper) {
        if (in == null) {
            return null;
        }
        T[] out = ctor.apply(in.size());
        Iterator<S> iter = in.iterator();
        for (int i = 0; i < out.length && iter.hasNext(); ++i) {
            out[i] = mapper.apply(iter.next());
        }
        return out;
    }

    public static <S, T> T[] mapToArray(S[] in, IntFunction<T[]> ctor, Function<S, T> mapper) {
        if (in == null) {
            return null;
        }
        T[] out = ctor.apply(in.length);
        for (int i = 0; i < out.length; ++i) {
            out[i] = mapper.apply(in[i]);
        }
        return out;
    }

    public static Stream<ItemStack> streamInventory(IInventory inv) {
        return IntStream.range(0, inv.func_70302_i_()).mapToObj(arg_0 -> ((IInventory)inv).func_70301_a(arg_0));
    }

    public static ItemStack[] inventoryToArray(IInventory inv) {
        return MMUtils.inventoryToArray(inv, true);
    }

    public static ItemStack[] inventoryToArray(IInventory inv, boolean copyStacks) {
        ItemStack[] array = new ItemStack[inv.func_70302_i_()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = copyStacks ? ItemStack.func_77944_b((ItemStack)inv.func_70301_a(i)) : inv.func_70301_a(i);
        }
        return array;
    }

    public static ForgeDirection nullIfUnknown(ForgeDirection dir) {
        return dir == ForgeDirection.UNKNOWN ? null : dir;
    }

    public static <T> int indexOf(T[] array, T value) {
        int l = array.length;
        for (int i = 0; i < l; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static <T> T getIndexSafe(T[] array, int index) {
        return array == null || index < 0 || index >= array.length ? null : (T)array[index];
    }

    public static <T> T getIndexSafe(List<T> list, int index) {
        return list == null || index < 0 || index >= list.size() ? null : (T)list.get(index);
    }

    public static <T> T choose(List<T> list, Random rng) {
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return list.get(rng.nextInt(list.size()));
    }

    public static void emptyInventory(IPseudoInventory dest, IInventory src) {
        if (src == null) {
            return;
        }
        InventoryAdapter adapter = InventoryAdapter.findAdapter(src);
        if (adapter == null) {
            return;
        }
        int size = src.func_70302_i_();
        for (int slot = 0; slot < size; ++slot) {
            ItemStack stack;
            if (!adapter.isValidSlot(src, slot) || (stack = src.func_70301_a(slot)) == null || stack.func_77973_b() == null || stack.field_77994_a == 0 || (stack = adapter.extract(src, slot)) == null || stack.func_77973_b() == null) continue;
            dest.givePlayerItems(MMUtils.resetItem(dest, stack));
        }
        src.func_70296_d();
    }

    public static ItemStack resetItem(IPseudoInventory dest, ItemStack stack) {
        if (Mods.AppliedEnergistics2.isModLoaded()) {
            stack = MMUtils.resetAEItem(dest, stack);
        }
        return stack;
    }

    @Optional(value={"appliedenergistics2"})
    private static ItemStack resetAEItem(IPseudoInventory dest, ItemStack stack) {
        ICellWorkbenchItem cellWorkbenchItem;
        Item item = stack.func_77973_b();
        if (item instanceof ICellWorkbenchItem && (cellWorkbenchItem = (ICellWorkbenchItem)item).isEditable(stack)) {
            MMUtils.emptyInventory(dest, cellWorkbenchItem.getUpgradesInventory(stack));
            MMUtils.clearInventory(cellWorkbenchItem.getConfigInventory(stack));
            NBTTagCompound tag = Platform.openNbtData((ItemStack)stack);
            tag.func_82580_o("FuzzyMode");
            tag.func_82580_o("upgrades");
            tag.func_82580_o("list");
            tag.func_82580_o("OreFilter");
            if (tag.func_82582_d()) {
                tag = null;
            }
            stack.func_77982_d(tag);
        }
        return stack;
    }

    public static boolean isSlotValid(IInventory inv, int slot) {
        return !Mods.GregTech.isModLoaded() || MMUtils.isSlotValidGT(inv, slot);
    }

    private static boolean isSlotValidGT(IInventory inv, int slot) {
        if (inv instanceof IHasInventory) {
            IHasInventory hasInv = (IHasInventory)inv;
            return hasInv.isValidSlot(slot);
        }
        return true;
    }

    @Optional(value={"gregtech_nh"})
    public static boolean isStockingBus(IInventory inv) {
        BaseMetaTileEntity base;
        return inv instanceof BaseMetaTileEntity && (base = (BaseMetaTileEntity)inv).getMetaTileEntity() instanceof MTEHatchInputBusME;
    }

    @Optional(value={"gregtech_nh"})
    public static boolean isStockingHatch(IFluidHandler tank) {
        BaseMetaTileEntity base;
        return tank instanceof BaseMetaTileEntity && (base = (BaseMetaTileEntity)tank).getMetaTileEntity() instanceof MTEHatchInputME;
    }

    public static void clearInventory(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            inv.func_70299_a(i, null);
        }
        inv.func_70296_d();
    }

    public static PortableItemStack[] fromInventory(IInventory inventory) {
        List<ItemStack> merged = MMUtils.mergeStacks(Arrays.asList(MMUtils.inventoryToArray(inventory, false)));
        ArrayList<PortableItemStack> out = new ArrayList<PortableItemStack>();
        for (ItemStack stack : merged) {
            out.add(new PortableItemStack(stack));
        }
        return out.toArray(new PortableItemStack[out.size()]);
    }

    public static PortableItemStack[] fromInventoryNoMerge(IInventory inventory) {
        PortableItemStack[] out = new PortableItemStack[inventory.func_70302_i_()];
        for (int i = 0; i < out.length; ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            out[i] = stack == null ? null : new PortableItemStack(stack);
        }
        return out;
    }

    public static boolean installUpgrades(IPseudoInventory src, UpgradeInventory dest, PortableItemStack[] pupgrades, boolean consume, boolean simulate) {
        List extracted;
        boolean success = true;
        List<ItemStack> stacks = MMUtils.mapToList(pupgrades, PortableItemStack::toStack);
        stacks.removeIf(i -> i == null || !(i.func_77973_b() instanceof IUpgradeModule));
        for (ItemStack stack : stacks) {
            stack.field_77994_a = Math.min(stack.field_77994_a, dest.getMaxInstalled(((IUpgradeModule)stack.func_77973_b()).getType(stack)));
        }
        Object2LongOpenHashMap<ItemId> actual = MMUtils.getItemStackHistogram(Arrays.asList(MMUtils.inventoryToArray((IInventory)dest)));
        Object2LongOpenHashMap<ItemId> target = MMUtils.getItemStackHistogram(stacks);
        StackMapDiff diff = MMUtils.getStackMapDiff(actual, target);
        if (diff.removed.isEmpty() && diff.added.isEmpty()) {
            return success;
        }
        List<ItemStack> toInstall = MMUtils.getStacksOfSize(diff.added, dest.func_70297_j_());
        long installable = (long)dest.func_70302_i_() - actual.values().longStream().sum() + diff.removed.values().longStream().sum();
        List<BigItemStack> toInstallBig = toInstall.subList(0, Math.min(toInstall.size(), (int)installable)).stream().map(BigItemStack::create).collect(Collectors.toList());
        if (consume) {
            ObjectIterator result = src.tryConsumeItems(toInstallBig, 4);
            extracted = (List)result.right();
            for (BigItemStack bigItemStack : toInstallBig) {
                for (BigItemStack found : extracted) {
                    if (!found.isSameType(bigItemStack)) continue;
                    bigItemStack.stackSize -= found.stackSize;
                }
            }
            if (src instanceof BlockAnalyzer.IBlockApplyContext) {
                BlockAnalyzer.IBlockApplyContext ctx = (BlockAnalyzer.IBlockApplyContext)src;
                for (BigItemStack wanted : toInstallBig) {
                    if (wanted.stackSize <= 0L) continue;
                    ctx.warn("Could not find upgrade: " + wanted.getItemStack().func_82833_r() + " x " + wanted.stackSize);
                    success = false;
                }
            }
        } else {
            extracted = MMUtils.mapToList(toInstallBig, BigItemStack::copy);
        }
        if (!simulate) {
            for (Object2LongMap.Entry e : diff.removed.object2LongEntrySet()) {
                long l = e.getLongValue();
                for (int slot = 0; slot < dest.func_70302_i_() && l > 0L; ++slot) {
                    ItemStack inSlot = dest.func_70301_a(slot);
                    if (!((ItemId)e.getKey()).isSameAs(inSlot)) continue;
                    src.givePlayerItems(inSlot);
                    dest.func_70299_a(slot, null);
                    --l;
                }
            }
            int slot = 0;
            block6: for (BigItemStack bigItemStack : extracted) {
                for (ItemStack split : bigItemStack.toStacks(1)) {
                    while (dest.func_70301_a(slot) != null) {
                        if (++slot < dest.func_70302_i_()) continue;
                        MMMod.LOG.error("Tried to install too many upgrades: voiding the rest. Dest={}, upgrade={}, slot={}", new Object[]{dest, split, slot, new Exception()});
                        if (!(src instanceof BlockAnalyzer.IBlockApplyContext)) break block6;
                        BlockAnalyzer.IBlockApplyContext ctx = (BlockAnalyzer.IBlockApplyContext)src;
                        ctx.error("Tried to install too many upgrades: voiding the rest (this is a bug, please report it)");
                        break block6;
                    }
                    dest.func_70299_a(slot++, split);
                }
            }
            dest.func_70296_d();
        }
        return success;
    }

    public static NBTTagCompound copy(NBTTagCompound tag) {
        return tag == null ? null : tag;
    }

    public static ItemStack copyWithAmount(ItemStack stack, int amount) {
        if (stack == null) {
            return null;
        }
        stack = stack.func_77946_l();
        stack.field_77994_a = amount;
        return stack;
    }

    public static JsonElement toJsonObject(NBTBase nbt) {
        if (nbt == null) {
            return null;
        }
        if (nbt instanceof NBTTagCompound) {
            NBTTagCompound nbtTagCompound = (NBTTagCompound)nbt;
            Map tagMap = nbtTagCompound.field_74784_a;
            JsonObject root = new JsonObject();
            for (Map.Entry nbtEntry : tagMap.entrySet()) {
                root.add((String)nbtEntry.getKey(), MMUtils.toJsonObject((NBTBase)nbtEntry.getValue()));
            }
            return root;
        }
        if (nbt instanceof NBTTagByte) {
            return new JsonPrimitive((Number)((NBTTagByte)nbt).func_150290_f());
        }
        if (nbt instanceof NBTTagShort) {
            return new JsonPrimitive((Number)((NBTTagShort)nbt).func_150289_e());
        }
        if (nbt instanceof NBTTagInt) {
            return new JsonPrimitive((Number)((NBTTagInt)nbt).func_150287_d());
        }
        if (nbt instanceof NBTTagLong) {
            return new JsonPrimitive((Number)((NBTTagLong)nbt).func_150291_c());
        }
        if (nbt instanceof NBTTagFloat) {
            return new JsonPrimitive((Number)Float.valueOf(((NBTTagFloat)nbt).func_150288_h()));
        }
        if (nbt instanceof NBTTagDouble) {
            return new JsonPrimitive((Number)((NBTTagDouble)nbt).func_150286_g());
        }
        if (nbt instanceof NBTBase.NBTPrimitive) {
            return new JsonPrimitive((Number)((NBTBase.NBTPrimitive)nbt).func_150286_g());
        }
        if (nbt instanceof NBTTagString) {
            return new JsonPrimitive(((NBTTagString)nbt).func_150285_a_());
        }
        if (nbt instanceof NBTTagList) {
            NBTTagList list = (NBTTagList)nbt;
            JsonArray arr = new JsonArray();
            list.field_74747_a.forEach(c -> arr.add(MMUtils.toJsonObject((NBTBase)c)));
            return arr;
        }
        if (nbt instanceof NBTTagIntArray) {
            NBTTagIntArray list = (NBTTagIntArray)nbt;
            JsonArray arr = new JsonArray();
            for (int i : list.func_150302_c()) {
                arr.add((JsonElement)new JsonPrimitive((Number)i));
            }
            return arr;
        }
        if (nbt instanceof NBTTagByteArray) {
            NBTTagByteArray list = (NBTTagByteArray)nbt;
            JsonArray arr = new JsonArray();
            for (byte i : list.func_150292_c()) {
                arr.add((JsonElement)new JsonPrimitive((Number)i));
            }
            return arr;
        }
        throw new IllegalArgumentException("Unsupported NBT Tag: " + NBTBase.field_82578_b[nbt.func_74732_a()] + " - " + nbt);
    }

    public static NBTBase toNbt(JsonElement jsonElement) {
        if (jsonElement == null || jsonElement == JsonNull.INSTANCE) {
            return null;
        }
        if (jsonElement instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
            if (jsonPrimitive.isNumber()) {
                float fval;
                if (jsonPrimitive.getAsBigDecimal().remainder(BigDecimal.ONE).equals(BigDecimal.ZERO)) {
                    long lval = jsonPrimitive.getAsLong();
                    if (lval >= -128L && lval <= 127L) {
                        return new NBTTagByte((byte)lval);
                    }
                    if (lval >= -32768L && lval <= 32767L) {
                        return new NBTTagShort((short)lval);
                    }
                    if (lval >= Integer.MIN_VALUE && lval <= Integer.MAX_VALUE) {
                        return new NBTTagInt((int)lval);
                    }
                    return new NBTTagLong(lval);
                }
                double dval = jsonPrimitive.getAsDouble();
                if (Math.abs(dval - (double)(fval = (float)dval)) < 1.0E-4) {
                    return new NBTTagFloat(fval);
                }
                return new NBTTagDouble(dval);
            }
            return new NBTTagString(jsonPrimitive.getAsString());
        }
        if (jsonElement instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)jsonElement;
            ArrayList<NBTBase> nbtList = new ArrayList<NBTBase>();
            byte type = -1;
            for (JsonElement element : jsonArray) {
                NBTBase tag;
                if (element == null || element == JsonNull.INSTANCE || (tag = MMUtils.toNbt(element)) == null) continue;
                if (type == -1) {
                    type = tag.func_74732_a();
                }
                if (type != tag.func_74732_a()) {
                    throw new IllegalArgumentException("NBT lists cannot contain tags of varying types");
                }
                nbtList.add(tag);
            }
            if (type == 3) {
                return new NBTTagIntArray(nbtList.stream().mapToInt(i -> ((NBTTagInt)i).func_150287_d()).toArray());
            }
            if (type == 1) {
                byte[] abyte = new byte[nbtList.size()];
                for (int i2 = 0; i2 < nbtList.size(); ++i2) {
                    abyte[i2] = ((NBTTagByte)nbtList.get(i2)).func_150290_f();
                }
                return new NBTTagByteArray(abyte);
            }
            NBTTagList nbtTagList = new NBTTagList();
            nbtList.forEach(arg_0 -> ((NBTTagList)nbtTagList).func_74742_a(arg_0));
            return nbtTagList;
        }
        if (jsonElement instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            for (Map.Entry jsonEntry : jsonObject.entrySet()) {
                if (jsonEntry.getValue() == JsonNull.INSTANCE) continue;
                nbtTagCompound.func_74782_a((String)jsonEntry.getKey(), MMUtils.toNbt((JsonElement)jsonEntry.getValue()));
            }
            return nbtTagCompound;
        }
        throw new IllegalArgumentException("Unhandled element " + jsonElement);
    }

    public static JsonElement toJsonObjectExact(NBTBase nbt) {
        if (nbt == null) {
            return null;
        }
        if (nbt instanceof NBTTagCompound) {
            NBTTagCompound nbtTagCompound = (NBTTagCompound)nbt;
            Map tagMap = nbtTagCompound.field_74784_a;
            JsonObject root = new JsonObject();
            for (Map.Entry nbtEntry : tagMap.entrySet()) {
                root.add((String)nbtEntry.getKey(), MMUtils.toJsonObjectExact((NBTBase)nbtEntry.getValue()));
            }
            return root;
        }
        if (nbt instanceof NBTTagByte) {
            NBTTagByte b = (NBTTagByte)nbt;
            return new JsonPrimitive("b" + b.func_150290_f());
        }
        if (nbt instanceof NBTTagShort) {
            NBTTagShort half = (NBTTagShort)nbt;
            return new JsonPrimitive("h" + half.func_150289_e());
        }
        if (nbt instanceof NBTTagInt) {
            NBTTagInt i = (NBTTagInt)nbt;
            return new JsonPrimitive("i" + Integer.toUnsignedString(i.func_150287_d(), 16));
        }
        if (nbt instanceof NBTTagLong) {
            NBTTagLong l = (NBTTagLong)nbt;
            return new JsonPrimitive("l" + Long.toUnsignedString(l.func_150291_c(), 16));
        }
        if (nbt instanceof NBTTagFloat) {
            NBTTagFloat f = (NBTTagFloat)nbt;
            return new JsonPrimitive("f" + Long.toUnsignedString(Float.floatToIntBits(f.func_150288_h()), 16));
        }
        if (nbt instanceof NBTTagDouble) {
            NBTTagDouble d = (NBTTagDouble)nbt;
            return new JsonPrimitive("d" + Long.toUnsignedString(Double.doubleToLongBits(d.func_150286_g()), 16));
        }
        if (nbt instanceof NBTBase.NBTPrimitive) {
            NBTBase.NBTPrimitive other = (NBTBase.NBTPrimitive)nbt;
            return new JsonPrimitive("d" + Long.toUnsignedString(Double.doubleToLongBits(other.func_150286_g()), 16));
        }
        if (nbt instanceof NBTTagString) {
            NBTTagString s = (NBTTagString)nbt;
            return new JsonPrimitive("s" + s.func_150285_a_());
        }
        if (nbt instanceof NBTTagList) {
            NBTTagList l = (NBTTagList)nbt;
            JsonArray arr = new JsonArray();
            l.field_74747_a.forEach(c -> arr.add(MMUtils.toJsonObjectExact((NBTBase)c)));
            return arr;
        }
        if (nbt instanceof NBTTagIntArray) {
            NBTTagIntArray a = (NBTTagIntArray)nbt;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            for (int i : a.func_150302_c()) {
                try {
                    dos.writeInt(i);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return new JsonPrimitive("1" + Base64.getEncoder().encodeToString(baos.toByteArray()));
        }
        if (nbt instanceof NBTTagByteArray) {
            NBTTagByteArray a = (NBTTagByteArray)nbt;
            return new JsonPrimitive("2" + Base64.getEncoder().encodeToString(a.func_150292_c()));
        }
        throw new IllegalArgumentException("Unsupported NBT Tag: " + NBTBase.field_82578_b[nbt.func_74732_a()] + " - " + nbt);
    }

    public static NBTBase toNbtExact(JsonElement jsonElement) throws JsonParseException {
        if (jsonElement == null) {
            return null;
        }
        if (jsonElement instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)jsonElement;
            if (!primitive.isString()) {
                throw new JsonParseException("expected json primitive to be string: '" + primitive + "'");
            }
            String data = primitive.getAsString();
            if (data.length() < 2) {
                throw new JsonParseException("illegal json primitive string: '" + data + "'");
            }
            char prefix = data.charAt(0);
            data = data.substring(1);
            try {
                switch (prefix) {
                    case 'b': {
                        return new NBTTagByte(Byte.parseByte(data));
                    }
                    case 'h': {
                        return new NBTTagShort(Short.parseShort(data));
                    }
                    case 'i': {
                        return new NBTTagInt(Integer.parseUnsignedInt(data, 16));
                    }
                    case 'l': {
                        return new NBTTagLong(Long.parseUnsignedLong(data, 16));
                    }
                    case 'f': {
                        return new NBTTagFloat(Float.intBitsToFloat((int)Long.parseUnsignedLong(data, 16)));
                    }
                    case 'd': {
                        return new NBTTagDouble(Double.longBitsToDouble(Long.parseUnsignedLong(data, 16)));
                    }
                    case 's': {
                        return new NBTTagString(data);
                    }
                    case '1': {
                        ByteArrayInputStream bais = new ByteArrayInputStream(Base64.getDecoder().decode(data));
                        DataInputStream dis = new DataInputStream(bais);
                        int count = bais.available() / 4;
                        int[] array = new int[count];
                        for (int i = 0; i < count; ++i) {
                            try {
                                array[i] = dis.readInt();
                                continue;
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        return new NBTTagIntArray(array);
                    }
                    case '2': {
                        return new NBTTagByteArray(Base64.getDecoder().decode(data));
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new JsonParseException("illegal number: " + primitive, (Throwable)e);
            }
        } else {
            if (jsonElement instanceof JsonArray) {
                JsonArray array = (JsonArray)jsonElement;
                NBTTagList list = new NBTTagList();
                for (JsonElement e : array) {
                    list.func_74742_a(MMUtils.toNbtExact(e));
                }
                return list;
            }
            if (jsonElement instanceof JsonObject) {
                JsonObject obj = (JsonObject)jsonElement;
                NBTTagCompound tag = new NBTTagCompound();
                for (Map.Entry jsonEntry : obj.entrySet()) {
                    tag.func_74782_a((String)jsonEntry.getKey(), MMUtils.toNbtExact((JsonElement)jsonEntry.getValue()));
                }
                return tag;
            }
        }
        throw new IllegalArgumentException("Unhandled element " + jsonElement);
    }

    public static boolean isTruthy(JsonElement element) {
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean();
            }
            if (primitive.isNumber()) {
                return primitive.getAsNumber().doubleValue() != 0.0;
            }
            String value = primitive.getAsString();
            if ("true".equals(value)) {
                return true;
            }
            if ("false".equals(value)) {
                return false;
            }
            if (INTEGER.matcher(value).matches()) {
                return Long.parseLong(value) != 0L;
            }
            if (FLOAT.matcher(value).matches()) {
                return Double.parseDouble(value) != 0.0;
            }
            return !value.isEmpty();
        }
        if (element.isJsonArray()) {
            return ((JsonArray)element).size() > 0;
        }
        if (element.isJsonObject()) {
            return !((JsonObject)element).entrySet().isEmpty();
        }
        return false;
    }

    public static boolean areStacksBasicallyEqual(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return a == null && b == null;
        }
        return a.func_77973_b() == b.func_77973_b() && a.func_77960_j() == b.func_77960_j() && ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    public static void createPlanImpl(EntityPlayer player, MMState state, ItemMatterManipulator manipulator, int flags) {
        state = state.clone();
        if (!Location.areCompatible(state.config.coordA, state.config.coordB)) {
            MMUtils.sendErrorToPlayer(player, StatCollector.func_74838_a((String)"mm.info.error.must_have_copy_region"));
            return;
        }
        if ((flags & 2) != 0) {
            if (!Location.areCompatible(state.config.coordA, state.config.coordC)) {
                state.config.coordC = state.config.coordA.clone();
            }
        } else if (!Location.areCompatible(state.config.coordA, state.config.coordC)) {
            MMUtils.sendErrorToPlayer(player, StatCollector.func_74838_a((String)"mm.info.error.must_have_paste_region"));
            return;
        }
        List<PendingBlock> blocks = state.getPendingBlocks(manipulator.tier, player.func_130014_f_());
        BlockAnalyzer.RequiredItemAnalysis itemAnalysis = BlockAnalyzer.getRequiredItemsForBuild(player, blocks, (flags & 2) != 0);
        List<BigItemStack> requiredItems = MMUtils.mapToList(itemAnalysis.requiredItems.entrySet(), (S e) -> BigItemStack.create((ItemId)e.getKey(), (Long)e.getValue()));
        MMInventory inv = new MMInventory(player, state, manipulator.tier);
        BooleanObjectImmutablePair<List<BigItemStack>> extractResult = inv.tryConsumeItems(requiredItems, 13);
        List availableItems = extractResult.right() == null ? new ArrayList() : (List)extractResult.right();
        MMUtils.sendInfoToPlayer(player, StatCollector.func_74838_a((String)"mm.info.required_items"));
        if (!requiredItems.isEmpty()) {
            requiredItems.stream().map(stack -> {
                long available = availableItems.stream().filter(s -> s.isSameType((BigItemStack)stack)).mapToLong(s -> s.getStackSize()).sum();
                if (stack.getStackSize() - available > 0L) {
                    return String.format("%s%s: %s%d%s (%s%d%s missing)", stack.getItemStack().func_82833_r(), GRAY, GOLD, stack.getStackSize(), GRAY, RED, stack.getStackSize() - available, GRAY);
                }
                return String.format("%s%s: %s%d%s", stack.getItemStack().func_82833_r(), GRAY, GOLD, stack.getStackSize(), GRAY);
            }).sorted().forEach(message -> MMUtils.sendInfoToPlayer(player, message));
        } else {
            MMUtils.sendInfoToPlayer(player, StatCollector.func_74838_a((String)"mm.info.none"));
        }
        if (!requiredItems.isEmpty()) {
            if (state.connectToUplink()) {
                if ((flags & 2) == 0) {
                    requiredItems.forEach(stack -> {
                        long available = availableItems.stream().filter(s -> s.isSameType((BigItemStack)stack)).mapToLong(s -> s.getStackSize()).sum();
                        stack.decStackSize(available);
                    });
                    Iterator<BigItemStack> iter = requiredItems.iterator();
                    while (iter.hasNext()) {
                        BigItemStack stack2 = iter.next();
                        if (stack2.getStackSize() != 0L) continue;
                        iter.remove();
                    }
                }
                if (!requiredItems.isEmpty()) {
                    state.uplink.submitPlan(player, state.config.coordA.toString(), requiredItems, (flags & 1) != 0);
                } else {
                    MMUtils.sendInfoToPlayer(player, StatCollector.func_74838_a((String)"mm.info.not_need_creating_pattern"));
                }
            } else {
                MMUtils.sendErrorToPlayer(player, StatCollector.func_74838_a((String)"mm.info.error.not_connected"));
            }
        }
    }

    public static MethodHandle exposeFieldGetter(Class<?> clazz, String ... names) {
        try {
            Field field = ReflectionHelper.findField(clazz, (String[])names);
            field.setAccessible(true);
            return MethodHandles.lookup().unreflectGetter(field);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not make field getter for " + clazz.getName() + ":" + names[0], e);
        }
    }

    public static MethodHandle exposeFieldSetter(Class<?> clazz, String ... names) {
        try {
            Field field = ReflectionHelper.findField(clazz, (String[])names);
            field.setAccessible(true);
            return MethodHandles.lookup().unreflectSetter(field);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not make field setter for " + clazz.getName() + ":" + names[0], e);
        }
    }

    public static <T, R> Function<T, R> exposeFieldGetterLambda(Class<? super T> clazz, String ... names) {
        MethodHandle method = MMUtils.exposeFieldGetter(clazz, names);
        return instance -> {
            try {
                return method.invoke(instance);
            }
            catch (Throwable e) {
                throw new RuntimeException("Could not get field " + clazz.getName() + ":" + names[0], e);
            }
        };
    }

    public static MethodHandle exposeMethod(Class<?> clazz, MethodType sig, String ... names) {
        try {
            Method method = ReflectionHelper.findMethod(clazz, null, (String[])names, (Class[])sig.parameterArray());
            method.setAccessible(true);
            return MethodHandles.lookup().unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not make method handle for " + clazz.getName() + ":" + names[0], e);
        }
    }

    public static Item getItemFromBlock(Block block, int metadata) {
        Item item;
        if (block == null) {
            block = Blocks.field_150350_a;
        }
        if ((item = Item.func_150898_a((Block)block)) == null) {
            item = block.func_149650_a(metadata, (Random)RNG, 0);
        }
        return item;
    }

    public static Block getBlockFromItem(Item item, int metadata) {
        if (item == null) {
            return Blocks.field_150350_a;
        }
        if (item == Items.field_151137_ax) {
            return Blocks.field_150488_af;
        }
        if (item instanceof ItemReed) {
            ItemReed specialPlacing = (ItemReed)item;
            return specialPlacing.field_150935_a;
        }
        if (Mods.AppliedEnergistics2.isModLoaded() && MMUtils.isAECable(item, metadata)) {
            return InteropConstants.AE_BLOCK_CABLE.getBlock();
        }
        return Block.func_149634_a((Item)item);
    }

    @Optional(value={"gregtech_nh"})
    public static boolean isGTMachine(ImmutableBlockSpec spec) {
        return spec.getBlock() instanceof BlockMachines && MMUtils.getIndexSafe(GregTechAPI.METATILEENTITIES, spec.getItemMeta()) != null;
    }

    @Optional(value={"gregtech_nh"})
    public static boolean isGTCable(ImmutableBlockSpec spec) {
        return spec.getBlock() instanceof BlockMachines && MMUtils.getIndexSafe(GregTechAPI.METATILEENTITIES, spec.getItemMeta()) instanceof IConnectable;
    }

    @Optional(value={"appliedenergistics2"})
    public static boolean isAECable(ImmutableBlockSpec spec) {
        if (spec == null) {
            return false;
        }
        return MMUtils.isAECable(spec.getItem(), spec.getItemMeta());
    }

    @Optional(value={"appliedenergistics2"})
    public static boolean isAECable(Item item, int metadata) {
        IPartItem partItem;
        return item instanceof IPartItem && (partItem = (IPartItem)item).createPartFromItemStack(new ItemStack(item, 1, metadata)) instanceof IPartCable;
    }

    @Optional(value={"appliedenergistics2"})
    public static boolean getAECable(BlockSpec spec, World world, int x, int y, int z) {
        IPartHost partHost;
        IPart iPart;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IPartHost && (iPart = (partHost = (IPartHost)tileEntity).getPart(ForgeDirection.UNKNOWN)) instanceof IPartCable) {
            IPartCable cable = (IPartCable)iPart;
            spec.setObject(cable.getItemStack(PartItemStack.Break));
            return true;
        }
        return false;
    }

    @Optional(value={"gregtech_nh"})
    public static boolean getGTCable(BlockSpec spec, World world, int x, int y, int z) {
        IGregTechTileEntity igte;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IGregTechTileEntity && (igte = (IGregTechTileEntity)tileEntity).getMetaTileEntity() instanceof IConnectable) {
            spec.setObject(Item.func_150898_a((Block)world.func_147439_a(x, y, z)), igte.getMetaTileID());
            return true;
        }
        return false;
    }

    public static String getDirectionDisplayName(ForgeDirection dir) {
        return MMUtils.getDirectionDisplayName(dir, false);
    }

    public static String getDirectionDisplayName(ForgeDirection dir, boolean unknownIsCentre) {
        String string;
        switch (dir) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case DOWN: {
                string = "Down";
                break;
            }
            case EAST: {
                string = "East";
                break;
            }
            case NORTH: {
                string = "North";
                break;
            }
            case SOUTH: {
                string = "South";
                break;
            }
            case UNKNOWN: {
                if (unknownIsCentre) {
                    string = "Center";
                    break;
                }
                string = "Unknown";
                break;
            }
            case UP: {
                string = "Up";
                break;
            }
            case WEST: {
                string = "West";
            }
        }
        return string;
    }

    public static <K, V> boolean areMapsEqual(Map<K, V> left, Map<K, V> right) {
        if (left == null || right == null) {
            return left == right;
        }
        HashSet<K> keys = new HashSet<K>(left.size() + right.size());
        keys.addAll(left.keySet());
        keys.addAll(right.keySet());
        for (Object key : keys) {
            if (Objects.equals(left.get(key), right.get(key))) continue;
            return false;
        }
        return true;
    }

    public static class StackMapDiff {
        public Object2LongOpenHashMap<ItemId> added = new Object2LongOpenHashMap();
        public Object2LongOpenHashMap<ItemId> removed = new Object2LongOpenHashMap();
    }
}

