/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.building;

import com.gtnewhorizon.gtnhlib.util.data.ImmutableBlockMeta;
import com.gtnewhorizon.gtnhlib.util.data.ImmutableItemMeta;
import com.recursive_pineapple.matter_manipulator.common.building.BlockSpec;
import com.recursive_pineapple.matter_manipulator.common.building.CopyableProperty;
import com.recursive_pineapple.matter_manipulator.common.building.InteropConstants;
import com.recursive_pineapple.matter_manipulator.common.building.PendingBlock;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public interface ImmutableBlockSpec
extends ImmutableItemMeta,
ImmutableBlockMeta {
    public GameRegistry.UniqueIdentifier getObjectId();

    @NotNull
    public Block getBlock();

    @NotNull
    public Item getItem();

    public PendingBlock instantiate(int var1, int var2, int var3, int var4);

    default public PendingBlock instantiate(World world, int x, int y, int z) {
        return this.instantiate(world.field_73011_w.field_76574_g, x, y, z);
    }

    public String getProperty(CopyableProperty var1);

    public ImmutableBlockSpec withProperties(Map<CopyableProperty, String> var1);

    default public boolean isEquivalent(ImmutableBlockSpec other) {
        return ItemStack.func_77989_b((ItemStack)this.toStack(1), (ItemStack)other.toStack(1));
    }

    default public boolean isAir() {
        return this.getObjectId() == null || this.getBlock() == null || InteropConstants.isAir(this.getBlock(), this.getBlockMeta());
    }

    default public boolean skipWhenCopying() {
        return InteropConstants.skipWhenCopying(this.getBlock(), this.getBlockMeta());
    }

    default public boolean shouldDropItem() {
        return InteropConstants.shouldDropItem(this.getBlock(), this.getBlockMeta());
    }

    default public boolean isFree() {
        return InteropConstants.isFree(this.getBlock(), this.getBlockMeta());
    }

    public void getItemDetails(List<String> var1);

    public static Comparator<ImmutableBlockSpec> getComparator() {
        return Comparator.comparing(s -> s.toStack(1), (a, b) -> {
            if (a == null && b != null) {
                return -1;
            }
            if (a != null && b == null) {
                return 1;
            }
            if (a == null && b == null) {
                return 0;
            }
            if (!1.$assertionsDisabled && a.func_77973_b() == null) {
                throw new AssertionError();
            }
            if (!1.$assertionsDisabled && b.func_77973_b() == null) {
                throw new AssertionError();
            }
            int result = String.CASE_INSENSITIVE_ORDER.compare(a.func_77973_b().delegate.name(), b.func_77973_b().delegate.name());
            if (result != 0) {
                return result;
            }
            result = Integer.compare(a.field_77991_e, b.field_77991_e);
            if (result != 0) {
                return result;
            }
            NBTTagCompound ta = a.func_77978_p();
            NBTTagCompound tb = b.func_77978_p();
            if (ta == null && tb != null) {
                return -1;
            }
            if (ta != null && tb == null) {
                return 1;
            }
            if (ta == null && tb == null) {
                return 0;
            }
            return Integer.compare(ta.hashCode(), tb.hashCode());
        });
    }

    public static BlockSpec fromBlockMeta(ImmutableBlockMeta bm) {
        return new BlockSpec().setObject(bm.getBlock(), bm.getBlockMeta());
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

