/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.api;

import com.kuba6000.mobsinfo.api.ConstructableItemStack;
import com.kuba6000.mobsinfo.api.utils.GSONUtils;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class VillagerTrade {
    TradeItem firstInput;
    TradeItem secondInput;
    TradeItem output;
    double chance;

    public VillagerTrade(@Nonnull TradeItem firstInput, @Nullable TradeItem secondInput, @Nonnull TradeItem output, double chance) {
        this.firstInput = firstInput;
        this.secondInput = secondInput;
        this.output = output;
        this.chance = chance;
    }

    public VillagerTrade(@Nonnull ItemStack firstInput, @Nullable ItemStack secondInput, @Nonnull ItemStack output, double chance) {
        this.firstInput = new TradeItem(firstInput);
        this.secondInput = secondInput == null ? null : new TradeItem(secondInput);
        this.output = new TradeItem(output);
        this.chance = chance;
    }

    public VillagerTrade(@Nonnull Item firstInput, @Nullable Item secondInput, @Nonnull Item output, double chance) {
        this.firstInput = new TradeItem(new ItemStack(firstInput));
        this.secondInput = secondInput == null ? null : new TradeItem(new ItemStack(secondInput));
        this.output = new TradeItem(new ItemStack(output));
        this.chance = chance;
    }

    public static VillagerTrade create(@Nonnull Item input, @Nonnull Item output) {
        return new VillagerTrade(input, null, output, 1.0);
    }

    public static VillagerTrade create(@Nonnull ItemStack input, @Nonnull ItemStack output) {
        return new VillagerTrade(input, null, output, 1.0);
    }

    public static VillagerTrade create(@Nonnull TradeItem input, @Nonnull TradeItem output) {
        return new VillagerTrade(input, null, output, 1.0);
    }

    public static TradeItem createItem(@Nonnull Item item) {
        return new TradeItem(new ItemStack(item));
    }

    public static TradeItem createItem(@Nonnull ItemStack item) {
        return new TradeItem(item);
    }

    public VillagerTrade withSecondaryInput(@Nonnull TradeItem secondInput) {
        this.secondInput = secondInput;
        return this;
    }

    public VillagerTrade withSecondaryInput(@Nonnull ItemStack secondInput) {
        this.secondInput = new TradeItem(secondInput);
        return this;
    }

    public VillagerTrade withSecondaryInput(@Nonnull Item secondInput) {
        this.secondInput = new TradeItem(new ItemStack(secondInput));
        return this;
    }

    public VillagerTrade withChance(double chance) {
        this.chance = chance;
        return this;
    }

    public boolean hasSecondInput() {
        return this.secondInput != null;
    }

    public TradeItem getFirstInput() {
        return this.firstInput;
    }

    public TradeItem getSecondInput() {
        return this.secondInput;
    }

    public TradeItem getOutput() {
        return this.output;
    }

    public double getChance() {
        return this.chance;
    }

    public void reconstructStacks() {
        this.firstInput.reconstructStack();
        if (this.secondInput != null) {
            this.secondInput.reconstructStack();
        }
        this.output.reconstructStack();
    }

    public static class TradeItem {
        @GSONUtils.SkipGSON
        public ItemStack stack;
        public ConstructableItemStack reconstructableStack;
        public Set<Integer> possibleSizes;
        public Integer enchantability;

        public TradeItem(@Nonnull ItemStack stack, @Nullable Set<Integer> possibleSizes, @Nullable Integer enchantability) {
            this.stack = stack;
            this.reconstructableStack = new ConstructableItemStack(this.stack);
            this.possibleSizes = possibleSizes;
            this.enchantability = enchantability;
        }

        public TradeItem(@Nonnull ItemStack stack) {
            this(stack, null, null);
        }

        public TradeItem withPossibleSizes(int min, int max) {
            this.possibleSizes = new HashSet<Integer>(max - min);
            for (int i = min; i <= max; ++i) {
                this.possibleSizes.add(i);
            }
            return this;
        }

        public TradeItem withRandomEnchant(int enchantmentPower) {
            this.enchantability = enchantmentPower;
            return this;
        }

        public void reconstructStack() {
            this.stack = this.reconstructableStack.construct();
        }
    }
}

