/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.modmixins.core;

import com.github.bartimaeusnek.modmixins.core.ClassPreLoader;
import com.github.bartimaeusnek.modmixins.core.LoadingConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0007H\u0016J(\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J(\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/github/bartimaeusnek/modmixins/core/ModMixinsPlugin;", "Lorg/spongepowered/asm/mixin/extensibility/IMixinConfigPlugin;", "()V", "acceptTargets", "", "myTargets", "", "", "otherTargets", "getMixins", "", "getRefMapperConfig", "onLoad", "mixinPackage", "postApply", "targetClassName", "targetClass", "Lorg/spongepowered/asm/lib/tree/ClassNode;", "mixinClassName", "mixinInfo", "Lorg/spongepowered/asm/mixin/extensibility/IMixinInfo;", "preApply", "shouldApplyMixin", "", "Companion", "MixinSets", "modmixins"})
public final class ModMixinsPlugin
implements IMixinConfigPlugin {
    @NotNull
    public static final String name = "ModMixinsPlugin";
    @NotNull
    private static final Logger log;
    private static boolean thermosTainted;
    public static final Companion Companion;

    public void onLoad(@NotNull String mixinPackage) {
        Intrinsics.checkNotNullParameter((Object)mixinPackage, (String)"mixinPackage");
    }

    @Nullable
    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(@NotNull String targetClassName, @NotNull String mixinClassName) {
        Intrinsics.checkNotNullParameter((Object)targetClassName, (String)"targetClassName");
        Intrinsics.checkNotNullParameter((Object)mixinClassName, (String)"mixinClassName");
        return true;
    }

    public void acceptTargets(@NotNull Set<String> myTargets, @NotNull Set<String> otherTargets) {
        Intrinsics.checkNotNullParameter(myTargets, (String)"myTargets");
        Intrinsics.checkNotNullParameter(otherTargets, (String)"otherTargets");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> getMixins() {
        void $this$filterTo$iv$iv;
        List mixins = new ArrayList();
        File gtjar = ClassPreLoader.INSTANCE.getJar("gregtech-5.09");
        Companion.loadJar(gtjar);
        MixinSets[] $this$filter$iv = MixinSets.values();
        boolean $i$f$filter = false;
        MixinSets[] mixinSetsArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var8_9 = $this$filterTo$iv$iv;
        int n = ((void)var8_9).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void p1 = element$iv$iv = var8_9[i];
            boolean bl = false;
            if (!p1.shouldBeLoaded()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MixinSets it = (MixinSets)((Object)element$iv);
            boolean bl = false;
            if (!it.loadJar()) continue;
            String[] stringArray = it.getMixinClasses();
            mixins.addAll(CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray, stringArray.length)));
            log.info("Loading modmixins plugin " + it.getFixname() + " with mixins: {}", new Object[]{it.getMixinClasses()});
            it.unloadJar();
        }
        Companion.unloadJar(gtjar);
        return mixins;
    }

    public void preApply(@NotNull String targetClassName, @NotNull ClassNode targetClass, @NotNull String mixinClassName, @NotNull IMixinInfo mixinInfo) {
        Intrinsics.checkNotNullParameter((Object)targetClassName, (String)"targetClassName");
        Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
        Intrinsics.checkNotNullParameter((Object)mixinClassName, (String)"mixinClassName");
        Intrinsics.checkNotNullParameter((Object)mixinInfo, (String)"mixinInfo");
    }

    public void postApply(@NotNull String targetClassName, @NotNull ClassNode targetClass, @NotNull String mixinClassName, @NotNull IMixinInfo mixinInfo) {
        Intrinsics.checkNotNullParameter((Object)targetClassName, (String)"targetClassName");
        Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
        Intrinsics.checkNotNullParameter((Object)mixinClassName, (String)"mixinClassName");
        Intrinsics.checkNotNullParameter((Object)mixinInfo, (String)"mixinInfo");
    }

    public ModMixinsPlugin() {
        LoadingConfig.INSTANCE.loadConfig(new File(Launch.minecraftHome, "config/ModMixinsPlugin.cfg"));
        try {
            Class.forName("org.bukkit.World");
            thermosTainted = true;
            log.warn("Thermos/Bukkit detected; This is an unsupported configuration -- Things may not function properly.");
        }
        catch (ClassNotFoundException e) {
            thermosTainted = false;
            log.info("Thermos/Bukkit not detected");
        }
    }

    static {
        Companion = new Companion(null);
        Logger logger = LogManager.getLogger((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LogManager.getLogger(name)");
        log = logger;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\n\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B+\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\u0002\u0010\tB/\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fB%\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\rB5\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u0014\u001a\u00020\u0006J\u0006\u0010\u0015\u001a\u00020\u0006J\r\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\u0018R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b \u00a8\u0006!"}, d2={"Lcom/github/bartimaeusnek/modmixins/core/ModMixinsPlugin$MixinSets;", "", "fixname", "", "applyIf", "Lkotlin/Function0;", "", "mixinClasses", "", "(Ljava/lang/String;ILjava/lang/String;Lkotlin/jvm/functions/Function0;[Ljava/lang/String;)V", "jar", "mixinClass", "(Ljava/lang/String;ILjava/lang/String;Lkotlin/jvm/functions/Function0;Ljava/lang/String;Ljava/lang/String;)V", "(Ljava/lang/String;ILjava/lang/String;Lkotlin/jvm/functions/Function0;Ljava/lang/String;)V", "(Ljava/lang/String;ILjava/lang/String;Lkotlin/jvm/functions/Function0;Ljava/lang/String;[Ljava/lang/String;)V", "getFixname", "()Ljava/lang/String;", "getMixinClasses", "()[Ljava/lang/String;", "[Ljava/lang/String;", "loadJar", "shouldBeLoaded", "unloadJar", "", "()Lkotlin/Unit;", "RAILCRAFT_BOILER_POLLUTION_FIX", "ROCKET_ADD_POLLUTION", "GC_TIME_COMMAND_FIX_GTNH", "FURNACE_ADD_POLLUTION", "TC_FURNACE_ADD_POLLUTION", "EXPLOSION_POLLUTION_ADDITION", "BIBLIOCRAFT_PACKAGE_FIX", "ZTONES_PACKAGE_FIX", "modmixins"})
    public static final class MixinSets
    extends Enum<MixinSets> {
        public static final /* enum */ MixinSets RAILCRAFT_BOILER_POLLUTION_FIX;
        public static final /* enum */ MixinSets ROCKET_ADD_POLLUTION;
        public static final /* enum */ MixinSets GC_TIME_COMMAND_FIX_GTNH;
        public static final /* enum */ MixinSets FURNACE_ADD_POLLUTION;
        public static final /* enum */ MixinSets TC_FURNACE_ADD_POLLUTION;
        public static final /* enum */ MixinSets EXPLOSION_POLLUTION_ADDITION;
        public static final /* enum */ MixinSets BIBLIOCRAFT_PACKAGE_FIX;
        public static final /* enum */ MixinSets ZTONES_PACKAGE_FIX;
        private static final /* synthetic */ MixinSets[] $VALUES;
        @NotNull
        private final String fixname;
        private final Function0<Boolean> applyIf;
        private final String jar;
        @NotNull
        private final String[] mixinClasses;

        static {
            MixinSets[] mixinSetsArray = new MixinSets[8];
            MixinSets[] mixinSetsArray2 = mixinSetsArray;
            mixinSetsArray[0] = RAILCRAFT_BOILER_POLLUTION_FIX = new MixinSets("Railcraft Pollution Fix", (Function0<Boolean>)((Function0)1.INSTANCE), "Railcraft", new String[]{"railcraft.boiler.RailcraftBoilerPollution", "railcraft.tileentity.MultiOfenPollution", "railcraft.entity.RailcraftTunnleBorePollution"});
            mixinSetsArray[1] = ROCKET_ADD_POLLUTION = new MixinSets("Rocket Pollution Fix", (Function0<Boolean>)((Function0)2.INSTANCE), "Galacticraft", new String[]{"galacticraft.entity.RocketPollutionAdder"});
            mixinSetsArray[2] = GC_TIME_COMMAND_FIX_GTNH = new MixinSets("Fix TimeCommand for GC without lag", (Function0<Boolean>)((Function0)3.INSTANCE), "Galacticraft", new String[]{"vanilla.command.TimeCommandGCFix"});
            mixinSetsArray[3] = FURNACE_ADD_POLLUTION = new MixinSets("Furnace Pollution Fix", (Function0<Boolean>)((Function0)4.INSTANCE), new String[]{"vanilla.tileentity.TileEntityFurnacePollution", "ic2.tileentity.IronFurnacePollution"});
            mixinSetsArray[4] = TC_FURNACE_ADD_POLLUTION = new MixinSets("Thaumcraft Furnace Pollution Fix", (Function0<Boolean>)((Function0)5.INSTANCE), new String[]{"thaumcraft.tileentity.AlchemicalConstructPollutionAdder"});
            mixinSetsArray[5] = EXPLOSION_POLLUTION_ADDITION = new MixinSets("Explosion Pollution Fix", (Function0<Boolean>)((Function0)6.INSTANCE), new String[]{"vanilla.world.ExplosionPollutionAdder"});
            mixinSetsArray[6] = BIBLIOCRAFT_PACKAGE_FIX = new MixinSets("BiblioCraft Network Vulnerability", (Function0<Boolean>)((Function0)7.INSTANCE), "BiblioCraft", new String[]{"bibliocraft.network.PackageFix"});
            mixinSetsArray[7] = ZTONES_PACKAGE_FIX = new MixinSets("Ztones Network Vulnerability", (Function0<Boolean>)((Function0)8.INSTANCE), "Ztones", new String[]{"ztones.network.PackageFix"});
            $VALUES = mixinSetsArray;
        }

        public final boolean shouldBeLoaded() {
            return (Boolean)this.applyIf.invoke();
        }

        public final boolean loadJar() {
            if (this.jar == null) {
                return true;
            }
            File file = ClassPreLoader.INSTANCE.getJar(this.jar);
            if (file != null) {
                File file2 = file;
                boolean bl = false;
                boolean bl2 = false;
                File it = file2;
                boolean bl3 = false;
                Companion.loadJar(it);
                return true;
            }
            new NullPointerException("Couldn't load " + this.jar + "! This will cause issues with the following Mixins: " + ArraysKt.joinToString$default((Object[])this.mixinClasses, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)).printStackTrace();
            return false;
        }

        @Nullable
        public final Unit unloadJar() {
            Unit unit;
            String string = this.jar;
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                Companion.unloadJar(ClassPreLoader.INSTANCE.getJar(it));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            return unit;
        }

        @NotNull
        public final String getFixname() {
            return this.fixname;
        }

        @NotNull
        public final String[] getMixinClasses() {
            return this.mixinClasses;
        }

        private MixinSets(String fixname, Function0<Boolean> applyIf, String jar, String[] mixinClasses) {
            this.fixname = fixname;
            this.applyIf = applyIf;
            this.jar = jar;
            this.mixinClasses = mixinClasses;
        }

        private MixinSets(String fixname, Function0<Boolean> applyIf, String[] mixinClasses) {
            this(fixname, applyIf, null, mixinClasses);
        }

        private MixinSets(String fixname, Function0<Boolean> applyIf, String jar, String mixinClass) {
            this(fixname, applyIf, jar, new String[]{mixinClass});
        }

        private MixinSets(String fixname, Function0<Boolean> applyIf, String mixinClass) {
            this(fixname, applyIf, null, mixinClass);
        }

        public static MixinSets[] values() {
            return (MixinSets[])$VALUES.clone();
        }

        public static MixinSets valueOf(String string) {
            return Enum.valueOf(MixinSets.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0010\u0010\u0013\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/github/bartimaeusnek/modmixins/core/ModMixinsPlugin$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "name", "", "thermosTainted", "", "getThermosTainted", "()Z", "setThermosTainted", "(Z)V", "loadJar", "", "jar", "Ljava/io/File;", "unloadJar", "modmixins"})
    public static final class Companion {
        @NotNull
        public final Logger getLog() {
            return log;
        }

        public final boolean getThermosTainted() {
            return thermosTainted;
        }

        public final void setThermosTainted(boolean bl) {
            thermosTainted = bl;
        }

        public final void loadJar(@Nullable File jar) {
            try {
                File file = jar;
                if (file != null) {
                    File file2 = file;
                    boolean bl = false;
                    boolean bl2 = false;
                    File it = file2;
                    boolean bl3 = false;
                    Companion.getLog().info("Attempting to load " + it);
                    if (!jar.exists()) {
                        throw (Throwable)new FileNotFoundException();
                    }
                    ClassPreLoader.INSTANCE.loadJar(it);
                }
            }
            catch (Exception ex) {
                this.getLog().catching((Throwable)ex);
            }
        }

        public final void unloadJar(@Nullable File jar) {
            try {
                File file = jar;
                if (file != null) {
                    File file2 = file;
                    boolean bl = false;
                    boolean bl2 = false;
                    File it = file2;
                    boolean bl3 = false;
                    Companion.getLog().info("Attempting to unload " + it);
                    if (!jar.exists()) {
                        throw (Throwable)new FileNotFoundException();
                    }
                    ClassPreLoader.INSTANCE.unloadJar(it);
                }
            }
            catch (Exception ex) {
                this.getLog().catching((Throwable)ex);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

