/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.drawable;

import com.gtnewhorizons.modularui.ModularUI;
import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.drawable.TextRenderer;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.mitchej123.hodgepodge.textures.IPatchedTextureAtlasSprite;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiHelper {
    private static final Stack<int[]> scissorFrameStack = new Stack();

    public static boolean hasScreen() {
        return Minecraft.func_71410_x().field_71462_r != null;
    }

    public static GuiScreen getActiveScreen() {
        return Minecraft.func_71410_x().field_71462_r;
    }

    public static Size getScreenSize() {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen != null) {
            return new Size(screen.field_146294_l, screen.field_146295_m);
        }
        return Size.ZERO;
    }

    public static Pos2d getCurrentMousePos() {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen != null) {
            int x = Mouse.getEventX() * screen.field_146294_l / Minecraft.func_71410_x().field_71443_c;
            int y = screen.field_146295_m - Mouse.getEventY() * screen.field_146295_m / Minecraft.func_71410_x().field_71440_d - 1;
            return new Pos2d(x, y);
        }
        return Pos2d.ZERO;
    }

    public static void drawHoveringText(List<Text> textLines, Pos2d mousePos, Size screenSize, int maxWidth, float scale, boolean forceShadow, Alignment alignment, boolean tooltipHasSpaceAfterFirstLine) {
        if (textLines.isEmpty()) {
            return;
        }
        List<Integer> colors = textLines.stream().map(Text::getColor).collect(Collectors.toList());
        List<String> lines = textLines.stream().map(line -> line.getFormatted()).collect(Collectors.toList());
        GuiHelper.drawHoveringTextFormatted(lines, colors, mousePos, screenSize, maxWidth, scale, forceShadow, alignment, tooltipHasSpaceAfterFirstLine);
    }

    public static void drawHoveringTextFormatted(List<String> lines, Pos2d mousePos, Size screenSize, int maxWidth) {
        GuiHelper.drawHoveringTextFormatted(lines, Collections.emptyList(), mousePos, screenSize, maxWidth, 1.0f, false, Alignment.TopLeft, true);
    }

    public static void drawHoveringTextFormatted(List<String> lines, List<Integer> colors, Pos2d mousePos, Size screenSize, int maxWidth, float scale, boolean forceShadow, Alignment alignment, boolean hasSpaceAfterFirstLine) {
        if (lines.isEmpty()) {
            return;
        }
        if (maxWidth < 0) {
            maxWidth = Integer.MAX_VALUE;
        }
        int maxTextWidth = maxWidth;
        boolean mouseOnRightSide = false;
        int screenSpaceRight = screenSize.width - mousePos.x - 16;
        if ((float)mousePos.x > (float)screenSize.width / 2.0f) {
            mouseOnRightSide = true;
        }
        if (maxTextWidth > screenSpaceRight) {
            maxTextWidth = screenSpaceRight;
        }
        boolean putOnLeft = false;
        int tooltipY = mousePos.y - 12;
        int tooltipX = mousePos.x + 12;
        TextRenderer renderer = new TextRenderer();
        renderer.setPos(mousePos);
        renderer.setAlignment(Alignment.TopLeft, maxTextWidth);
        renderer.setScale(scale);
        renderer.setShadow(forceShadow);
        renderer.setSimulate(true);
        List<Pair<String, Float>> measuredLines = renderer.measureLines(lines);
        if (mouseOnRightSide && measuredLines.size() > lines.size()) {
            putOnLeft = true;
            maxTextWidth = Math.min(maxWidth, mousePos.x - 16);
        }
        renderer.setAlignment(Alignment.TopLeft, maxTextWidth);
        measuredLines = renderer.measureLines(lines);
        renderer.drawMeasuredLines(measuredLines, colors, hasSpaceAfterFirstLine);
        int tooltipTextWidth = (int)renderer.lastWidth;
        int tooltipHeight = (int)renderer.lastHeight;
        if (mouseOnRightSide && putOnLeft) {
            tooltipX += -24 - tooltipTextWidth;
        }
        GlStateManager.disableRescaleNormal();
        RenderHelper.func_74518_a();
        GlStateManager.disableLighting();
        GlStateManager.disableDepth();
        int zLevel = 300;
        int backgroundColor = -267386864;
        int borderColorStart = 0x505000FF;
        int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
        GuiHelper.drawGradientRect(300.0f, tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, backgroundColor, backgroundColor);
        GuiHelper.drawGradientRect(300.0f, tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, backgroundColor, backgroundColor);
        GuiHelper.drawGradientRect(300.0f, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
        GuiHelper.drawGradientRect(300.0f, tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
        GuiHelper.drawGradientRect(300.0f, tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
        GuiHelper.drawGradientRect(300.0f, tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        GuiHelper.drawGradientRect(300.0f, tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        GuiHelper.drawGradientRect(300.0f, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, borderColorStart, borderColorStart);
        GuiHelper.drawGradientRect(300.0f, tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, borderColorEnd, borderColorEnd);
        renderer.setSimulate(false);
        renderer.setPos(tooltipX, tooltipY);
        renderer.setAlignment(alignment, maxTextWidth);
        renderer.setColor(0xFFFFFF);
        renderer.drawMeasuredLines(measuredLines, colors, hasSpaceAfterFirstLine);
        GlStateManager.enableLighting();
        GlStateManager.enableDepth();
        RenderHelper.func_74519_b();
        GlStateManager.enableRescaleNormal();
    }

    public static void drawGradientRect(float zLevel, float left, float top, float right, float bottom, int startColor, int endColor) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.disableTexture2D();
        GlStateManager.enableBlend();
        GlStateManager.disableAlpha();
        GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        GlStateManager.shadeModel(7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78371_b(7);
        tessellator.func_78369_a(startRed, startGreen, startBlue, startAlpha);
        tessellator.func_78377_a((double)right, (double)top, (double)zLevel);
        tessellator.func_78369_a(startRed, startGreen, startBlue, startAlpha);
        tessellator.func_78377_a((double)left, (double)top, (double)zLevel);
        tessellator.func_78369_a(endRed, endGreen, endBlue, endAlpha);
        tessellator.func_78377_a((double)left, (double)bottom, (double)zLevel);
        tessellator.func_78369_a(endRed, endGreen, endBlue, endAlpha);
        tessellator.func_78377_a((double)right, (double)bottom, (double)zLevel);
        tessellator.func_78381_a();
        GlStateManager.shadeModel(7424);
        GlStateManager.disableBlend();
        GlStateManager.enableAlpha();
        GlStateManager.enableTexture2D();
    }

    public static void drawFluidTexture(FluidStack content, float x0, float y0, float width, float height, float z) {
        if (content == null) {
            return;
        }
        Fluid fluid = content.getFluid();
        IIcon fluidStill = fluid.getIcon(content);
        int fluidColor = fluid.getColor(content);
        if (ModularUI.isHodgepodgeLoaded && fluidStill instanceof IPatchedTextureAtlasSprite) {
            ((IPatchedTextureAtlasSprite)fluidStill).markNeedsAnimationUpdate();
        }
        GlStateManager.enableBlend();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        float u0 = fluidStill.func_94209_e();
        float u1 = fluidStill.func_94212_f();
        float v0 = fluidStill.func_94206_g();
        float v1 = fluidStill.func_94210_h();
        float x1 = x0 + width;
        float y1 = y0 + height;
        float r = Color.getRedF(fluidColor);
        float g = Color.getGreenF(fluidColor);
        float b = Color.getBlueF(fluidColor);
        float a = Color.getAlphaF(fluidColor);
        a = a == 0.0f ? 1.0f : a;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(r, g, b, a);
        tessellator.func_78385_a((double)u0, (double)v1);
        tessellator.func_78377_a((double)x0, (double)y1, (double)z);
        tessellator.func_78385_a((double)u1, (double)v1);
        tessellator.func_78377_a((double)x1, (double)y1, (double)z);
        tessellator.func_78385_a((double)u1, (double)v0);
        tessellator.func_78377_a((double)x1, (double)y0, (double)z);
        tessellator.func_78385_a((double)u0, (double)v0);
        tessellator.func_78377_a((double)x0, (double)y0, (double)z);
        tessellator.func_78381_a();
        GlStateManager.disableBlend();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void useScissor(int x, int y, int width, int height, Runnable codeBlock) {
        GuiHelper.pushScissorFrame(x, y, width, height);
        try {
            codeBlock.run();
        }
        finally {
            GuiHelper.popScissorFrame();
        }
    }

    private static int[] peekFirstScissorOrFullScreen() {
        int[] currentTopFrame;
        int[] nArray = currentTopFrame = scissorFrameStack.isEmpty() ? null : scissorFrameStack.peek();
        if (currentTopFrame == null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            return new int[]{0, 0, minecraft.field_71443_c, minecraft.field_71440_d};
        }
        return currentTopFrame;
    }

    public static void pushScissorFrame(int x, int y, int width, int height) {
        int[] parentScissor = GuiHelper.peekFirstScissorOrFullScreen();
        int parentX = parentScissor[0];
        int parentY = parentScissor[1];
        int parentWidth = parentScissor[2];
        int parentHeight = parentScissor[3];
        boolean pushedFrame = false;
        if (x <= parentX + parentWidth && y <= parentY + parentHeight) {
            int newX = Math.max(x, parentX);
            int newY = Math.max(y, parentY);
            int newWidth = width - (newX - x);
            int newHeight = height - (newY - y);
            if (newWidth > 0 && newHeight > 0) {
                int maxWidth = parentWidth - (x - parentX);
                int maxHeight = parentHeight - (y - parentY);
                newWidth = Math.min(maxWidth, newWidth);
                newHeight = Math.min(maxHeight, newHeight);
                GuiHelper.applyScissor(newX, newY, newWidth, newHeight);
                if (scissorFrameStack.isEmpty()) {
                    GL11.glEnable((int)3089);
                }
                scissorFrameStack.push(new int[]{newX, newY, newWidth, newHeight});
                pushedFrame = true;
            }
        }
        if (!pushedFrame) {
            if (scissorFrameStack.isEmpty()) {
                GL11.glEnable((int)3089);
            }
            scissorFrameStack.push(new int[]{parentX, parentY, parentWidth, parentHeight});
        }
    }

    public static void popScissorFrame() {
        scissorFrameStack.pop();
        int[] parentScissor = GuiHelper.peekFirstScissorOrFullScreen();
        int parentX = parentScissor[0];
        int parentY = parentScissor[1];
        int parentWidth = parentScissor[2];
        int parentHeight = parentScissor[3];
        GuiHelper.applyScissor(parentX, parentY, parentWidth, parentHeight);
        if (scissorFrameStack.isEmpty()) {
            GL11.glDisable((int)3089);
        }
    }

    private static void applyScissor(int x, int y, int w, int h) {
        ScaledResolution r = ((GuiIngameForge)Minecraft.func_71410_x().field_71456_v).getResolution();
        int s = r == null ? 1 : r.func_78325_e();
        int translatedY = r == null ? 0 : r.func_78328_b() - y - h;
        GL11.glScissor((int)(x * s), (int)(translatedY * s), (int)(w * s), (int)(h * s));
    }

    public static void afterRenderItemAndEffectIntoGUI(ItemStack stack) {
        if (stack.func_77962_s()) {
            GL11.glDepthFunc((int)514);
            GL11.glDisable((int)2896);
            GL11.glDepthMask((boolean)false);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)3042);
            GL11.glColor4f((float)0.5f, (float)0.25f, (float)0.8f, (float)1.0f);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2896);
            GL11.glDepthFunc((int)515);
            GL11.glDisable((int)3042);
        }
    }
}

