/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.widget.ISyncedWidget;
import com.gtnewhorizons.modularui.api.widget.IWidgetParent;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class ChangeableWidget
extends Widget
implements ISyncedWidget,
IWidgetParent {
    private boolean needsUpdate;
    private final List<Widget> child = new ArrayList<Widget>();
    @Nullable
    private Widget queuedChild = null;
    private final Supplier<Widget> widgetSupplier;
    private boolean initialised = false;
    private boolean firstTick = true;

    public ChangeableWidget(Supplier<Widget> widgetSupplier) {
        this.widgetSupplier = widgetSupplier;
    }

    @Override
    @NotNull
    protected Size determineSize(int maxWidth, int maxHeight) {
        if (this.child.isEmpty()) {
            return Size.ZERO;
        }
        return this.child.get(0).getSize();
    }

    public void notifyChangeServer() {
        if (!this.isClient()) {
            this.notifyChange(true);
        }
    }

    private void notifyChange(boolean sync) {
        if (this.widgetSupplier == null || !this.isInitialised()) {
            return;
        }
        if (sync && !this.isClient()) {
            this.syncToClient(0, NetworkUtils.EMPTY_PACKET);
        }
        this.removeCurrentChild();
        this.queuedChild = this.widgetSupplier.get();
        this.initialised = false;
    }

    private void initQueuedChild() {
        if (this.queuedChild != null) {
            IWidgetParent.forEachByLayer(this.queuedChild, (Widget widget) -> {
                if (widget instanceof IWidgetParent) {
                    ((IWidgetParent)((Object)widget)).initChildren();
                }
            });
            AtomicInteger syncId = new AtomicInteger(1);
            IWidgetParent.forEachByLayer(this.queuedChild, (Widget widget1) -> {
                if (widget1 instanceof ISyncedWidget) {
                    this.getWindow().addDynamicSyncedWidget(syncId.getAndIncrement(), (ISyncedWidget)((Object)widget1), this);
                }
                return false;
            });
            this.queuedChild.initialize(this.getWindow(), this, this.getLayer() + 1);
            this.child.add(this.queuedChild);
            this.initialised = true;
            this.queuedChild = null;
            this.firstTick = true;
        }
        this.checkNeedsRebuild();
    }

    public void removeCurrentChild() {
        if (!this.child.isEmpty()) {
            Widget widget = this.child.get(0);
            widget.setEnabled(false);
            IWidgetParent.forEachByLayer(widget, Widget::onPause);
            IWidgetParent.forEachByLayer(widget, Widget::onDestroy);
            this.child.clear();
        }
    }

    @Override
    public void detectAndSendChanges(boolean init) {
        if (init) {
            this.notifyChangeServer();
        }
        if (this.initialised && !this.child.isEmpty()) {
            IWidgetParent.forEachByLayer(this.child.get(0), (Widget widget) -> {
                if (widget instanceof ISyncedWidget) {
                    ((ISyncedWidget)((Object)widget)).detectAndSendChanges(this.firstTick);
                }
            });
            this.firstTick = false;
        }
    }

    @Override
    public void readOnClient(int id, PacketBuffer packetBuffer) throws IOException {
        if (id == 0) {
            this.notifyChange(false);
            this.initQueuedChild();
            this.syncToServer(1, NetworkUtils.EMPTY_PACKET);
        }
    }

    @Override
    public void readOnServer(int id, PacketBuffer packetBuffer) throws IOException {
        if (id == 1) {
            this.initQueuedChild();
        }
    }

    @Override
    public void markForUpdate() {
        this.needsUpdate = true;
    }

    @Override
    public void unMarkForUpdate() {
        this.needsUpdate = false;
    }

    @Override
    public boolean isMarkedForUpdate() {
        return this.needsUpdate;
    }

    @Override
    public List<Widget> getChildren() {
        return this.child;
    }
}

