/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.widget.ISyncedWidget;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumChatFormatting;

public class DynamicTextWidget
extends TextWidget
implements ISyncedWidget {
    private final Supplier<Text> textSupplier;
    private boolean syncsToClient = true;
    private Text lastText;
    private Integer defaultColor;
    private EnumChatFormatting defaultFormat;
    private static final int MAX_PACKET_LENGTH = Short.MAX_VALUE;

    public DynamicTextWidget(Supplier<Text> text) {
        this.textSupplier = text;
        this.isDynamic = true;
    }

    @Override
    public void onInit() {
        this.lastText = new Text("");
    }

    @Override
    public Text getText() {
        return this.syncsToClient() ? this.lastText : this.updateText();
    }

    private Text updateText() {
        Text ret = this.textSupplier.get();
        if (this.defaultColor != null) {
            ret.color(this.defaultColor);
        }
        if (this.defaultFormat != null) {
            ret.format(this.defaultFormat);
        }
        return ret;
    }

    @Override
    public TextWidget setDefaultColor(int color) {
        this.defaultColor = color;
        return this;
    }

    @Override
    public TextWidget setDefaultColor(EnumChatFormatting color) {
        this.defaultFormat = color;
        return this;
    }

    public DynamicTextWidget setSynced(boolean synced) {
        this.syncsToClient = synced;
        return this;
    }

    protected boolean syncsToClient() {
        return this.syncsToClient;
    }

    @Override
    public void readOnClient(int id, PacketBuffer buf) throws IOException {
        if (id == 0) {
            Text newText = new Text(NetworkUtils.readStringSafe(buf));
            newText.color(buf.func_150792_a());
            newText.setFormatting(NetworkUtils.readStringSafe(buf));
            newText.shadow(buf.readBoolean());
            this.lastText = newText;
            this.checkNeedsRebuild();
        }
    }

    @Override
    public void readOnServer(int id, PacketBuffer buf) throws IOException {
    }

    @Override
    public void detectAndSendChanges(boolean init) {
        if (!this.syncsToClient()) {
            return;
        }
        Text newText = this.updateText();
        if (init || this.needsSync(newText)) {
            this.lastText = newText;
            this.syncToClient(0, buffer -> {
                NetworkUtils.writeStringSafe(buffer, newText.getRawText());
                buffer.func_150787_b(newText.getColor());
                NetworkUtils.writeStringSafe(buffer, newText.getFormatting());
                buffer.writeBoolean(newText.hasShadow());
            });
        }
    }

    @Override
    public void markForUpdate() {
    }

    @Override
    public void unMarkForUpdate() {
    }

    @Override
    public boolean isMarkedForUpdate() {
        return false;
    }

    private boolean needsSync(Text newText) {
        if (this.lastText == null && newText == null) {
            return false;
        }
        if (this.lastText == null) {
            return false;
        }
        return !this.lastText.getRawText().equals(newText.getRawText()) || this.lastText.getColor() != newText.getColor() || !this.lastText.getFormatting().equals(newText.getFormatting());
    }
}

