/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import com.gtnewhorizons.modularui.api.drawable.GuiHelper;
import com.gtnewhorizons.modularui.api.drawable.shapes.Rectangle;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.IWidgetParent;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.api.widget.scroll.IHorizontalScrollable;
import com.gtnewhorizons.modularui.api.widget.scroll.IVerticalScrollable;
import com.gtnewhorizons.modularui.api.widget.scroll.ScrollType;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import com.gtnewhorizons.modularui.common.widget.ScrollBar;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public class Scrollable
extends Widget
implements IWidgetBuilder<Scrollable>,
IWidgetParent,
Interactable,
IHorizontalScrollable,
IVerticalScrollable {
    private int xScroll = 0;
    private int yScroll = 0;
    private final List<Widget> children = new ArrayList<Widget>();
    private final List<Widget> allChildren = new ArrayList<Widget>();
    private Size actualSize = Size.ZERO;
    private int grabScrollX = -1;
    private int grabScrollY = -1;
    private @UnknownNullability ScrollBar horizontalScrollBar;
    private @UnknownNullability ScrollBar verticalScrollBar;

    @Override
    public void setHorizontalScrollOffset(int offset) {
        if (!this.canScrollHorizontal() || !this.horizontalScrollBar.isActive()) {
            offset = 0;
        }
        if (this.xScroll != offset) {
            int dif = this.xScroll - offset;
            this.xScroll = offset;
            for (Widget widget : this.children) {
                widget.setPosSilent(widget.getPos().add(dif, 0));
                widget.setEnabled(this.intersects(widget));
            }
        }
    }

    @Override
    public int getHorizontalScrollOffset() {
        return this.xScroll;
    }

    @Override
    public int getVisibleWidth() {
        return this.size.width;
    }

    @Override
    public int getActualWidth() {
        return this.actualSize.width;
    }

    @Override
    public void setVerticalScrollOffset(int offset) {
        if (!this.canScrollVertical() || !this.verticalScrollBar.isActive()) {
            offset = 0;
        }
        if (this.yScroll != offset) {
            int dif = this.yScroll - offset;
            this.yScroll = offset;
            for (Widget widget : this.children) {
                widget.setPosSilent(widget.getPos().add(0, dif));
                widget.setEnabled(this.intersects(widget));
            }
        }
    }

    @Override
    public int getVerticalScrollOffset() {
        return this.yScroll;
    }

    @Override
    public int getVisibleHeight() {
        return this.size.height;
    }

    @Override
    public int getActualHeight() {
        return this.actualSize.height;
    }

    public boolean canScrollVertical() {
        return this.verticalScrollBar != null;
    }

    public boolean canScrollHorizontal() {
        return this.horizontalScrollBar != null;
    }

    @Override
    public void initChildren() {
        if (this.canScrollHorizontal()) {
            this.allChildren.add(this.horizontalScrollBar);
        }
        if (this.canScrollVertical()) {
            this.allChildren.add(this.verticalScrollBar);
        }
    }

    @Override
    public void onRebuild() {
        this.actualSize = IWidgetParent.getSizeOf(this.children);
        if (this.xScroll < 0 || this.yScroll == 0) {
            this.setHorizontalScrollOffset(0);
            this.setVerticalScrollOffset(0);
            this.checkNeedsRebuild();
        }
    }

    @Override
    public void addWidgetInternal(Widget widget) {
        if (MultiChildWidget.checkChild(this, widget)) {
            this.children.add(widget);
            this.allChildren.add(widget);
        }
    }

    @Override
    public boolean childrenMustBeInBounds() {
        return true;
    }

    @Override
    public void drawChildren(float partialTicks) {
        GuiHelper.useScissor(this.pos.x, this.pos.y, this.size.width, this.size.height, () -> IWidgetParent.super.drawChildren(partialTicks));
    }

    @Override
    public Interactable.ClickResult onClick(int buttonId, boolean doubleClick) {
        this.grabScrollX = this.getContext().getMousePos().x;
        this.grabScrollY = this.getContext().getMousePos().y;
        return Interactable.ClickResult.ACCEPT;
    }

    @Override
    public boolean onClickReleased(int buttonId) {
        if (this.grabScrollX >= 0 || this.grabScrollY >= 0) {
            this.grabScrollX = -1;
            this.grabScrollY = -1;
            return true;
        }
        return false;
    }

    @Override
    public void onMouseDragged(int buttonId, long deltaTime) {
        if (this.grabScrollX >= 0 && this.grabScrollY >= 0) {
            int dif = this.getContext().getMousePos().x - this.grabScrollX;
            if (dif != 0 && this.canScrollHorizontal()) {
                this.horizontalScrollBar.setScrollOffset(this.xScroll - dif);
                this.grabScrollX = this.getContext().getMousePos().x;
            }
            if ((dif = this.getContext().getMousePos().y - this.grabScrollY) != 0 && this.canScrollVertical()) {
                this.verticalScrollBar.setScrollOffset(this.yScroll - dif);
                this.grabScrollY = this.getContext().getMousePos().y;
            }
        }
    }

    @Override
    public boolean onMouseScroll(int direction) {
        if (this.canScrollHorizontal() && this.canScrollVertical() && Interactable.hasShiftDown() || !this.canScrollVertical()) {
            this.horizontalScrollBar.onMouseScroll(direction);
            return true;
        }
        if (this.canScrollVertical()) {
            this.verticalScrollBar.onMouseScroll(direction);
            return true;
        }
        return false;
    }

    @Override
    public List<Widget> getChildren() {
        return this.allChildren;
    }

    public Scrollable setHorizontalScroll(@Nullable ScrollBar scrollBar) {
        this.horizontalScrollBar = scrollBar;
        if (this.horizontalScrollBar != null) {
            this.horizontalScrollBar.setScrollType(ScrollType.HORIZONTAL, this, null);
        }
        return this;
    }

    public Scrollable setHorizontalScroll() {
        return this.setHorizontalScroll(new ScrollBar().setBarTexture(new Rectangle().setColor(Color.WHITE.normal).setCornerRadius(1)));
    }

    public Scrollable setVerticalScroll(@Nullable ScrollBar scrollBar) {
        this.verticalScrollBar = scrollBar;
        if (this.verticalScrollBar != null) {
            this.verticalScrollBar.setScrollType(ScrollType.VERTICAL, null, this);
        }
        return this;
    }

    public Scrollable setVerticalScroll() {
        return this.setVerticalScroll(new ScrollBar().setBarTexture(new Rectangle().setColor(Color.WHITE.normal).setCornerRadius(1)));
    }
}

