/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import codechicken.nei.recipe.StackInfo;
import com.gtnewhorizons.modularui.ModularUI;
import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.NumberFormat;
import com.gtnewhorizons.modularui.api.drawable.GuiHelper;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.drawable.TextRenderer;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.widget.IDragAndDropHandler;
import com.gtnewhorizons.modularui.api.widget.IHasStackUnderMouse;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.Theme;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import com.gtnewhorizons.modularui.common.internal.wrapper.ModularGui;
import com.gtnewhorizons.modularui.common.widget.SyncedWidget;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.GT_FluidDisplayItem;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class FluidSlotWidget
extends SyncedWidget
implements Interactable,
IDragAndDropHandler,
IHasStackUnderMouse {
    public static final Size SIZE = new Size(18, 18);
    @Nullable
    private IDrawable overlayTexture;
    private final TextRenderer textRenderer = new TextRenderer();
    private final IFluidTank fluidTank;
    @Nullable
    private FluidStack lastStoredFluid;
    private FluidStack lastStoredPhantomFluid;
    private Pos2d contentOffset = new Pos2d(1, 1);
    private boolean alwaysShowFull = true;
    private boolean canDrainSlot = true;
    private boolean canFillSlot = true;
    private boolean phantom = false;
    private boolean controlsAmount = false;
    private boolean lastShift = false;
    private boolean playClickSound = true;
    private Consumer<Widget> onDragAndDropComplete;

    public FluidSlotWidget(IFluidTank fluidTank) {
        this.fluidTank = fluidTank;
        this.textRenderer.setColor(Color.WHITE.normal);
        this.textRenderer.setShadow(true);
    }

    public static FluidSlotWidget phantom(IFluidTank fluidTank, boolean controlsAmount) {
        FluidSlotWidget slot = new FluidSlotWidget(fluidTank);
        slot.phantom = true;
        slot.controlsAmount = controlsAmount;
        return slot;
    }

    public static FluidSlotWidget phantom(int capacity) {
        return FluidSlotWidget.phantom((IFluidTank)new FluidTank(capacity > 0 ? capacity : 1), capacity > 1);
    }

    public FluidStack getContent() {
        return this.fluidTank.getFluid();
    }

    @Override
    public void onInit() {
        if (this.isClient()) {
            this.textRenderer.setShadow(true);
            this.textRenderer.setScale(0.5f);
        }
        if (this.getBackground() == null) {
            this.setBackground(ModularUITextures.FLUID_SLOT);
        }
    }

    @Override
    @NotNull
    protected Size determineSize(int maxWidth, int maxHeight) {
        return SIZE;
    }

    public void setControlsAmount(boolean controlsAmount, boolean sync) {
        if (this.controlsAmount != controlsAmount) {
            this.controlsAmount = controlsAmount;
            if (sync) {
                if (this.isClient()) {
                    this.syncToServer(3, buffer -> buffer.writeBoolean(controlsAmount));
                } else {
                    this.syncToClient(3, buffer -> buffer.writeBoolean(controlsAmount));
                }
            }
        }
    }

    @Override
    public void buildTooltip(List<Text> tooltip) {
        super.buildTooltip(tooltip);
        FluidStack fluid = this.fluidTank.getFluid();
        if (this.phantom) {
            if (fluid != null) {
                this.addFluidNameInfo(tooltip, fluid);
                if (this.controlsAmount) {
                    tooltip.add(Text.localised("modularui.fluid.phantom.amount", fluid.amount));
                    this.addAdditionalFluidInfo(tooltip, fluid);
                    tooltip.add(Text.localised("modularui.fluid.phantom.control", new Object[0]));
                } else {
                    this.addAdditionalFluidInfo(tooltip, fluid);
                    tooltip.add(Text.localised("modularui.phantom.single.clear", new Object[0]));
                }
                if (!Interactable.hasShiftDown()) {
                    tooltip.add(Text.EMPTY);
                    tooltip.add(Text.localised("modularui.tooltip.shift", new Object[0]));
                }
            } else {
                tooltip.add(Text.localised("modularui.fluid.empty", new Object[0]).format(EnumChatFormatting.WHITE));
            }
        } else {
            if (fluid != null) {
                this.addFluidNameInfo(tooltip, fluid);
                tooltip.add(Text.localised("modularui.fluid.amount", fluid.amount, this.fluidTank.getCapacity()));
                this.addAdditionalFluidInfo(tooltip, fluid);
            } else {
                tooltip.add(Text.localised("modularui.fluid.empty", new Object[0]).format(EnumChatFormatting.WHITE));
                tooltip.add(Text.localised("modularui.fluid.capacity", this.fluidTank.getCapacity()));
            }
            if (this.canFillSlot || this.canDrainSlot) {
                tooltip.add(Text.EMPTY);
                if (Interactable.hasShiftDown()) {
                    if (this.canFillSlot && this.canDrainSlot) {
                        tooltip.add(Text.localised("modularui.fluid.click_combined", new Object[0]));
                    } else if (this.canDrainSlot) {
                        tooltip.add(Text.localised("modularui.fluid.click_to_fill", new Object[0]));
                    } else if (this.canFillSlot) {
                        tooltip.add(Text.localised("modularui.fluid.click_to_empty", new Object[0]));
                    }
                } else {
                    tooltip.add(Text.localised("modularui.tooltip.shift", new Object[0]));
                }
            }
        }
    }

    protected void addFluidNameInfo(List<Text> tooltip, @NotNull FluidStack fluid) {
        String formula;
        tooltip.add(new Text(fluid.getLocalizedName()).format(EnumChatFormatting.WHITE));
        if (ModularUI.isGT5ULoaded && !(formula = GT_FluidDisplayItem.getChemicalFormula((FluidStack)fluid)).isEmpty()) {
            tooltip.add(new Text(formula).format(EnumChatFormatting.YELLOW));
        }
        if (Minecraft.func_71410_x().field_71474_y.field_82882_x) {
            tooltip.add(Text.localised("modularui.fluid.registry", fluid.getFluid().getName()));
        }
    }

    public void addAdditionalFluidInfo(List<Text> tooltipContainer, @NotNull FluidStack fluid) {
        if (Interactable.hasShiftDown()) {
            tooltipContainer.add(Text.localised("modularui.fluid.temperature", fluid.getFluid().getTemperature(fluid)));
            tooltipContainer.add(Text.localised("modularui.fluid.state", fluid.getFluid().isGaseous(fluid) ? StatCollector.func_74838_a((String)"modularui.fluid.gas") : StatCollector.func_74838_a((String)"modularui.fluid.liquid")));
        }
    }

    @Override
    @Nullable
    public String getBackgroundColorKey() {
        return "fluidslot";
    }

    @Override
    public void draw(float partialTicks) {
        FluidStack content = this.fluidTank.getFluid();
        if (content != null) {
            float y = this.contentOffset.y;
            float height = this.size.height - this.contentOffset.y * 2;
            if (!this.alwaysShowFull) {
                float newHeight = height * (float)content.amount * 1.0f / (float)this.fluidTank.getCapacity();
                y += height - newHeight;
                height = newHeight;
            }
            GuiHelper.drawFluidTexture(content, this.contentOffset.x, y, this.size.width - this.contentOffset.x * 2, height, 0.0f);
        }
        if (this.overlayTexture != null) {
            this.overlayTexture.draw(Pos2d.ZERO, this.size, partialTicks);
        }
        if (content != null && (!this.phantom || this.controlsAmount)) {
            String s = NumberFormat.format(content.amount) + "L";
            this.textRenderer.setAlignment(Alignment.CenterLeft, (float)(this.size.width - this.contentOffset.x) - 1.0f);
            this.textRenderer.setPos((int)((float)this.contentOffset.x + 0.5f), (int)((float)this.size.height - 4.5f));
            this.textRenderer.draw(s);
        }
        if (this.isHovering() && !this.getContext().getCursor().hasDraggable()) {
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GlStateManager.colorMask(true, true, true, false);
            ModularGui.drawSolidRect(1.0f, 1.0f, 16.0f, 16.0f, Theme.INSTANCE.getSlotHighlight());
            GlStateManager.colorMask(true, true, true, true);
            GL11.glDisable((int)3042);
        }
    }

    @Override
    public void onScreenUpdate() {
        if (this.lastShift != Interactable.hasShiftDown()) {
            this.lastShift = Interactable.hasShiftDown();
            this.notifyTooltipChange();
        }
    }

    @Override
    public Interactable.ClickResult onClick(int buttonId, boolean doubleClick) {
        if (!this.canFillSlot && !this.canDrainSlot) {
            return Interactable.ClickResult.ACKNOWLEDGED;
        }
        ItemStack cursorStack = this.getContext().getCursor().getItemStack();
        if (this.phantom || cursorStack != null) {
            Widget.ClickData clickData = Widget.ClickData.create(buttonId, doubleClick);
            ItemStack verifyToken = this.tryClickContainer(clickData);
            this.syncToServer(1, buffer -> {
                clickData.writeToPacket((PacketBuffer)buffer);
                try {
                    buffer.func_150788_a(verifyToken);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            if (this.playClickSound) {
                Interactable.playButtonClickSound();
            }
            return Interactable.ClickResult.ACCEPT;
        }
        return Interactable.ClickResult.ACKNOWLEDGED;
    }

    @Override
    public boolean onMouseScroll(int direction) {
        if (this.phantom) {
            if (direction > 0 && !this.canFillSlot || direction < 0 && !this.canDrainSlot) {
                return false;
            }
            if (Interactable.hasShiftDown()) {
                direction *= 10;
            }
            if (Interactable.hasControlDown()) {
                direction *= 100;
            }
            int finalDirection = direction;
            this.syncToServer(2, buffer -> buffer.func_150787_b(finalDirection));
            return true;
        }
        return false;
    }

    @Override
    public void detectAndSendChanges(boolean init) {
        FluidStack currentFluid = this.fluidTank.getFluid();
        if (init || FluidSlotWidget.fluidChanged(currentFluid, this.lastStoredFluid)) {
            this.lastStoredFluid = currentFluid == null ? null : currentFluid.copy();
            this.syncToClient(1, buffer -> NetworkUtils.writeFluidStack(buffer, currentFluid));
            this.markForUpdate();
        }
    }

    public static boolean fluidChanged(@Nullable FluidStack current, @Nullable FluidStack cached) {
        return current == null ^ cached == null || current != null && (current.amount != cached.amount || !current.isFluidEqual(cached));
    }

    @Override
    public void readOnClient(int id, PacketBuffer buf) throws IOException {
        if (id == 1) {
            FluidStack fluidStack = NetworkUtils.readFluidStack(buf);
            this.fluidTank.drain(Integer.MAX_VALUE, true);
            this.fluidTank.fill(fluidStack, true);
            this.notifyTooltipChange();
        } else if (id == 3) {
            this.controlsAmount = buf.readBoolean();
        }
    }

    @Override
    public void readOnServer(int id, PacketBuffer buf) throws IOException {
        if (id == 1) {
            this.onClickServer(Widget.ClickData.readPacket(buf), buf.func_150791_c());
        } else if (id == 2) {
            if (this.phantom) {
                this.tryScrollPhantom(buf.func_150792_a());
            }
        } else if (id == 3) {
            this.controlsAmount = buf.readBoolean();
        } else if (id == 4) {
            this.tryClickPhantom(Widget.ClickData.readPacket(buf), buf.func_150791_c());
            if (this.onDragAndDropComplete != null) {
                this.onDragAndDropComplete.accept(this);
            }
        }
        this.markForUpdate();
    }

    protected void onClickServer(Widget.ClickData clickData, ItemStack clientVerifyToken) {
        ItemStack serverVerifyToken = this.tryClickContainer(clickData);
        if (!ItemStack.func_77989_b((ItemStack)clientVerifyToken, (ItemStack)serverVerifyToken)) {
            ((EntityPlayerMP)this.getContext().getPlayer()).func_71120_a((Container)this.getContext().getContainer());
        }
    }

    protected ItemStack tryClickContainer(Widget.ClickData clickData) {
        if (this.phantom) {
            this.tryClickPhantom(clickData);
            return null;
        }
        return this.transferFluid(clickData);
    }

    protected ItemStack transferFluid(Widget.ClickData clickData) {
        EntityPlayer player = this.getContext().getPlayer();
        boolean processFullStack = clickData.mouseButton == 0;
        ItemStack heldItem = player.field_71071_by.func_70445_o();
        if (heldItem == null || heldItem.field_77994_a == 0) {
            return null;
        }
        ItemStack heldItemSizedOne = heldItem.func_77946_l();
        heldItemSizedOne.field_77994_a = 1;
        FluidStack currentFluid = this.fluidTank.getFluid();
        FluidStack heldFluid = this.getFluidForRealItem(heldItemSizedOne);
        if (heldFluid != null && heldFluid.amount <= 0) {
            heldFluid = null;
        }
        if (currentFluid == null) {
            if (!this.canFillSlot) {
                return null;
            }
            if (heldFluid == null) {
                return null;
            }
            return this.fillFluid(heldFluid, processFullStack);
        }
        if (heldFluid != null && currentFluid.amount < this.fluidTank.getCapacity()) {
            if (this.canFillSlot) {
                return this.fillFluid(heldFluid, processFullStack);
            }
            if (!this.canDrainSlot) {
                return null;
            }
            return this.drainFluid(processFullStack);
        }
        if (!this.canDrainSlot) {
            return null;
        }
        return this.drainFluid(processFullStack);
    }

    protected ItemStack drainFluid(boolean processFullStack) {
        EntityPlayer player = this.getContext().getPlayer();
        ItemStack heldItem = player.field_71071_by.func_70445_o();
        if (heldItem == null || heldItem.field_77994_a == 0) {
            return null;
        }
        ItemStack heldItemSizedOne = heldItem.func_77946_l();
        heldItemSizedOne.field_77994_a = 1;
        FluidStack currentFluid = this.fluidTank.getFluid();
        if (currentFluid == null) {
            return null;
        }
        int originalFluidAmount = currentFluid.amount;
        ItemStack filledContainer = this.fillFluidContainer(currentFluid, heldItemSizedOne);
        if (filledContainer != null) {
            int filledAmount = originalFluidAmount - currentFluid.amount;
            this.fluidTank.drain(filledAmount, true);
            if (processFullStack) {
                int additionalParallel = Math.min(heldItem.field_77994_a - 1, currentFluid.amount / filledAmount);
                this.fluidTank.drain(filledAmount * additionalParallel, true);
                filledContainer.field_77994_a += additionalParallel;
            }
            this.replaceCursorItemStack(filledContainer);
            this.playSound(currentFluid, false);
        }
        return filledContainer;
    }

    protected ItemStack fillFluid(FluidStack heldFluid, boolean processFullStack) {
        IFluidContainerItem container;
        FluidStack tDrained;
        EntityPlayer player = this.getContext().getPlayer();
        ItemStack heldItem = player.field_71071_by.func_70445_o();
        if (heldItem == null || heldItem.field_77994_a == 0) {
            return null;
        }
        ItemStack heldItemSizedOne = heldItem.func_77946_l();
        heldItemSizedOne.field_77994_a = 1;
        FluidStack currentFluid = this.fluidTank.getFluid();
        if (currentFluid != null && !currentFluid.isFluidEqual(heldFluid)) {
            return null;
        }
        int freeSpace = this.fluidTank.getCapacity() - (currentFluid != null ? currentFluid.amount : 0);
        if (freeSpace <= 0) {
            return null;
        }
        ItemStack itemStackEmptied = null;
        int fluidAmountTaken = 0;
        if (freeSpace >= heldFluid.amount) {
            itemStackEmptied = this.getContainerForFilledItemWithoutIFluidContainerItem(heldItemSizedOne);
            fluidAmountTaken = heldFluid.amount;
        }
        if (itemStackEmptied == null && heldItemSizedOne.func_77973_b() instanceof IFluidContainerItem && (tDrained = (container = (IFluidContainerItem)heldItemSizedOne.func_77973_b()).drain(heldItemSizedOne, freeSpace, true)) != null && tDrained.amount > 0) {
            itemStackEmptied = heldItemSizedOne;
            fluidAmountTaken = tDrained.amount;
        }
        if (itemStackEmptied == null) {
            return null;
        }
        int parallel = processFullStack ? Math.min(freeSpace / fluidAmountTaken, heldItem.field_77994_a) : 1;
        FluidStack copiedFluidStack = heldFluid.copy();
        copiedFluidStack.amount = fluidAmountTaken * parallel;
        this.fluidTank.fill(copiedFluidStack, true);
        itemStackEmptied.field_77994_a = parallel;
        this.replaceCursorItemStack(itemStackEmptied);
        this.playSound(heldFluid, true);
        return itemStackEmptied;
    }

    protected void replaceCursorItemStack(ItemStack resultStack) {
        EntityPlayer player = this.getContext().getPlayer();
        int resultStackMaxStackSize = resultStack.func_77976_d();
        while (resultStack.field_77994_a > resultStackMaxStackSize) {
            player.field_71071_by.func_70445_o().field_77994_a -= resultStackMaxStackSize;
            FluidSlotWidget.addItemToPlayerInventory(player, resultStack.func_77979_a(resultStackMaxStackSize));
        }
        if (player.field_71071_by.func_70445_o().field_77994_a == resultStack.field_77994_a) {
            player.field_71071_by.func_70437_b(resultStack);
        } else {
            ItemStack tStackHeld = player.field_71071_by.func_70445_o();
            tStackHeld.field_77994_a -= resultStack.field_77994_a;
            FluidSlotWidget.addItemToPlayerInventory(player, resultStack);
        }
    }

    protected void tryClickPhantom(Widget.ClickData clickData) {
        this.tryClickPhantom(clickData, this.getContext().getCursor().getItemStack());
    }

    protected void tryClickPhantom(Widget.ClickData clickData, ItemStack cursorStack) {
        FluidStack currentFluid = this.fluidTank.getFluid();
        if (clickData.mouseButton == 0) {
            if (cursorStack == null) {
                if (this.canDrainSlot) {
                    this.fluidTank.drain(clickData.shift ? Integer.MAX_VALUE : 1000, true);
                }
            } else {
                ItemStack heldItemSizedOne = cursorStack.func_77946_l();
                heldItemSizedOne.field_77994_a = 1;
                FluidStack heldFluid = this.getFluidForPhantomItem(heldItemSizedOne);
                if ((this.controlsAmount || currentFluid == null) && heldFluid != null) {
                    if (this.canFillSlot) {
                        if (!this.controlsAmount) {
                            heldFluid.amount = 1;
                        }
                        if (this.fluidTank.fill(heldFluid, true) > 0) {
                            this.lastStoredPhantomFluid = heldFluid.copy();
                        }
                    }
                } else if (this.canDrainSlot) {
                    this.fluidTank.drain(clickData.shift ? Integer.MAX_VALUE : 1000, true);
                }
            }
        } else if (clickData.mouseButton == 1) {
            if (this.canFillSlot) {
                if (currentFluid != null) {
                    if (this.controlsAmount) {
                        FluidStack toFill = currentFluid.copy();
                        toFill.amount = 1000;
                        this.fluidTank.fill(toFill, true);
                    }
                } else if (this.lastStoredPhantomFluid != null) {
                    FluidStack toFill = this.lastStoredPhantomFluid.copy();
                    toFill.amount = this.controlsAmount ? 1000 : 1;
                    this.fluidTank.fill(toFill, true);
                }
            }
        } else if (clickData.mouseButton == 2 && currentFluid != null && this.canDrainSlot) {
            this.fluidTank.drain(clickData.shift ? Integer.MAX_VALUE : 1000, true);
        }
    }

    protected void tryScrollPhantom(int direction) {
        FluidStack currentFluid = this.fluidTank.getFluid();
        if (currentFluid == null) {
            if (direction > 0 && this.lastStoredPhantomFluid != null) {
                FluidStack toFill = this.lastStoredPhantomFluid.copy();
                toFill.amount = this.controlsAmount ? direction : 1;
                this.fluidTank.fill(toFill, true);
            }
            return;
        }
        if (direction > 0 && this.controlsAmount) {
            FluidStack toFill = currentFluid.copy();
            toFill.amount = direction;
            this.fluidTank.fill(toFill, true);
        } else if (direction < 0) {
            this.fluidTank.drain(-direction, true);
        }
    }

    protected void playSound(FluidStack fluid, boolean fill) {
    }

    @Override
    public boolean handleDragAndDrop(ItemStack draggedStack, int button) {
        if (!this.isPhantom()) {
            return false;
        }
        Widget.ClickData clickData = Widget.ClickData.create(button, false);
        this.tryClickPhantom(clickData, draggedStack);
        this.syncToServer(4, buffer -> {
            try {
                clickData.writeToPacket((PacketBuffer)buffer);
                buffer.func_150788_a(draggedStack);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        draggedStack.field_77994_a = 0;
        return true;
    }

    protected FluidStack getFluidForRealItem(ItemStack itemStack) {
        if (ModularUI.isGT5ULoaded) {
            return GT_Utility.getFluidForFilledItem((ItemStack)itemStack, (boolean)true);
        }
        FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack);
        if (fluidStack == null && itemStack.func_77973_b() instanceof IFluidContainerItem) {
            fluidStack = ((IFluidContainerItem)itemStack.func_77973_b()).getFluid(itemStack);
        }
        return fluidStack;
    }

    protected FluidStack getFluidForPhantomItem(ItemStack itemStack) {
        if (ModularUI.isGT5ULoaded) {
            return GT_Utility.getFluidFromContainerOrFluidDisplay((ItemStack)itemStack);
        }
        return StackInfo.getFluid((ItemStack)itemStack);
    }

    protected ItemStack fillFluidContainer(FluidStack fluidStack, ItemStack itemStack) {
        ItemStack filledContainer = this.fillFluidContainerWithoutIFluidContainerItem(fluidStack, itemStack);
        if (filledContainer == null) {
            filledContainer = this.fillFluidContainerWithIFluidContainerItem(fluidStack, itemStack);
        }
        return filledContainer;
    }

    protected ItemStack fillFluidContainerWithoutIFluidContainerItem(FluidStack fluidStack, ItemStack itemStack) {
        if (ModularUI.isGT5ULoaded) {
            return GT_Utility.fillFluidContainer((FluidStack)fluidStack, (ItemStack)itemStack, (boolean)true, (boolean)false);
        }
        return null;
    }

    protected ItemStack fillFluidContainerWithIFluidContainerItem(FluidStack fluidStack, ItemStack itemStack) {
        IFluidContainerItem tContainerItem;
        int tFilledAmount;
        if (itemStack.func_77973_b() instanceof IFluidContainerItem && (tFilledAmount = (tContainerItem = (IFluidContainerItem)itemStack.func_77973_b()).fill(itemStack, fluidStack, true)) > 0) {
            fluidStack.amount -= tFilledAmount;
            return itemStack;
        }
        return null;
    }

    protected ItemStack getContainerForFilledItemWithoutIFluidContainerItem(ItemStack itemStack) {
        if (ModularUI.isGT5ULoaded) {
            return GT_Utility.getContainerForFilledItem((ItemStack)itemStack, (boolean)false);
        }
        return null;
    }

    protected static void addItemToPlayerInventory(EntityPlayer player, ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (!player.field_71071_by.func_70441_a(stack) && !player.field_70170_p.field_72995_K) {
            EntityItem dropItem = player.func_70099_a(stack, 0.0f);
            dropItem.field_145804_b = 0;
        }
    }

    public boolean canFillSlot() {
        return this.canFillSlot;
    }

    public boolean canDrainSlot() {
        return this.canDrainSlot;
    }

    public boolean alwaysShowFull() {
        return this.alwaysShowFull;
    }

    public Pos2d getContentOffset() {
        return this.contentOffset;
    }

    public boolean controlsAmount() {
        return this.controlsAmount;
    }

    public boolean isPhantom() {
        return this.phantom;
    }

    @Nullable
    public IDrawable getOverlayTexture() {
        return this.overlayTexture;
    }

    @Override
    public ItemStack getStackUnderMouse() {
        if (ModularUI.isGT5ULoaded) {
            return GT_Utility.getFluidDisplayStack((FluidStack)this.fluidTank.getFluid(), (boolean)false);
        }
        return null;
    }

    public FluidSlotWidget setInteraction(boolean canDrainSlot, boolean canFillSlot) {
        this.canDrainSlot = canDrainSlot;
        this.canFillSlot = canFillSlot;
        return this;
    }

    public FluidSlotWidget setAlwaysShowFull(boolean alwaysShowFull) {
        this.alwaysShowFull = alwaysShowFull;
        return this;
    }

    public FluidSlotWidget setContentOffset(Pos2d contentOffset) {
        this.contentOffset = contentOffset;
        return this;
    }

    public FluidSlotWidget setOverlayTexture(@Nullable IDrawable overlayTexture) {
        this.overlayTexture = overlayTexture;
        return this;
    }

    public FluidSlotWidget setPlayClickSound(boolean playClickSound) {
        this.playClickSound = playClickSound;
        return this;
    }

    public FluidSlotWidget setOnDragAndDropComplete(Consumer<Widget> onDragAndDropComplete) {
        this.onDragAndDropComplete = onDragAndDropComplete;
        return this;
    }
}

