/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import com.gtnewhorizons.modularui.ModularUI;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.widget.IWidgetParent;
import com.gtnewhorizons.modularui.api.widget.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PageControlWidget
extends Widget
implements IWidgetParent {
    private int currentPage = 0;
    private final List<Widget> pages = new ArrayList<Widget>();

    @Override
    public void onInit() {
        if (this.pages.isEmpty()) {
            throw new IllegalStateException("PageControlWidget must have at least one child!");
        }
        for (int i = 0; i < this.pages.size(); ++i) {
            if (i == this.currentPage) continue;
            this.setPage(i, false);
        }
    }

    @Override
    @NotNull
    protected Size determineSize(int maxWidth, int maxHeight) {
        return this.pages.isEmpty() ? super.determineSize(maxWidth, maxHeight) : IWidgetParent.getSizeOf(this.pages);
    }

    protected List<Widget> getPages() {
        return this.pages;
    }

    @Override
    public List<Widget> getChildren() {
        return Collections.unmodifiableList(this.pages);
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void nextPage() {
        if (this.currentPage + 1 >= this.pages.size()) {
            this.setActivePage(0);
        } else {
            this.setActivePage(this.currentPage + 1);
        }
    }

    public void prevPage() {
        if (this.currentPage == 0) {
            this.setActivePage(this.pages.size() - 1);
        } else {
            this.setActivePage(this.currentPage - 1);
        }
    }

    public void setActivePage(int page) {
        if (page > this.pages.size() - 1 || page < 0) {
            throw new IndexOutOfBoundsException("Tried setting active page to " + page + " while only 0 - " + (this.pages.size() - 1) + " is allowed");
        }
        if (!this.isInitialised()) {
            this.currentPage = page;
            return;
        }
        this.setPage(this.currentPage, false);
        this.currentPage = page;
        this.setPage(this.currentPage, true);
    }

    private void setPage(int page, boolean active) {
        Widget widget = this.pages.get(page);
        widget.setEnabled(active);
        this.setEnabledAllChildren(active, widget);
        if (active) {
            for (Widget pageWidget : this.pages) {
                if (pageWidget == widget) continue;
                pageWidget.setEnabled(false);
                this.setEnabledAllChildren(false, pageWidget);
            }
        }
    }

    private void setEnabledAllChildren(boolean active, Widget parent) {
        if (parent instanceof IWidgetParent) {
            IWidgetParent.forEachByLayer(parent, (Widget forEach) -> {
                forEach.setEnabled(active);
                return false;
            });
        }
    }

    public PageControlWidget addPage(Widget page) {
        if (page == this) {
            ModularUI.logger.error("Can't add self!");
            return this;
        }
        if (this.isInitialised()) {
            ModularUI.logger.error("Can't add child after initialised!");
        } else {
            this.pages.add(page);
        }
        return this;
    }
}

