/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.drawable;

import com.gtnewhorizons.modularui.api.drawable.UITexture;
import net.minecraft.util.ResourceLocation;

public class AdaptableUITexture
extends UITexture {
    private final int imageWidth;
    private final int imageHeight;
    private final int borderWidthU;
    private final int borderWidthV;

    public AdaptableUITexture(ResourceLocation location, float u0, float v0, float u1, float v1, int imageWidth, int imageHeight, int borderWidthU, int borderWidthV) {
        super(location, u0, v0, u1, v1);
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.borderWidthU = borderWidthU;
        this.borderWidthV = borderWidthV;
    }

    public AdaptableUITexture(ResourceLocation location, int imageWidth, int imageHeight, int borderWidthU, int borderWidthV) {
        this(location, 0.0f, 0.0f, 1.0f, 1.0f, imageWidth, imageHeight, borderWidthU, borderWidthV);
    }

    public static AdaptableUITexture of(ResourceLocation location, int imageWidth, int imageHeight, int borderWidthU, int borderWidthV) {
        return new AdaptableUITexture(location, imageWidth, imageHeight, borderWidthU, borderWidthV);
    }

    public static AdaptableUITexture of(ResourceLocation location, int imageWidth, int imageHeight, int borderWidthPixel) {
        return new AdaptableUITexture(location, imageWidth, imageHeight, borderWidthPixel, borderWidthPixel);
    }

    public static AdaptableUITexture of(String location, int imageWidth, int imageHeight, int borderWidthPixel) {
        return new AdaptableUITexture(new ResourceLocation(location), imageWidth, imageHeight, borderWidthPixel, borderWidthPixel);
    }

    public static AdaptableUITexture of(String mod, String location, int imageWidth, int imageHeight, int borderWidthPixel) {
        return new AdaptableUITexture(new ResourceLocation(mod, location), imageWidth, imageHeight, borderWidthPixel, borderWidthPixel);
    }

    @Override
    public AdaptableUITexture getSubArea(float uStart, float vStart, float uEnd, float vEnd) {
        return new AdaptableUITexture(this.location, this.calcU(uStart), this.calcV(vStart), this.calcU(uEnd), this.calcV(vEnd), this.imageWidth, this.imageHeight, this.borderWidthU, this.borderWidthV);
    }

    @Override
    public AdaptableUITexture exposeToJson() {
        return (AdaptableUITexture)super.exposeToJson();
    }

    @Override
    public void draw(float x, float y, float width, float height) {
        if (width == (float)this.imageWidth && height == (float)this.imageHeight) {
            super.draw(x, y, width, height);
            return;
        }
        float borderU = (float)this.borderWidthU * 1.0f / (float)this.imageWidth;
        float borderV = (float)this.borderWidthV * 1.0f / (float)this.imageHeight;
        AdaptableUITexture.draw(this.location, x, y, this.borderWidthU, this.borderWidthV, this.u0, this.v0, this.u0 + borderU, this.v0 + borderV);
        AdaptableUITexture.draw(this.location, x + width - (float)this.borderWidthU, y, this.borderWidthU, this.borderWidthV, this.u1 - borderU, this.v0, this.u1, this.v0 + borderV);
        AdaptableUITexture.draw(this.location, x, y + height - (float)this.borderWidthV, this.borderWidthU, this.borderWidthV, this.u0, this.v1 - borderV, this.u0 + borderU, this.v1);
        AdaptableUITexture.draw(this.location, x + width - (float)this.borderWidthU, y + height - (float)this.borderWidthV, this.borderWidthU, this.borderWidthV, this.u1 - borderU, this.v1 - borderV, this.u1, this.v1);
        AdaptableUITexture.draw(this.location, x + (float)this.borderWidthU, y, width - (float)(this.borderWidthU * 2), this.borderWidthV, this.u0 + borderU, this.v0, this.u1 - borderU, this.v0 + borderV);
        AdaptableUITexture.draw(this.location, x + (float)this.borderWidthU, y + height - (float)this.borderWidthV, width - (float)(this.borderWidthU * 2), this.borderWidthV, this.u0 + borderU, this.v1 - borderV, this.u1 - borderU, this.v1);
        AdaptableUITexture.draw(this.location, x, y + (float)this.borderWidthV, this.borderWidthU, height - (float)(this.borderWidthV * 2), this.u0, this.v0 + borderV, this.u0 + borderU, this.v1 - borderV);
        AdaptableUITexture.draw(this.location, x + width - (float)this.borderWidthU, y + (float)this.borderWidthV, this.borderWidthU, height - (float)(this.borderWidthV * 2), this.u1 - borderU, this.v0 + borderV, this.u1, this.v1 - borderV);
        AdaptableUITexture.draw(this.location, x + (float)this.borderWidthU, y + (float)this.borderWidthV, width - (float)(this.borderWidthU * 2), height - (float)(this.borderWidthV * 2), this.u0 + borderU, this.v0 + borderV, this.u1 - borderU, this.v1 - borderV);
    }
}

