/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import mods.natura.common.NContent;
import mods.natura.common.PHNatura;
import mods.natura.worldgen.BerryBushGen;
import mods.natura.worldgen.FlowerGen;
import mods.natura.worldgen.NetherBerryBushGen;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class BaseCropWorldgen
implements IWorldGenerator {
    BerryBushGen raspgen;
    BerryBushGen bluegen;
    BerryBushGen blackgen;
    BerryBushGen malogen;
    NetherBerryBushGen blightgen;
    NetherBerryBushGen duskgen;
    NetherBerryBushGen skygen;
    NetherBerryBushGen stinggen;
    FlowerGen bluebells;
    FlowerGen lily;
    FlowerGen tulip;
    FlowerGen pansy;

    public BaseCropWorldgen() {
        if (PHNatura.enableBerryBushes) {
            this.raspgen = new BerryBushGen(0, PHNatura.seaLevel + PHNatura.raspSpawnRange);
            this.bluegen = new BerryBushGen(1, PHNatura.seaLevel + PHNatura.blueSpawnRange);
            this.blackgen = new BerryBushGen(2, PHNatura.seaLevel + PHNatura.blackSpawnRange);
            this.malogen = new BerryBushGen(3, PHNatura.seaLevel + PHNatura.geoSpawnRange);
        }
        if (PHNatura.enableBerryBushes) {
            this.blightgen = new NetherBerryBushGen((Block)NContent.netherBerryBush, 0);
            this.duskgen = new NetherBerryBushGen((Block)NContent.netherBerryBush, 1);
            this.skygen = new NetherBerryBushGen((Block)NContent.netherBerryBush, 2);
            this.stinggen = new NetherBerryBushGen((Block)NContent.netherBerryBush, 3);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int xChunk = chunkX * 16 + 8;
        int zChunk = chunkZ * 16 + 8;
        int xCh = chunkX * 16 + random.nextInt(16);
        int yCh = random.nextInt(128);
        int zCh = chunkZ * 16 + random.nextInt(16);
        BiomeGenBase biome = world.func_72959_q().func_76935_a(chunkX * 16, chunkZ * 16);
        if (PHNatura.generateBarley && random.nextInt(5) == 0 && this.goodClimate(biome, 0.11f, 1.0f, 0.11f, 2.0f)) {
            this.generateBarley(world, random, xCh, yCh + PHNatura.seaLevel, zCh);
            this.generateBarley(world, random, xCh, yCh + PHNatura.seaLevel, zCh);
        }
        if (PHNatura.generateCotton && random.nextInt(12) == 0 && this.goodClimate(biome, 0.11f, 1.0f, 0.11f, 2.0f)) {
            this.generateCotton(world, random, xCh, yCh + PHNatura.seaLevel, zCh);
            this.generateCotton(world, random, xCh, yCh + PHNatura.seaLevel, zCh);
        }
        if (PHNatura.generateBluebells && random.nextInt(12) == 0) {
            this.generateBluebells(world, random, xCh, yCh + PHNatura.seaLevel, zCh);
        }
        if (PHNatura.generateRaspberries && random.nextInt(PHNatura.raspSpawnRarity) == 0 && this.goodClimate(biome, 0.6f, 2.0f, 0.2f, 0.93f)) {
            xCh = xChunk + random.nextInt(16);
            yCh = random.nextInt(PHNatura.raspSpawnRange) + PHNatura.seaLevel;
            zCh = zChunk + random.nextInt(16);
            this.raspgen.func_76484_a(world, random, xCh, yCh, zCh);
        }
        if (PHNatura.generateBlueberries && random.nextInt(PHNatura.blueSpawnRarity) == 0 && this.goodClimate(biome, 0.3f, 0.81f, 0.3f, 0.8f)) {
            xCh = xChunk + random.nextInt(16);
            yCh = random.nextInt(PHNatura.blueSpawnRange) + PHNatura.seaLevel;
            zCh = zChunk + random.nextInt(16);
            this.bluegen.func_76484_a(world, random, xCh, yCh, zCh);
        }
        if (PHNatura.generateBlackberries && random.nextInt(PHNatura.blackSpawnRarity) == 0 && this.goodClimate(biome, 0.5f, 5.0f, 0.6f, 3.0f)) {
            xCh = xChunk + random.nextInt(16);
            yCh = random.nextInt(PHNatura.blackSpawnRange) + PHNatura.seaLevel;
            zCh = zChunk + random.nextInt(16);
            this.blackgen.func_76484_a(world, random, xCh, yCh, zCh);
        }
        if (PHNatura.generateBlackberries && random.nextInt(PHNatura.blackSpawnRarity / 3) == 0 && biome == BiomeGenBase.field_76780_h) {
            xCh = xChunk + random.nextInt(16);
            yCh = random.nextInt(PHNatura.blackSpawnRange) + PHNatura.seaLevel;
            zCh = zChunk + random.nextInt(16);
            this.blackgen.func_76484_a(world, random, xCh, yCh, zCh);
        }
        if (PHNatura.generateMaloberries && random.nextInt(PHNatura.geoSpawnRarity) == 0 && this.goodClimate(biome, 0.0f, 0.3f, 0.0f, 5.0f)) {
            xCh = xChunk + random.nextInt(16);
            yCh = random.nextInt(PHNatura.geoSpawnRange) + PHNatura.seaLevel;
            zCh = zChunk + random.nextInt(16);
            this.malogen.func_76484_a(world, random, xCh, yCh, zCh);
        }
        if (world.field_73011_w.field_76575_d) {
            if (PHNatura.generateBlightberries && random.nextInt(PHNatura.blightSpawnRarity) == 0) {
                xCh = xChunk + random.nextInt(16);
                yCh = random.nextInt(PHNatura.blightSpawnRange) + 16;
                zCh = zChunk + random.nextInt(16);
                this.blightgen.func_76484_a(world, random, xCh, yCh, zCh);
            }
            if (PHNatura.generateDuskberries && random.nextInt(PHNatura.duskSpawnRarity) == 0) {
                xCh = xChunk + random.nextInt(16);
                yCh = random.nextInt(PHNatura.duskSpawnRange) + 16;
                zCh = zChunk + random.nextInt(16);
                this.duskgen.func_76484_a(world, random, xCh, yCh, zCh);
            }
            if (PHNatura.generateSkyberries && random.nextInt(PHNatura.skySpawnRarity) == 0) {
                xCh = xChunk + random.nextInt(16);
                yCh = random.nextInt(PHNatura.skySpawnRange) + 16;
                zCh = zChunk + random.nextInt(16);
                this.skygen.func_76484_a(world, random, xCh, yCh, zCh);
            }
            if (PHNatura.generateStingberries && random.nextInt(PHNatura.stingSpawnRarity) == 0) {
                xCh = xChunk + random.nextInt(16);
                yCh = random.nextInt(PHNatura.stingSpawnRange) + 16;
                zCh = zChunk + random.nextInt(16);
                this.stinggen.func_76484_a(world, random, xCh, yCh, zCh);
            }
        }
    }

    public boolean generateBarley(World world, Random random, int x, int y, int z) {
        for (int tries = 0; tries < 64; ++tries) {
            int k1;
            int j1;
            int i1 = x + random.nextInt(8) - random.nextInt(8);
            if (!world.func_147437_c(i1, j1 = y + random.nextInt(4) - random.nextInt(4), k1 = z + random.nextInt(8) - random.nextInt(8)) || !Blocks.field_150327_N.func_149718_j(world, i1, j1, k1)) continue;
            world.func_147465_d(i1, j1, k1, (Block)NContent.crops, 3, 2);
        }
        return true;
    }

    public boolean generateCotton(World world, Random random, int x, int y, int z) {
        for (int tries = 0; tries < 64; ++tries) {
            int k1;
            int j1;
            int i1 = x + random.nextInt(8) - random.nextInt(8);
            if (!world.func_147437_c(i1, j1 = y + random.nextInt(4) - random.nextInt(4), k1 = z + random.nextInt(8) - random.nextInt(8)) || !Blocks.field_150327_N.func_149718_j(world, i1, j1, k1)) continue;
            world.func_147465_d(i1, j1, k1, (Block)NContent.crops, 8, 2);
        }
        return true;
    }

    public boolean generateBluebells(World world, Random random, int x, int y, int z) {
        for (int tries = 0; tries < 40; ++tries) {
            int k1;
            int j1;
            int i1 = x + random.nextInt(8) - random.nextInt(8);
            if (!world.func_147437_c(i1, j1 = y + random.nextInt(8) - random.nextInt(8), k1 = z + random.nextInt(8) - random.nextInt(8)) || !Blocks.field_150327_N.func_149718_j(world, i1, j1, k1)) continue;
            world.func_147465_d(i1, j1, k1, (Block)NContent.bluebells, 0, 2);
        }
        return true;
    }

    public boolean goodClimate(BiomeGenBase biome, float minTemp, float maxTemp, float minRain, float maxRain) {
        float temp = biome.field_76750_F;
        float rain = biome.field_76751_G;
        return minTemp <= temp && temp <= maxTemp && minRain <= rain && rain <= maxRain;
    }
}

