/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.navigator.api.model.layers;

import com.gtnewhorizons.navigator.api.model.SupportedMods;
import com.gtnewhorizons.navigator.api.model.layers.LayerManager;
import com.gtnewhorizons.navigator.api.model.locations.ILocationProvider;
import com.gtnewhorizons.navigator.api.model.steps.RenderStep;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class LayerRenderer {
    protected final LayerManager manager;
    private final SupportedMods mod;
    protected List<? extends RenderStep> renderSteps = new ArrayList<RenderStep>();
    protected final Int2ObjectMap<Long2ObjectMap<RenderStep>> dimCachedRenderSteps = new Int2ObjectOpenHashMap();
    protected Long2ObjectMap<RenderStep> currentDimSteps;
    private final List<RenderStep> visibleSteps = new ArrayList<RenderStep>();

    public LayerRenderer(@Nonnull LayerManager manager, SupportedMods mod) {
        this.mod = mod;
        this.manager = manager;
    }

    public void refreshVisibleElements(Set<ILocationProvider> locations) {
        this.visibleSteps.clear();
        for (ILocationProvider location : locations) {
            RenderStep step = this.getOrCreateRenderStep(location);
            if (step == null) continue;
            this.visibleSteps.add(step);
        }
        this.renderSteps = this.visibleSteps;
    }

    private RenderStep getOrCreateRenderStep(ILocationProvider location) {
        Iterator<? extends RenderStep> iterator;
        long key = location.toLong();
        RenderStep renderStep = (RenderStep)this.currentDimSteps.get(key);
        if (renderStep != null) {
            return renderStep;
        }
        renderStep = this.generateRenderStep(location);
        if (renderStep != null) {
            return (RenderStep)this.currentDimSteps.put(key, (Object)renderStep);
        }
        List<? extends RenderStep> renderSteps = this.generateRenderSteps(Collections.singletonList(location));
        if (renderSteps != null && (iterator = renderSteps.iterator()).hasNext()) {
            RenderStep step = iterator.next();
            return (RenderStep)this.currentDimSteps.put(key, (Object)step);
        }
        return null;
    }

    @Nullable
    protected RenderStep generateRenderStep(ILocationProvider location) {
        return null;
    }

    public final SupportedMods getLayerMod() {
        return this.mod;
    }

    public List<? extends RenderStep> getRenderStepsForInteraction() {
        return this.renderSteps;
    }

    public List<? extends RenderStep> getRenderSteps() {
        return this.renderSteps;
    }

    public List<? extends RenderStep> getReversedRenderSteps() {
        ArrayList<? extends RenderStep> reversed = new ArrayList<RenderStep>(this.renderSteps);
        Collections.reverse(reversed);
        return reversed;
    }

    void removeRenderStep(long key) {
        RenderStep renderStep = (RenderStep)this.currentDimSteps.remove(key);
        this.renderSteps.remove(renderStep);
    }

    void setDimCache(int dim) {
        this.currentDimSteps = (Long2ObjectMap)this.dimCachedRenderSteps.computeIfAbsent(dim, k -> new Long2ObjectOpenHashMap());
    }

    void clearCurrentCache() {
        if (this.currentDimSteps != null) {
            this.currentDimSteps.clear();
        }
        this.visibleSteps.clear();
        this.renderSteps.clear();
    }

    void clearFullCache() {
        this.currentDimSteps = null;
        this.clearCurrentCache();
        this.dimCachedRenderSteps.clear();
    }

    public int getRenderPriority() {
        return 0;
    }

    @Deprecated
    public void updateVisibleElements(List<? extends ILocationProvider> visibleElements) {
    }

    @Deprecated
    protected List<? extends RenderStep> generateRenderSteps(List<? extends ILocationProvider> visibleElements) {
        return null;
    }
}

