/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.navigator.impl;

import com.gtnewhorizons.navigator.api.journeymap.waypoints.JMWaypointManager;
import com.gtnewhorizons.navigator.api.model.SupportedMods;
import com.gtnewhorizons.navigator.api.model.layers.InteractableLayerManager;
import com.gtnewhorizons.navigator.api.model.layers.LayerRenderer;
import com.gtnewhorizons.navigator.api.model.layers.UniversalInteractableRenderer;
import com.gtnewhorizons.navigator.api.model.locations.ILocationProvider;
import com.gtnewhorizons.navigator.api.model.locations.IWaypointAndLocationProvider;
import com.gtnewhorizons.navigator.api.model.waypoints.WaypointManager;
import com.gtnewhorizons.navigator.api.util.ClickPos;
import com.gtnewhorizons.navigator.api.xaero.waypoints.XaeroWaypointManager;
import com.gtnewhorizons.navigator.impl.DirtyChunkButtonManager;
import com.gtnewhorizons.navigator.impl.DirtyChunkLocation;
import com.gtnewhorizons.navigator.impl.DirtyChunkRenderStep;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;

public class DirtyChunkLayerManager
extends InteractableLayerManager {
    public static final DirtyChunkLayerManager INSTANCE = new DirtyChunkLayerManager();

    public DirtyChunkLayerManager() {
        super(new DirtyChunkButtonManager());
    }

    @Override
    @Nullable
    protected LayerRenderer addLayerRenderer(InteractableLayerManager manager, SupportedMods mod) {
        return new UniversalInteractableRenderer(manager).withClickAction(this::onClick).withKeyPressAction(this::onKeyPress).withRenderStep(location -> new DirtyChunkRenderStep((DirtyChunkLocation)location));
    }

    @Override
    @Nullable
    protected WaypointManager addWaypointManager(InteractableLayerManager manager, SupportedMods mod) {
        WaypointManager waypointManager;
        switch (mod) {
            case XaeroWorldMap: {
                waypointManager = new XaeroWaypointManager(manager);
                break;
            }
            case JourneyMap: {
                waypointManager = new JMWaypointManager(manager);
                break;
            }
            default: {
                waypointManager = null;
            }
        }
        return waypointManager;
    }

    @Override
    public void updateElement(IWaypointAndLocationProvider location) {
        int chunkZ;
        int chunkX;
        DirtyChunkLocation loc = (DirtyChunkLocation)location;
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server == null) {
            return;
        }
        WorldServer world = server.func_71218_a(loc.getDimensionId());
        IChunkProvider chunkProvider = world.func_72863_F();
        if (!chunkProvider.func_73149_a(chunkX = loc.getChunkX(), chunkZ = loc.getChunkZ())) {
            return;
        }
        boolean dirty = world.func_72964_e((int)chunkX, (int)chunkZ).field_76643_l;
        loc.setDirty(dirty);
    }

    @Override
    protected ILocationProvider generateLocation(int chunkX, int chunkZ, int dim) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server == null) {
            return null;
        }
        WorldServer world = server.func_71218_a(dim);
        IChunkProvider chunkProvider = world.func_72863_F();
        if (!chunkProvider.func_73149_a(chunkX, chunkZ)) {
            return null;
        }
        boolean dirty = world.func_72964_e((int)chunkX, (int)chunkZ).field_76643_l;
        return new DirtyChunkLocation(chunkX, chunkZ, dim, dirty);
    }

    public boolean onClick(ClickPos pos) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (pos.getRenderStep() == null) {
            player.func_145747_a((IChatComponent)new ChatComponentText("Clicked outside of render step"));
        } else {
            DirtyChunkLocation loc = (DirtyChunkLocation)pos.getRenderStep().getLocation();
            String status = loc.isDirty() ? "dirty" : "clean";
            player.func_145747_a((IChatComponent)new ChatComponentText("Chunk " + loc.getChunkX() + ", " + loc.getChunkZ() + " is " + status));
        }
        return true;
    }

    public boolean onKeyPress(int keyCode) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        player.func_145747_a((IChatComponent)new ChatComponentText("Key pressed: " + keyCode));
        return false;
    }
}

