/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.tileentity;

import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import pcl.opensecurity.ContentRegistry;
import pcl.opensecurity.blocks.BlockSecurityDoor;
import pcl.opensecurity.tileentity.TileEntityMachineBase;
import pcl.opensecurity.tileentity.TileEntitySecureDoor;
import pcl.opensecurity.util.BlockLocation;

public class TileEntityDoorController
extends TileEntityMachineBase
implements Environment {
    public Block block = null;
    public BlockSecurityDoor door;
    private String password = "";
    int doorCoordX;
    int doorCoordY;
    int doorCoordZ;
    String ownerUUID = "";
    public ItemStack[] DoorControllerCamo = new ItemStack[1];
    protected ComponentConnector node = (ComponentConnector)Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(TileEntityDoorController.getComponentName()).withConnector(32.0).create();
    public IIcon[] blockTextures = new IIcon[6];

    public Node node() {
        return this.node;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.node != null) {
            this.node.remove();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.node != null) {
            this.node.remove();
        }
    }

    private static String getComponentName() {
        return "os_door";
    }

    public void onConnect(Node arg0) {
    }

    public void onDisconnect(Node node) {
    }

    public void onMessage(Message arg0) {
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (this.node != null && this.node.host() == this) {
            this.node.load(nbt.func_74775_l("oc:node"));
        }
        this.ownerUUID = nbt.func_74779_i("owner");
        this.password = nbt.func_74779_i("password");
        NBTTagList var2 = nbt.func_150295_c("Items", (int)nbt.func_74732_a());
        this.DoorControllerCamo = new ItemStack[1];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            byte var5 = var4.func_74771_c("Slot");
            if (var5 < 0 || var5 >= this.DoorControllerCamo.length) continue;
            this.DoorControllerCamo[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.node != null && this.node.host() == this) {
            NBTTagCompound nodeNbt = new NBTTagCompound();
            this.node.save(nodeNbt);
            nbt.func_74782_a("oc:node", (NBTBase)nodeNbt);
        }
        nbt.func_74778_a("owner", this.ownerUUID);
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.DoorControllerCamo.length; ++var3) {
            if (this.DoorControllerCamo[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.DoorControllerCamo[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        nbt.func_74782_a("Items", (NBTBase)var2);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.node != null && this.node.network() == null) {
            Network.joinOrCreateNetwork((TileEntity)this);
        }
    }

    public void rescan() {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            this.block = this.field_145850_b.func_147439_a(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
            if (!(this.block instanceof BlockSecurityDoor)) continue;
            this.door = (BlockSecurityDoor)this.block;
            this.doorCoordX = this.field_145851_c + direction.offsetX;
            this.doorCoordY = this.field_145848_d + direction.offsetY;
            this.doorCoordZ = this.field_145849_e + direction.offsetZ;
            if (!(te instanceof TileEntitySecureDoor) || !((TileEntitySecureDoor)te).getPass().isEmpty()) continue;
            ((TileEntitySecureDoor)te).setPassword(this.password);
        }
    }

    @Callback
    public Object[] removePassword(Context context, Arguments args) {
        TileEntitySecureDoor te = (TileEntitySecureDoor)this.field_145850_b.func_147438_o(this.doorCoordX, this.doorCoordY, this.doorCoordZ);
        if (this.ownerUUID.equals(te.getOwner())) {
            if (args.checkString(0).equals(te.getPass())) {
                if (te instanceof TileEntitySecureDoor) {
                    te.setPassword("");
                }
                return new Object[]{true, "Password Removed"};
            }
            return new Object[]{false, "Password was not removed"};
        }
        return new Object[]{false, "Owner of Controller and Door do not match."};
    }

    @Callback
    public Object[] setPassword(Context context, Arguments args) {
        TileEntitySecureDoor te = (TileEntitySecureDoor)this.field_145850_b.func_147438_o(this.doorCoordX, this.doorCoordY, this.doorCoordZ);
        if (this.ownerUUID.equals(te.getOwner())) {
            if (te.getPass().isEmpty()) {
                if (te instanceof TileEntitySecureDoor) {
                    te.setPassword(args.checkString(0));
                }
                return new Object[]{true, "Password set"};
            }
            if (args.checkString(0).equals(te.getPass())) {
                if (te instanceof TileEntitySecureDoor) {
                    te.setPassword(args.checkString(1));
                }
                return new Object[]{true, "Password Changed"};
            }
            return new Object[]{false, "Password was not changed"};
        }
        return new Object[]{false, "Owner of Controller and Door do not match."};
    }

    @Callback
    public Object[] greet(Context context, Arguments args) {
        return new Object[]{"Lasciate ogne speranza, voi ch'intrate"};
    }

    private int getDoorOrientation(BlockDoor door, BlockLocation loc) {
        return door.func_150013_e(loc.blockAccess, loc.x, loc.y, loc.z);
    }

    private boolean isDoorOpen(BlockDoor door, BlockLocation loc) {
        return door.func_150015_f(loc.blockAccess, loc.x, loc.y, loc.z);
    }

    private boolean isDoorMirrored(BlockDoor door, BlockLocation loc) {
        return (door.func_150012_g(loc.blockAccess, loc.x, loc.y, loc.z) & 0x10) != 0;
    }

    @Callback
    public Object[] isOpen(Context context, Arguments args) {
        BlockSecurityDoor door = (BlockSecurityDoor)ContentRegistry.SecurityDoorBlock;
        BlockLocation loc = BlockLocation.get(this.field_145850_b, this.doorCoordX, this.doorCoordY, this.doorCoordZ);
        return new Object[]{this.isDoorOpen(door, loc)};
    }

    @Callback
    public Object[] open(Context context, Arguments args) {
        BlockSecurityDoor door = (BlockSecurityDoor)ContentRegistry.SecurityDoorBlock;
        BlockLocation loc = BlockLocation.get(this.field_145850_b, this.doorCoordX, this.doorCoordY, this.doorCoordZ);
        if (!this.isDoorOpen(door, loc)) {
            return this.toggle(context, args);
        }
        return new Object[]{true};
    }

    @Callback
    public Object[] close(Context context, Arguments args) {
        BlockSecurityDoor door = (BlockSecurityDoor)ContentRegistry.SecurityDoorBlock;
        BlockLocation loc = BlockLocation.get(this.field_145850_b, this.doorCoordX, this.doorCoordY, this.doorCoordZ);
        if (this.isDoorOpen(door, loc)) {
            return this.toggle(context, args);
        }
        return new Object[]{true};
    }

    @Callback
    public Object[] toggle(Context context, Arguments args) {
        BlockLocation loc = BlockLocation.get(this.field_145850_b, this.doorCoordX, this.doorCoordY, this.doorCoordZ);
        this.rescan();
        if (this.node.changeBuffer(-5.0) == 0.0) {
            BlockSecurityDoor door = (BlockSecurityDoor)ContentRegistry.SecurityDoorBlock;
            TileEntitySecureDoor te = (TileEntitySecureDoor)this.field_145850_b.func_147438_o(this.doorCoordX, this.doorCoordY, this.doorCoordZ);
            if (this.ownerUUID.equals(te.getOwner())) {
                if (!te.getPass().isEmpty() && !te.getPass().equals(args.checkString(0))) {
                    return new Object[]{false, "Password Incorrect"};
                }
                int direction = this.getDoorOrientation(door, loc);
                boolean isMirrored = this.isDoorMirrored(door, loc);
                int i = isMirrored ? -1 : 1;
                switch (direction) {
                    case 0: {
                        loc = loc.relative(0, 0, i);
                        break;
                    }
                    case 1: {
                        loc = loc.relative(-i, 0, 0);
                        break;
                    }
                    case 2: {
                        loc = loc.relative(0, 0, -i);
                        break;
                    }
                    case 3: {
                        loc = loc.relative(i, 0, 0);
                        break;
                    }
                }
                if (loc.getBlock() == door && this.getDoorOrientation(door, loc) == direction && this.isDoorMirrored(door, loc) != isMirrored || this.field_145850_b.func_147439_a(this.doorCoordX, this.doorCoordY, this.doorCoordZ) instanceof BlockSecurityDoor) {
                    this.field_145850_b.func_72908_a((double)loc.x + 0.5, (double)loc.y + 0.5, (double)loc.z + 0.5, "opensecurity:security_door", 0.5f, 1.0f);
                    int i1 = this.field_145850_b.func_72805_g(this.doorCoordX, this.doorCoordY, this.doorCoordZ);
                    if ((i1 & 8) == 0) {
                        int doorBottomMeta = this.field_145850_b.func_72805_g(this.doorCoordX, this.doorCoordY, this.doorCoordZ);
                        int j2 = doorBottomMeta & 7;
                        this.field_145850_b.func_72921_c(this.doorCoordX, this.doorCoordY, this.doorCoordZ, j2 ^= 4, 2);
                        this.field_145850_b.func_147458_c(this.doorCoordX, this.doorCoordY, this.doorCoordZ, this.doorCoordX, this.doorCoordY, this.doorCoordZ);
                        if (loc.getBlock() instanceof BlockSecurityDoor) {
                            this.field_145850_b.func_72921_c(loc.x, loc.y, loc.z, j2, 2);
                            this.field_145850_b.func_147458_c(loc.x, loc.y, loc.z, loc.x, loc.y, loc.z);
                        }
                    } else {
                        int doorBottomMeta = this.field_145850_b.func_72805_g(this.doorCoordX, this.doorCoordY - 1, this.doorCoordZ);
                        int j2 = doorBottomMeta & 7;
                        this.field_145850_b.func_72921_c(this.doorCoordX, this.doorCoordY - 1, this.doorCoordZ, j2 ^= 4, 2);
                        this.field_145850_b.func_147458_c(this.doorCoordX, this.doorCoordY - 1, this.doorCoordZ, this.doorCoordX, this.doorCoordY - 1, this.doorCoordZ);
                        if (loc.getBlock() instanceof BlockSecurityDoor) {
                            this.field_145850_b.func_72921_c(loc.x, loc.y - 1, loc.z, j2, 2);
                            this.field_145850_b.func_147458_c(loc.x, loc.y, loc.z - 1, loc.x, loc.y, loc.z);
                        }
                    }
                }
                return new Object[]{!this.isDoorOpen(door, loc)};
            }
            return new Object[]{false, "Owner of Controller and Door do not match."};
        }
        return new Object[]{false, "Not enough power in OC Network."};
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCom = new NBTTagCompound();
        this.func_145841_b(tagCom);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, tagCom);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound tagCom = packet.func_148857_g();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_145839_a(tagCom);
    }

    public void setOwner(String UUID2) {
        this.ownerUUID = UUID2;
    }

    public String getOwner() {
        return this.ownerUUID;
    }

    public void overrideTexture(Block theBlock, ItemStack theItem, ForgeDirection forgeDirection) {
        this.DoorControllerCamo[0] = theItem;
        for (int getSide = 0; getSide < this.blockTextures.length; ++getSide) {
            if (!this.field_145850_b.field_72995_K) continue;
            this.blockTextures[getSide] = theBlock.func_149691_a(getSide, theItem.func_77973_b().getDamage(theItem));
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_145844_m();
    }

    public void overrideTexture(ItemStack theItem) {
        this.DoorControllerCamo[0] = theItem;
        Block theBlock = Block.func_149634_a((Item)theItem.func_77973_b());
        for (int getSide = 0; getSide < this.blockTextures.length; ++getSide) {
            if (!this.field_145850_b.field_72995_K) continue;
            this.blockTextures[getSide] = theBlock.func_149691_a(getSide, theItem.func_77973_b().getDamage(theItem));
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_145844_m();
    }
}

