/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon;

import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.dungeon.DungeonGenerator;
import greymerk.roguelike.dungeon.IDungeon;
import greymerk.roguelike.dungeon.settings.ISettings;
import greymerk.roguelike.dungeon.settings.SettingsResolver;
import greymerk.roguelike.treasure.ITreasureChest;
import greymerk.roguelike.treasure.Treasure;
import greymerk.roguelike.treasure.TreasureManager;
import greymerk.roguelike.treasure.loot.Book;
import greymerk.roguelike.treasure.loot.ILoot;
import greymerk.roguelike.treasure.loot.Loot;
import greymerk.roguelike.util.WeightedChoice;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class Dungeon
implements IDungeon {
    public static SettingsResolver settingsResolver;
    private DungeonGenerator generator = new DungeonGenerator();
    private Coord pos;
    private IWorldEditor editor;

    public static void initResolver() {
        settingsResolver = new SettingsResolver();
    }

    public Dungeon(IWorldEditor editor) {
        this.editor = editor;
    }

    public void generateNear(Random rand, int x, int z) {
        int attempts = 50;
        for (int i = 0; i < attempts; ++i) {
            Coord location = Dungeon.getNearbyCoord(rand, x, z, 40, 100);
            if (!this.validLocation(rand, location.getX(), location.getZ())) continue;
            ISettings setting = settingsResolver.getSettings(this.editor, rand, location);
            if (setting == null) {
                return;
            }
            this.generate(setting, location.getX(), location.getZ());
            return;
        }
    }

    @Override
    public void generate(ISettings settings, int inX, int inZ) {
        this.generator.generate(this.editor, settings, inX, inZ);
        this.pos = new Coord(inX, 50, inZ);
        Random rand = Dungeon.getRandom(this.editor, this.pos.getX(), this.pos.getZ());
        TreasureManager treasure = this.editor.getTreasure();
        ILoot loot = Loot.getLoot();
        settings.getLootRules().process(rand, loot, treasure);
        Book book = new Book("Greymerk", "Statistics");
        book.addPage("~Architect's Resource Notes~\n\nStoneBrick: " + this.editor.getStat(Blocks.field_150417_aV) + "\nCobblestone: " + this.editor.getStat(Blocks.field_150347_e) + "\nLogs: " + (this.editor.getStat(Blocks.field_150364_r) + this.editor.getStat(Blocks.field_150363_s)) + "\nIron Bars: " + this.editor.getStat(Blocks.field_150411_aY) + "\nChests: " + (this.editor.getStat((Block)Blocks.field_150486_ae) + this.editor.getStat(Blocks.field_150447_bR)) + "\nMob Spawners: " + this.editor.getStat(Blocks.field_150474_ac) + "\nTNT: " + this.editor.getStat(Blocks.field_150335_W) + "\n\n-Greymerk");
        book.addPage("Roguelike Dungeons v1.5.0\nApril 16th 2016\n\nCredits\n\nAuthor: Greymerk\n\nBits: Drainedsoul\n\nIdeas: Eniko @enichan");
        treasure.addItemToAll(rand, Treasure.STARTER, new WeightedChoice<ItemStack>(book.get(), 1), 1);
    }

    public static boolean canSpawnInChunk(int chunkX, int chunkZ, IWorldEditor editor) {
        if (!RogueConfig.getBoolean(RogueConfig.DONATURALSPAWN)) {
            return false;
        }
        int frequency = RogueConfig.getInt(RogueConfig.SPAWNFREQUENCY);
        int min = 8 * frequency / 10;
        int max = 32 * frequency / 10;
        min = min < 2 ? 2 : min;
        max = max < 8 ? 8 : max;
        int tempX = chunkX < 0 ? chunkX - (max - 1) : chunkX;
        int tempZ = chunkZ < 0 ? chunkZ - (max - 1) : chunkZ;
        int m = tempX / max;
        int n = tempZ / max;
        Random r = editor.getSeededRandom(m, n, 10387312);
        m *= max;
        n *= max;
        return chunkX == (m += r.nextInt(max - min)) && chunkZ == (n += r.nextInt(max - min));
    }

    @Override
    public void spawnInChunk(Random rand, int chunkX, int chunkZ) {
        if (Dungeon.canSpawnInChunk(chunkX, chunkZ, this.editor)) {
            int x = chunkX * 16 + 4;
            int z = chunkZ * 16 + 4;
            this.generateNear(rand, x, z);
        }
    }

    public static int getLevel(int y) {
        if (y < 15) {
            return 4;
        }
        if (y < 25) {
            return 3;
        }
        if (y < 35) {
            return 2;
        }
        if (y < 45) {
            return 1;
        }
        return 0;
    }

    public boolean validLocation(Random rand, int x, int z) {
        BiomeDictionary.Type[] invalidBiomes;
        BiomeGenBase biome = this.editor.getBiome(new Coord(x, 0, z));
        BiomeDictionary.Type[] biomeType = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
        for (BiomeDictionary.Type type : invalidBiomes = new BiomeDictionary.Type[]{BiomeDictionary.Type.RIVER, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.MUSHROOM, BiomeDictionary.Type.OCEAN}) {
            if (!Arrays.asList(biomeType).contains(type)) continue;
            return false;
        }
        int upperLimit = RogueConfig.getInt(RogueConfig.UPPERLIMIT);
        int lowerLimit = RogueConfig.getInt(RogueConfig.LOWERLIMIT);
        Coord cursor = new Coord(x, upperLimit, z);
        if (!this.editor.isAirBlock(cursor)) {
            return false;
        }
        while (!this.editor.validGroundBlock(cursor)) {
            cursor.add(Cardinal.DOWN);
            if (cursor.getY() < lowerLimit) {
                return false;
            }
            if (this.editor.getBlock(cursor).getMaterial() != Material.field_151586_h) continue;
            return false;
        }
        for (Coord c : new RectSolid(new Coord(x - 4, cursor.getY() + 4, z - 4), new Coord(x + 4, cursor.getY() + 4, z + 4))) {
            if (!this.editor.validGroundBlock(c)) continue;
            return false;
        }
        int airCount = 0;
        for (Coord c : new RectSolid(new Coord(x - 4, cursor.getY() - 3, z - 4), new Coord(x + 4, cursor.getY() - 3, z + 4))) {
            if (!this.editor.validGroundBlock(c)) {
                ++airCount;
            }
            if (airCount <= 8) continue;
            return false;
        }
        return true;
    }

    public static Coord getNearbyCoord(Random rand, int x, int z, int min, int max) {
        int distance = min + rand.nextInt(max - min);
        double angle = rand.nextDouble() * 2.0 * Math.PI;
        int xOffset = (int)(Math.cos(angle) * (double)distance);
        int zOffset = (int)(Math.sin(angle) * (double)distance);
        Coord nearby = new Coord(x + xOffset, 0, z + zOffset);
        return nearby;
    }

    public static Random getRandom(IWorldEditor editor, int x, int z) {
        long seed = editor.getSeed() * (long)x * (long)z;
        Random rand = new Random();
        rand.setSeed(seed);
        return rand;
    }

    @Override
    public List<ITreasureChest> getChests() {
        return this.editor.getTreasure().getChests();
    }

    public Coord getPosition() throws Exception {
        if (this.pos == null) {
            throw new Exception("Dungeon not yet generated");
        }
        return this.pos;
    }

    static {
        Dungeon.initResolver();
    }
}

