/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common.recipes;

import com.gtnewhorizons.tcwands.api.wandinfo.WandDetails;
import com.gtnewhorizons.tcwands.api.wrappers.AbstractWandWrapper;
import dev.rndmorris.salisarcana.api.IMultipleResearchArcaneRecipe;
import dev.rndmorris.salisarcana.common.CustomResearch;
import dev.rndmorris.salisarcana.common.compat.GTNHTCWandsCompat;
import dev.rndmorris.salisarcana.config.SalisConfig;
import dev.rndmorris.salisarcana.lib.AspectHelper;
import dev.rndmorris.salisarcana.lib.WandHelper;
import dev.rndmorris.salisarcana.lib.WandType;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.wands.WandCap;
import thaumcraft.api.wands.WandRod;
import thaumcraft.common.items.wands.ItemWandCasting;

public class ReplaceWandCoreRecipe
implements IArcaneRecipe,
IMultipleResearchArcaneRecipe {
    public boolean matches(IInventory tableInv, World world, EntityPlayer player) {
        if (!ThaumcraftApiHelper.isResearchComplete((String)player.func_70005_c_(), (String)this.getResearch())) {
            return false;
        }
        InvScanResult scanResult = this.scanTable(tableInv);
        if (scanResult == null || scanResult.invalidInputs()) {
            return false;
        }
        return ThaumcraftApiHelper.isResearchComplete((String)player.func_70005_c_(), (String)scanResult.newRod().getResearch());
    }

    public ItemStack getCraftingResult(IInventory tableInv) {
        InvScanResult scanResult = this.scanTable(tableInv);
        if (scanResult == null || scanResult.invalidInputs()) {
            return null;
        }
        ItemWandCasting wandInstance = scanResult.wandInstance();
        if (wandInstance == null) {
            return null;
        }
        ItemStack outputItem = scanResult.wandItem().func_77946_l();
        wandInstance.setRod(outputItem, scanResult.newRod());
        if (SalisConfig.features.preserveWandVis.isEnabled()) {
            int maxVis = wandInstance.getMaxVis(outputItem);
            AspectList newVis = new AspectList();
            AspectList originalVis = wandInstance.getAllVis(outputItem);
            for (Map.Entry entry : originalVis.aspects.entrySet()) {
                newVis.add((Aspect)entry.getKey(), Integer.min(maxVis, (Integer)entry.getValue()));
            }
            wandInstance.storeAllVis(outputItem, newVis);
        } else {
            wandInstance.storeAllVis(outputItem, AspectHelper.primalList(0));
        }
        return outputItem;
    }

    public int getRecipeSize() {
        return 9;
    }

    public ItemStack getRecipeOutput() {
        return null;
    }

    public AspectList getAspects() {
        return null;
    }

    public AspectList getAspects(IInventory tableInv) {
        InvScanResult scanResult = this.scanTable(tableInv);
        if (scanResult == null || scanResult.invalidInputs()) {
            return null;
        }
        ItemWandCasting wandInstance = scanResult.wandInstance();
        if (wandInstance == null) {
            return null;
        }
        int cost = scanResult.wandType().getCraftingVisCost(scanResult.wandCaps(), scanResult.newRod());
        if (cost < 0) {
            return new AspectList();
        }
        return AspectHelper.primalList(cost);
    }

    public String getResearch() {
        return CustomResearch.replaceCoreResearch.key;
    }

    @Nullable
    private InvScanResult scanTable(IInventory tableInv) {
        ItemStack slotItem;
        int slot;
        ItemStack wandItem = null;
        WandRod newRod = null;
        int screwOreID = -1;
        ItemStack conductor = null;
        int screws = 0;
        int conductors = 0;
        for (slot = 0; slot < tableInv.func_70302_i_() && slot < 9; ++slot) {
            slotItem = tableInv.func_70301_a(slot);
            if (slotItem == null) continue;
            WandRod maybeRod = WandHelper.getWandRodFromItem(slotItem);
            if (maybeRod != null) {
                if (newRod != null) {
                    return null;
                }
                newRod = maybeRod;
                continue;
            }
            ItemWandCasting maybeWand = WandHelper.getWandItem(slotItem);
            if (maybeWand == null) continue;
            if (wandItem != null) {
                return null;
            }
            wandItem = slotItem;
        }
        if (SalisConfig.modCompat.gtnhWands.coreSwapMaterials.isEnabled() && wandItem != null && newRod != null) {
            AbstractWandWrapper wrapper = GTNHTCWandsCompat.getWandWrapper(newRod, WandType.getWandType(wandItem));
            if (wrapper == null) {
                return null;
            }
            WandDetails props = wrapper.getDetails();
            screwOreID = OreDictionary.getOreID((String)props.getScrew());
            conductor = props.getConductor();
        }
        for (slot = 0; slot < tableInv.func_70302_i_() && slot < 9; ++slot) {
            slotItem = tableInv.func_70301_a(slot);
            if (slotItem == null || slotItem == wandItem || WandHelper.getWandRodFromItem(slotItem) == newRod) continue;
            if (!SalisConfig.modCompat.gtnhWands.coreSwapMaterials.isEnabled()) {
                return null;
            }
            boolean matched = false;
            if (conductor != null && slotItem.func_77969_a(conductor)) {
                ++conductors;
                matched = true;
            } else if (screwOreID != -1) {
                for (int id : OreDictionary.getOreIDs((ItemStack)slotItem)) {
                    if (id != screwOreID) continue;
                    ++screws;
                    matched = true;
                    break;
                }
            }
            if (matched) continue;
            return null;
        }
        return new InvScanResult(wandItem, newRod, screws, conductors);
    }

    @Override
    public String[] salisArcana$getResearches(IInventory inv, World world, EntityPlayer player) {
        InvScanResult scan = this.scanTable(inv);
        if (scan == null || scan.invalidInputs()) {
            return new String[]{this.getResearch()};
        }
        return new String[]{this.getResearch(), scan.newRod().getResearch()};
    }

    private static final class InvScanResult {
        private final ItemStack wandItem;
        private final WandRod newRod;
        private final int screws;
        private final int conductors;

        private InvScanResult(ItemStack wandItem, WandRod newRod, int screws, int conductors) {
            this.wandItem = wandItem;
            this.newRod = newRod;
            this.screws = screws;
            this.conductors = conductors;
        }

        public boolean invalidInputs() {
            if (this.wandItem == null || this.newRod == null) {
                return true;
            }
            if (SalisConfig.features.enforceWandCoreTypes.isEnabled() && !this.wandType().isCoreSuitable(this.newRod)) {
                return true;
            }
            WandRod oldRod = this.oldRod();
            if (oldRod == null || this.newRod == oldRod) {
                return true;
            }
            if (!SalisConfig.modCompat.gtnhWands.coreSwapMaterials.isEnabled()) {
                return false;
            }
            return this.screws != this.getRequiredScrews() || this.conductors != 2;
        }

        public int getRequiredScrews() {
            if (this.wandType() == WandType.SCEPTER || this.wandType() == WandType.STAFFTER) {
                return 2;
            }
            return 4;
        }

        @Nullable
        public WandCap wandCaps() {
            return WandHelper.getWandCapFromWand(this.wandItem);
        }

        @Nullable
        public ItemWandCasting wandInstance() {
            return WandHelper.getWandItem(this.wandItem);
        }

        @Nullable
        public WandRod oldRod() {
            return WandHelper.getWandRodFromWand(this.wandItem);
        }

        @Nonnull
        public WandType wandType() {
            return WandType.getWandType(this.wandItem);
        }

        public String toString() {
            return "InvScanResult[" + "wandItem=" + this.wandItem + "," + "newRod=" + this.newRod + "," + "screws=" + this.screws + "," + "conductors=" + this.conductors + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.wandItem != null ? this.wandItem.hashCode() : 0);
            result = 31 * result + (this.newRod != null ? this.newRod.hashCode() : 0);
            result = 31 * result + this.screws;
            result = 31 * result + this.conductors;
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((InvScanResult)arg0).wandItem, this.wandItem)) {
                return false;
            }
            if (!Objects.equals(((InvScanResult)arg0).newRod, this.newRod)) {
                return false;
            }
            if (((InvScanResult)arg0).screws != this.screws) {
                return false;
            }
            return ((InvScanResult)arg0).conductors == this.conductors;
            {
            }
        }

        public ItemStack wandItem() {
            return this.wandItem;
        }

        public WandRod newRod() {
            return this.newRod;
        }

        public int screws() {
            return this.screws;
        }

        public int conductors() {
            return this.conductors;
        }
    }
}

