/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.core;

import dev.rndmorris.salisarcana.core.SalisArcanaCore;
import dev.rndmorris.salisarcana.core.asm.IAsmEditor;
import net.minecraft.launchwrapper.IClassTransformer;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.ClassWriter;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.MethodNode;

public class SalisArcanaClassTransformer
implements IClassTransformer {
    public byte[] transform(String s, String s1, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        for (IAsmEditor editor : SalisArcanaCore.editors) {
            if (!s1.equals(editor.getClassName())) continue;
            bytes = this.updateMethod(bytes, editor);
        }
        return bytes;
    }

    private byte[] updateMethod(byte[] bytes, IAsmEditor editor) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode(327680);
        reader.accept((ClassVisitor)node, 0);
        boolean foundMethod = false;
        for (MethodNode method : node.methods) {
            if (!method.name.equals(editor.getMethodName()) || !method.desc.equals(editor.getMethodDesc())) continue;
            foundMethod = true;
            editor.edit(method);
        }
        if (!foundMethod) {
            throw new RuntimeException("SalisArcana failed to find a method named " + editor.getMethodName() + " in class " + editor.getClassName());
        }
        ClassWriter writer = new ClassWriter(1);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

