/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.config.settings;

import dev.rndmorris.salisarcana.config.IDependant;
import dev.rndmorris.salisarcana.config.IEnabler;
import dev.rndmorris.salisarcana.config.IHaveSettings;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.Configuration;

public abstract class Setting
implements IDependant {
    public static final String defaultCategory = "general";
    @Nullable
    protected final WeakReference<IEnabler> enabledDependency;
    @Nullable
    private WeakReference<IHaveSettings> settingOwner;
    protected boolean enabled = true;
    @Nullable
    private String category;

    public Setting(IEnabler dependency) {
        this.enabledDependency = new WeakReference<IEnabler>(dependency);
        this.autoRegisterOwner();
    }

    public <T extends Setting> T setCategory(String category) {
        this.category = category;
        return (T)this;
    }

    public String getCategory() {
        if (this.category == null) {
            return defaultCategory;
        }
        return this.category;
    }

    @Override
    public boolean isEnabled() {
        if (!this.enabled) {
            return false;
        }
        if (this.enabledDependency == null) {
            return true;
        }
        IEnabler dependency = (IEnabler)this.enabledDependency.get();
        return dependency != null && dependency.isEnabled();
    }

    public <T extends Setting> T setEnabled(boolean enabled) {
        this.enabled = enabled;
        return (T)this;
    }

    @Override
    public IEnabler getDependency() {
        return this.enabledDependency != null ? (IEnabler)this.enabledDependency.get() : null;
    }

    private void autoRegisterOwner() {
        IEnabler dependency = this.getDependency();
        HashSet<IEnabler> visited = new HashSet<IEnabler>();
        while (dependency != null) {
            if (visited.contains(dependency)) {
                throw new RuntimeException("Encountered a circular setting dependency!");
            }
            visited.add(dependency);
            if (dependency instanceof IHaveSettings) {
                IHaveSettings hasSettings = (IHaveSettings)((Object)dependency);
                this.registerTo(hasSettings);
                break;
            }
            if (dependency instanceof IDependant) {
                IDependant dependant = (IDependant)dependency;
                dependency = dependant.getDependency();
                continue;
            }
            throw new RuntimeException("No IHaveSettings found in the dependency tree.");
        }
    }

    private void unregisterFromOwner() {
        IHaveSettings owner;
        if (this.settingOwner != null && (owner = (IHaveSettings)this.settingOwner.get()) != null) {
            owner.unregisterSetting(this);
            this.settingOwner = null;
        }
    }

    public <T extends Setting> T registerTo(IHaveSettings newOwner) {
        this.unregisterFromOwner();
        this.settingOwner = new WeakReference<IHaveSettings>(newOwner);
        newOwner.registerSetting(this);
        return (T)this;
    }

    public abstract void loadFromConfiguration(Configuration var1);
}

