/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.config;

import dev.rndmorris.salisarcana.config.IEnabler;
import dev.rndmorris.salisarcana.config.IHaveSettings;
import dev.rndmorris.salisarcana.config.SalisConfig;
import dev.rndmorris.salisarcana.config.settings.Setting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.Configuration;

public abstract class ConfigGroup
implements IEnabler,
IHaveSettings {
    private boolean enabled = true;
    protected final List<Setting> settings = new ArrayList<Setting>();

    public ConfigGroup() {
        SalisConfig.groups.add(this);
    }

    public void loadFromConfig(@Nonnull Configuration configuration) {
        for (CategoryComment comment : this.getCategoryComments()) {
            configuration.addCustomCategoryComment(comment.categoryId(), comment.comment());
        }
        for (Setting setting : this.settings) {
            setting.loadFromConfiguration(configuration);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Nonnull
    public abstract String getGroupName();

    @Nonnull
    public abstract String getGroupComment();

    @Override
    public Collection<Setting> getSettings() {
        return this.settings;
    }

    protected Collection<CategoryComment> getCategoryComments() {
        return Collections.emptyList();
    }

    protected static class CategoryComment {
        private final String categoryId;
        private final String comment;

        public CategoryComment(String categoryId, String comment) {
            this.categoryId = categoryId;
            this.comment = comment;
        }

        public String categoryId() {
            return this.categoryId;
        }

        public String comment() {
            return this.comment;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CategoryComment)) {
                return false;
            }
            CategoryComment that = (CategoryComment)o;
            return Objects.equals(this.categoryId, that.categoryId) && Objects.equals(this.comment, that.comment);
        }

        public int hashCode() {
            return Objects.hash(this.categoryId, this.comment);
        }
    }
}

