/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common.commands;

import dev.rndmorris.salisarcana.SalisArcana;
import dev.rndmorris.salisarcana.common.commands.arguments.ArgumentProcessor;
import dev.rndmorris.salisarcana.config.settings.CommandSettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public abstract class ArcanaCommandBase<T>
extends CommandBase {
    protected final CommandSettings settings;
    protected final ArgumentProcessor<T> argumentProcessor;

    public ArcanaCommandBase(@Nonnull CommandSettings settings) {
        settings.setCommandGetter(() -> this);
        this.settings = settings;
        this.argumentProcessor = this.initializeProcessor();
    }

    @Nonnull
    protected abstract ArgumentProcessor<T> initializeProcessor();

    public String func_71517_b() {
        return this.settings.getFullName();
    }

    public List<String> func_71514_a() {
        return new ArrayList<String>(this.settings.aliases);
    }

    public String func_71518_a(ICommandSender sender) {
        return String.format("%s:command.%s.usage", "salisarcana", this.settings.name);
    }

    public int func_82362_a() {
        return this.settings.getPermissionLevel();
    }

    public boolean func_71519_b(ICommandSender sender) {
        return this.func_82362_a() == 0 || super.func_71519_b(sender);
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length < this.minimumRequiredArgs()) {
            this.printUsage(sender);
            return;
        }
        try {
            this.process(sender, this.argumentProcessor.process(sender, args), args);
        }
        catch (Exception ex) {
            if (ex instanceof CommandException) {
                CommandException ce = (CommandException)ex;
                throw ce;
            }
            SalisArcana.LOG.error(String.format("An error occurred for player %s while executing /%s.", sender.func_70005_c_(), String.join((CharSequence)" ", args)), (Throwable)ex);
            sender.func_145747_a(new ChatComponentTranslation("salisarcana:command.error.execute", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
        }
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        try {
            return CommandBase.func_71531_a((String[])args, this.argumentProcessor.getAutocompletionSuggestions(sender, args));
        }
        catch (Exception ex) {
            SalisArcana.LOG.error(String.format("An error occurred for player %s while providing tab completion for /%s.", sender.func_70005_c_(), String.join((CharSequence)" ", args)), (Throwable)ex);
            sender.func_145747_a(new ChatComponentTranslation("salisarcana:command.error.tabcomplete", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
            return null;
        }
    }

    protected ChatStyle titleStyle() {
        ChatStyle titleStyle = new ChatStyle();
        titleStyle.func_150227_a(Boolean.valueOf(true));
        titleStyle.func_150238_a(EnumChatFormatting.BLUE);
        return titleStyle;
    }

    public void printHelp(ICommandSender sender) {
        ChatStyle titleStyle = this.titleStyle();
        ChatComponentTranslation description = new ChatComponentTranslation("salisarcana:command.desc", new Object[0]);
        description.func_150255_a(titleStyle);
        description.func_150258_a(" ");
        ChatComponentTranslation descriptionText = new ChatComponentTranslation(String.format("salisarcana:command.%s.desc", this.settings.name), new Object[0]);
        descriptionText.func_150256_b().func_150238_a(EnumChatFormatting.RESET).func_150227_a(Boolean.valueOf(false));
        description.func_150257_a((IChatComponent)descriptionText);
        ChatComponentTranslation usageTitle = new ChatComponentTranslation("salisarcana:command.usage", new Object[0]);
        usageTitle.func_150255_a(titleStyle);
        ChatComponentTranslation argumentsTitle = new ChatComponentTranslation("salisarcana:command.args", new Object[0]);
        argumentsTitle.func_150255_a(titleStyle);
        Stream<ChatComponentTranslation> first = Arrays.stream(new ChatComponentTranslation[]{description, usageTitle, new ChatComponentTranslation(String.format("salisarcana:command.%s.usage", this.settings.name), new Object[0]), argumentsTitle});
        Stream<ChatComponentTranslation> descLangKeys = this.argumentProcessor.descriptionLangKeys.stream().map(key -> new ChatComponentTranslation(String.format("salisarcana:command.%s.args.%s", this.settings.name, key), new Object[0]));
        Stream.concat(first, descLangKeys).forEachOrdered(arg_0 -> ((ICommandSender)sender).func_145747_a(arg_0));
    }

    public void printUsage(ICommandSender sender) {
        sender.func_145747_a(new ChatComponentTranslation("salisarcana:command.usage", new Object[0]).func_150255_a(this.titleStyle()));
        sender.func_145747_a((IChatComponent)new ChatComponentTranslation(this.func_71518_a(sender), new Object[0]));
    }

    protected abstract int minimumRequiredArgs();

    protected abstract void process(ICommandSender var1, T var2, String[] var3);
}

