/*
 * Decompiled with CFR 0.152.
 */
package net.glease.structurecompat;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.PowerMultiplier;
import appeng.api.features.ILocatable;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.implementations.tiles.IViewCellStorage;
import appeng.api.implementations.tiles.IWirelessAccessPoint;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IMachineSet;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.DimensionalCoord;
import appeng.items.storage.ItemViewCell;
import appeng.tile.networking.TileWireless;
import appeng.util.prioitylist.IPartitionList;
import com.gtnewhorizon.structurelib.util.InventoryIterable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import net.glease.structurecompat.MEInventoryStackExtractor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;

abstract class WirelessTerminalStackExtractor
extends MEInventoryStackExtractor {
    WirelessTerminalStackExtractor() {
    }

    public boolean isValidSource(ItemStack source, EntityPlayerMP player) {
        return AEApi.instance().registries().wireless().isWirelessTerminal(source);
    }

    @Override
    protected Pair<IEnergySource, IMEInventoryHandler<IAEItemStack>> fromItem(ItemStack source, EntityPlayerMP player) {
        long serial;
        if (!AEApi.instance().registries().wireless().isWirelessTerminal(source)) {
            return null;
        }
        IWirelessTermHandler wh = AEApi.instance().registries().wireless().getWirelessTerminalHandler(source);
        if (wh == null) {
            return null;
        }
        String key = wh.getEncryptionKey(source);
        try {
            serial = Long.parseLong(key);
        }
        catch (NumberFormatException e) {
            return null;
        }
        ILocatable locatable = AEApi.instance().registries().locatable().getLocatableBy(serial);
        if (!(locatable instanceof IGridHost)) {
            return null;
        }
        IGridNode gn = ((IGridHost)locatable).getGridNode(ForgeDirection.UNKNOWN);
        if (gn == null) {
            return null;
        }
        IGrid grid = gn.getGrid();
        if (grid == null) {
            return null;
        }
        IStorageGrid sg = (IStorageGrid)grid.getCache(IStorageGrid.class);
        if (sg == null) {
            return null;
        }
        IMEMonitor rawInventory = sg.getItemInventory();
        if (rawInventory == null) {
            return null;
        }
        if (!this.rangeCheck(source, player, grid)) {
            return null;
        }
        WirelessTerminalEnergySource power = new WirelessTerminalEnergySource(wh, source, player);
        IViewCellStorage viewCellStorage = this.getViewCellStorage(source);
        IPartitionList filter = viewCellStorage == null ? null : ItemViewCell.createFilter((ItemStack[])((ItemStack[])StreamSupport.stream(new InventoryIterable(viewCellStorage.getViewCellStorage()).spliterator(), false).toArray(ItemStack[]::new)));
        if (filter == null) {
            return Pair.of((Object)power, (Object)rawInventory);
        }
        return Pair.of((Object)power, (Object)new ExtractionFilteredMEInventoryHandler((IMEMonitor<IAEItemStack>)rawInventory, filter));
    }

    protected boolean rangeCheck(ItemStack source, EntityPlayerMP player, IGrid targetGrid) {
        IMachineSet tw = targetGrid.getMachines(TileWireless.class);
        for (IGridNode n : tw) {
            double range;
            double distZ;
            double distY;
            double distX;
            double dist;
            IWirelessAccessPoint wap = (IWirelessAccessPoint)n.getMachine();
            DimensionalCoord loc = wap.getLocation();
            if (!loc.isInWorld(player.func_130014_f_()) || !((dist = (distX = player.field_70165_t - (double)loc.x) * distX + (distY = player.field_70163_u - (double)loc.y) * distY + (distZ = player.field_70161_v - (double)loc.z) * distZ) < (range = wap.getRange()) * range)) continue;
            return true;
        }
        return false;
    }

    protected abstract IViewCellStorage getViewCellStorage(ItemStack var1);

    private static class ExtractionFilteredMEInventoryHandler
    implements IMEInventoryHandler<IAEItemStack> {
        private final IMEMonitor<IAEItemStack> rawInventory;
        private final IPartitionList<IAEItemStack> filter;

        public ExtractionFilteredMEInventoryHandler(IMEMonitor<IAEItemStack> rawInventory, IPartitionList<IAEItemStack> filter) {
            this.rawInventory = rawInventory;
            this.filter = filter;
        }

        public AccessRestriction getAccess() {
            return this.rawInventory.getAccess();
        }

        public boolean isPrioritized(IAEItemStack input) {
            return this.rawInventory.isPrioritized((IAEStack)input);
        }

        public boolean canAccept(IAEItemStack input) {
            return this.rawInventory.canAccept((IAEStack)input);
        }

        public int getPriority() {
            return this.rawInventory.getPriority();
        }

        public int getSlot() {
            return this.rawInventory.getSlot();
        }

        public boolean validForPass(int i) {
            return this.rawInventory.validForPass(i);
        }

        public IAEItemStack injectItems(IAEItemStack input, Actionable type, BaseActionSource src) {
            return (IAEItemStack)this.rawInventory.injectItems((IAEStack)input, type, src);
        }

        public IAEItemStack extractItems(IAEItemStack request, Actionable mode, BaseActionSource src) {
            if (!this.filter.isListed((IAEStack)request)) {
                return null;
            }
            return (IAEItemStack)this.rawInventory.extractItems((IAEStack)request, mode, src);
        }

        public IItemList<IAEItemStack> getAvailableItems(final IItemList<IAEItemStack> out) {
            return this.rawInventory.getAvailableItems((IItemList)new IItemList<IAEItemStack>(){

                public void addStorage(IAEItemStack option) {
                    if (filter.isListed((IAEStack)option)) {
                        out.addStorage((IAEStack)option);
                    }
                }

                public void addCrafting(IAEItemStack option) {
                    if (filter.isListed((IAEStack)option)) {
                        out.addCrafting((IAEStack)option);
                    }
                }

                public void addRequestable(IAEItemStack option) {
                    if (filter.isListed((IAEStack)option)) {
                        out.addRequestable((IAEStack)option);
                    }
                }

                public IAEItemStack getFirstItem() {
                    return (IAEItemStack)out.getFirstItem();
                }

                public int size() {
                    return out.size();
                }

                public Iterator<IAEItemStack> iterator() {
                    return out.iterator();
                }

                public void resetStatus() {
                    out.resetStatus();
                }

                public void add(IAEItemStack option) {
                    out.add((IAEStack)option);
                }

                public IAEItemStack findPrecise(IAEItemStack i) {
                    return (IAEItemStack)out.findPrecise((IAEStack)i);
                }

                public Collection<IAEItemStack> findFuzzy(IAEItemStack input, FuzzyMode fuzzy) {
                    return out.findFuzzy((IAEStack)input, fuzzy);
                }

                public boolean isEmpty() {
                    return out.isEmpty();
                }

                public void forEach(Consumer<? super IAEItemStack> action) {
                    out.forEach(action);
                }

                public Spliterator<IAEItemStack> spliterator() {
                    return out.spliterator();
                }
            });
        }

        public StorageChannel getChannel() {
            return this.rawInventory.getChannel();
        }
    }

    private static class WirelessTerminalEnergySource
    implements IEnergySource {
        private final IWirelessTermHandler wth;
        private final ItemStack is;
        private final EntityPlayerMP player;

        public WirelessTerminalEnergySource(IWirelessTermHandler wth, ItemStack is, EntityPlayerMP player) {
            this.wth = wth;
            this.is = is;
            this.player = player;
        }

        public double extractAEPower(double amt, Actionable mode, PowerMultiplier usePowerMultiplier) {
            if (this.wth != null && this.is != null) {
                if (mode == Actionable.SIMULATE) {
                    return this.wth.hasPower((EntityPlayer)this.player, amt, this.is) ? amt : 0.0;
                }
                return this.wth.usePower((EntityPlayer)this.player, amt, this.is) ? amt : 0.0;
            }
            return 0.0;
        }
    }
}

